/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.image.eztwain;

import edu.berkeley.guir.lib.awt.image.FrameGrabber;
import edu.berkeley.guir.lib.awt.image.SimpleTwainSource;
import edu.berkeley.guir.lib.awt.image.eztwain.EZTwainWrapper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SimpleEZTwainSource
implements SimpleTwainSource,
Runnable {
    protected Vector vecConsumers = new Vector();
    protected EZTwainWrapper eztWrapper = new EZTwainWrapper();
    protected boolean boolMulti = false;
    protected Thread threadMulti = null;
    protected int hwnd = 0;
    protected boolean boolTransferred = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.awt.image.eztwain.SimpleEZTwainSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void setParent(Component parent) {
        if (parent == null) {
            this.hwnd = 0;
            return;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void selectSource() {
        this.eztWrapper.selectImageSource(this.hwnd);
    }

    public void addConsumer(ImageConsumer ic) {
        if (!this.vecConsumers.contains(ic)) {
            this.vecConsumers.add(ic);
        }
    }

    public void removeConsumer(ImageConsumer ic) {
        this.vecConsumers.remove(ic);
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.vecConsumers.contains(ic);
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void setMultiTransfer(boolean boolSet) {
        this.boolMulti = boolSet;
        if (this.boolMulti) {
            this.eztWrapper.setMultiTransfer(1);
        } else {
            this.eztWrapper.setMultiTransfer(0);
        }
    }

    public boolean getMultiTransfer() {
        return this.boolMulti;
    }

    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        if (this.threadMulti == null || !this.threadMulti.isAlive()) {
            this.threadMulti = new Thread(this);
            this.threadMulti.start();
        }
    }

    public void run() {
        boolean boolTransferred = false;
        do {
            ImageConsumer ic;
            int handle;
            if ((handle = this.eztWrapper.acquireNative(this.hwnd, 0)) == 0) {
                Vector v = (Vector)this.vecConsumers.clone();
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    ic = (ImageConsumer)i.next();
                    if (!this.boolMulti || boolTransferred) {
                        ic.imageComplete(3);
                        continue;
                    }
                    ic.imageComplete(4);
                }
                if (this.boolMulti) {
                    this.eztWrapper.closeSource();
                    this.eztWrapper.closeSourceManager(this.hwnd);
                    this.eztWrapper.unloadSourceManager();
                    boolTransferred = false;
                }
                return;
            }
            int x = this.eztWrapper.dibWidth(handle);
            int y = this.eztWrapper.dibHeight(handle);
            byte[] buf = new byte[3 * x];
            int[] imagedata = new int[x * y];
            Hashtable ht = new Hashtable();
            DirectColorModel cm = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
            int i = 0;
            while (i < y) {
                this.eztWrapper.dibReadRowRGB(handle, i, buf);
                int j = 0;
                while (j < x) {
                    int r = buf[3 * j];
                    r = r < 0 ? r + 256 : r;
                    int g = buf[3 * j + 1];
                    g = g < 0 ? g + 256 : g;
                    int b = buf[3 * j + 2];
                    b = b < 0 ? b + 256 : b;
                    imagedata[i * x + j] = r | (g <<= 8) | (b <<= 16) | 0xFF000000;
                    ++j;
                }
                ++i;
            }
            this.eztWrapper.freeNative(handle);
            Vector v = (Vector)this.vecConsumers.clone();
            Iterator i2 = v.iterator();
            while (i2.hasNext()) {
                ic = (ImageConsumer)i2.next();
                ic.setColorModel(cm);
                ic.setDimensions(x, y);
                ic.setProperties(ht);
                ic.setHints(1);
                ic.setPixels(0, 0, x, y, (ColorModel)cm, imagedata, 0, x);
                if (this.boolMulti) {
                    ic.imageComplete(2);
                    boolTransferred = true;
                    continue;
                }
                ic.imageComplete(3);
            }
        } while (this.boolMulti);
    }

    public static void main(String[] strArgs) {
        SimpleEZTwainSource source = new SimpleEZTwainSource();
        source.setMultiTransfer(true);
        source.show();
    }

    public void show() {
        TestFrame test = new TestFrame(this);
    }

    public class TestFrame
    extends Frame {
        protected ImageProducer ip;
        protected Image img;
        protected Vector vecImages = new Vector();
        protected FrameGrabber fg = new FrameGrabber();

        TestFrame(ImageProducer ip) {
            this.show();
            this.ip = ip;
            ip.startProduction(this.fg);
        }

        public void paint(Graphics g) {
            int y = 25;
            Iterator i = this.fg.getImages().iterator();
            while (i.hasNext()) {
                System.out.println(y);
                Image bimg = (Image)i.next();
                g.drawImage(bimg, 0, y, this);
                y += bimg.getHeight(this);
            }
        }
    }
}

