/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Vector;

public class FrameGrabber
implements ImageConsumer {
    protected Vector vecImages = new Vector();
    protected BufferedImage bimgCurrent = null;
    protected Hashtable hashCurrent = new Hashtable();
    protected ColorModel modelCurrent = ColorModel.getRGBdefault();
    protected int intWidth = -1;
    protected int intHeight = -1;
    protected Vector vecObservers = new Vector();

    public Vector getImages() {
        return (Vector)this.vecImages.clone();
    }

    public void clearImages() {
        this.vecImages.clear();
    }

    public void addObserver(ImageObserver io) {
        if (io != null && !this.vecObservers.contains(io)) {
            this.vecObservers.add(io);
        }
    }

    public void removeObserver(ImageObserver io) {
        if (io != null) {
            this.vecObservers.remove(io);
        }
    }

    public void setProperties(Hashtable props) {
        this.hashCurrent = props;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel cm, int[] pixels, int off, int scansize) {
        if (this.bimgCurrent == null && this.intWidth > 0 && this.intHeight > 0) {
            this.bimgCurrent = this.modelCurrent == null ? new BufferedImage(this.intWidth, this.intHeight, 1) : new BufferedImage(this.modelCurrent, this.modelCurrent.createCompatibleWritableRaster(this.intWidth, this.intHeight), this.modelCurrent.isAlphaPremultiplied(), this.hashCurrent);
        }
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int pix = pixels[x + j + (y + i) * scansize];
                this.bimgCurrent.setRGB(x + j, y + i, cm.getRGB(pix));
                ++j;
            }
            ++i;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel cm, byte[] pixels, int off, int scansize) {
    }

    public void setColorModel(ColorModel model) {
        this.modelCurrent = model;
    }

    public void imageComplete(int status) {
        switch (status) {
            case 2: 
            case 3: {
                if (this.bimgCurrent == null) break;
                this.vecImages.add(this.bimgCurrent);
                int intFlags = 3;
                intFlags |= status == 2 ? 16 : 32;
                int i = 0;
                while (i < this.vecObservers.size()) {
                    ((ImageObserver)this.vecObservers.elementAt(i)).imageUpdate(this.bimgCurrent, intFlags, 0, 0, this.intWidth, this.intHeight);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.vecObservers.size()) {
                    ((ImageObserver)this.vecObservers.elementAt(i)).imageUpdate(null, 128, 0, 0, 0, 0);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.vecObservers.size()) {
                    ((ImageObserver)this.vecObservers.elementAt(i)).imageUpdate(null, 64, 0, 0, 0, 0);
                    ++i;
                }
                break;
            }
        }
        this.bimgCurrent = null;
        this.hashCurrent = new Hashtable();
        this.modelCurrent = ColorModel.getRGBdefault();
        this.intHeight = -1;
        this.intWidth = -1;
    }

    public void setDimensions(int width, int height) {
        this.intWidth = width;
        this.intHeight = height;
    }

    public void setHints(int hintflags) {
    }
}

