/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.geom;

import edu.berkeley.guir.lib.awt.geom.Interpolation;

public class SlowInSlowOut2Interpolation
extends Interpolation {
    double bounds;
    double percentTimeAtBounds;

    public SlowInSlowOut2Interpolation() {
        this(0.2, 0.4);
    }

    public SlowInSlowOut2Interpolation(double bounds, double val) {
        if (bounds < 0.0 || bounds > 0.5) {
            throw new IllegalArgumentException("Value for bounds outside range");
        }
        if (val < 0.0 || val > 0.5) {
            throw new IllegalArgumentException("Bounds value outside range");
        }
        this.bounds = bounds;
        this.percentTimeAtBounds = val;
    }

    public double interpolate(double startValue, double endValue, int current, int total) {
        if (current >= total) {
            return endValue;
        }
        if (current < 0) {
            return startValue;
        }
        double t = (double)current / (double)total;
        double dv = endValue - startValue;
        double ds = t < this.bounds ? t * this.percentTimeAtBounds / this.bounds : (t > 1.0 - this.bounds ? 1.0 - this.percentTimeAtBounds + (t - (1.0 - this.bounds)) * this.percentTimeAtBounds / this.bounds : this.percentTimeAtBounds + (t - this.bounds) * (1.0 - 2.0 * this.percentTimeAtBounds) / (1.0 - 2.0 * this.bounds));
        return startValue + ds * dv;
    }

    public static void main(String[] argv) {
        SlowInSlowOut2Interpolation interp = new SlowInSlowOut2Interpolation();
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 0, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 1, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 2, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 3, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 4, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 5, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 6, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 7, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 8, 10));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 9, 10));
        System.out.println();
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 0, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 1, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 2, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 3, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 4, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 5, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 6, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 7, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 8, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 9, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 10, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 11, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 12, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 13, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 14, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 15, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 16, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 17, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 18, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 19, 20));
        System.out.println(((Interpolation)interp).interpolate(0.0, 1.0, 20, 20));
    }
}

