/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;

public class ShapeLineIterator {
    PathIterator it;
    float[] ptsArray = new float[6];
    double lastX;
    double lastY;

    public ShapeLineIterator(PathIterator it) {
        this.it = it;
        if (!it.isDone()) {
            it.currentSegment(this.ptsArray);
            it.next();
            this.lastX = this.ptsArray[0];
            this.lastY = this.ptsArray[1];
        }
    }

    public ShapeLineIterator(Shape s) {
        this(s, new AffineTransform());
    }

    public ShapeLineIterator(Shape s, AffineTransform tx) {
        this(s.getPathIterator(tx));
    }

    public boolean isDone() {
        return this.it.isDone();
    }

    public boolean hasNext() {
        return !this.it.isDone();
    }

    public Line2D next() {
        return this.next(new Line2D.Double());
    }

    public Line2D next(Line2D line) {
        if (this.it.isDone()) {
            throw new RuntimeException("You need to check if this ShapeLineIterator has more lines or not through hasNext()");
        }
        this.it.currentSegment(this.ptsArray);
        this.it.next();
        line.setLine(this.lastX, this.lastY, this.ptsArray[0], this.ptsArray[1]);
        this.lastX = this.ptsArray[0];
        this.lastY = this.ptsArray[1];
        return line;
    }
}

