/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.geom;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.ShapeLineIterator;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.WeakHashMap;
import sun.awt.geom.Crossings;

public class Polygon2D
implements Cloneable,
Shape {
    private static final double FLOATING_PT_TOLERANCE = 0.001;
    static WeakHashMap cacheSimplified = new WeakHashMap(5000);
    float minX = Float.POSITIVE_INFINITY;
    float minY = Float.POSITIVE_INFINITY;
    float maxX = Float.NEGATIVE_INFINITY;
    float maxY = Float.NEGATIVE_INFINITY;
    public int npoints = 0;
    public float[] xpoints = new float[35];
    public float[] ypoints = new float[35];
    boolean flagClosed = true;
    boolean flagDirty = true;
    Rectangle2D bounds;

    public Polygon2D() {
    }

    public Polygon2D(Rectangle r) {
        this.addPoint(r.x, r.y);
        this.addPoint(r.x + r.width, r.y);
        this.addPoint(r.x + r.width, r.y + r.height);
        this.addPoint(r.x, r.y + r.height);
    }

    public Polygon2D(Shape s) {
        this(s.getPathIterator(null));
    }

    public Polygon2D(PathIterator it) {
        this.setToPathIterator(it);
    }

    public Polygon2D(int[] xpoints, int[] ypoints, int npoints) {
        int i = 0;
        while (i < npoints) {
            this.addPoint(xpoints[i], ypoints[i]);
            ++i;
        }
    }

    public Polygon2D(float[] xpoints, float[] ypoints, int npoints) {
        int i = 0;
        while (i < npoints) {
            this.addPoint(xpoints[i], ypoints[i]);
            ++i;
        }
    }

    public Polygon2D(float[] xpoints, float[] ypoints, int start, int len) {
        int i = start;
        while (i < start + len) {
            this.addPoint(xpoints[i], ypoints[i]);
            ++i;
        }
    }

    private boolean isInBoundsInternal(double x, double y) {
        return !(x < (double)this.minX || x > (double)this.maxX || y < (double)this.minY) && !(y > (double)this.maxY);
    }

    private void updateInternal() {
        if (this.flagDirty) {
            this.flagDirty = false;
            if (this.npoints <= 0) {
                this.bounds = null;
            } else if (this.npoints == 1) {
                this.bounds = new Rectangle2D.Float(this.minX, this.minY, 0.0f, 0.0f);
            } else {
                float w = this.maxX - this.minX;
                float h = this.maxY - this.minY;
                if ((double)w < 0.001) {
                    w = 0.0f;
                }
                if ((double)h < 0.001) {
                    h = 0.0f;
                }
                this.bounds = new Rectangle2D.Float(this.minX, this.minY, w, h);
            }
        }
    }

    private Rectangle2D getBounds2DInternal() {
        this.updateInternal();
        return this.bounds;
    }

    private Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
        Crossings.EvenOdd cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
        float lastx = this.xpoints[this.npoints - 1];
        float lasty = this.ypoints[this.npoints - 1];
        int i = 0;
        while (i < this.npoints) {
            float curx = this.xpoints[i];
            float cury = this.ypoints[i];
            if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                return null;
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return cross;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.isInBoundsInternal(x, y)) {
            return false;
        }
        hits = 0;
        lastx = this.xpoints[this.npoints - 1];
        lasty = this.ypoints[this.npoints - 1];
        i = 0;
        while (i < this.npoints) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = this.xpoints[i];
                                cury = this.ypoints[i];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= (double)lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= (double)curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < (double)cury || y >= (double)lasty) break block8;
                        if (!(x < (double)leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - (double)curx;
                    test2 = y - (double)cury;
                    ** GOTO lbl35
                }
                if (y < (double)lasty || y >= (double)cury) break block8;
                if (x < (double)leftx) {
                    ++hits;
                } else {
                    test1 = x - (double)lastx;
                    test2 = y - (double)lasty;
lbl35:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return (hits & true) != false;
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBounds2DInternal().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross != null && cross.covers(y, y + h);
    }

    public boolean contains(Point2D pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        Rectangle2D r = this.getBounds2DInternal();
        if (r == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D r = this.getBounds2DInternal();
        if (r == null) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return new Rectangle2D.Float((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform tx) {
        return new PolygonPathIterator(this, tx);
    }

    public PathIterator getPathIterator(AffineTransform tx, double flatness) {
        return this.getPathIterator(tx);
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBounds2DInternal().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross == null || !cross.isEmpty();
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public void setToShape(Shape s) {
        this.setToPathIterator(s.getPathIterator(null));
    }

    public void setToPathIterator(PathIterator it) {
        this.npoints = 0;
        this.setClosed(false);
        float[] ptsArray = new float[6];
        FlatteningPathIterator fpi = new FlatteningPathIterator(it, 1.0);
        while (!fpi.isDone()) {
            int segtype = fpi.currentSegment(ptsArray);
            switch (segtype) {
                case 4: {
                    this.setClosed(true);
                    break;
                }
                default: {
                    this.addPoint(ptsArray[0], ptsArray[1]);
                }
            }
            fpi.next();
        }
        this.updateBounds();
        this.flagDirty = true;
    }

    public void setPoly(Polygon2D poly) {
        if (this.xpoints.length < poly.xpoints.length) {
            this.xpoints = new float[poly.xpoints.length];
            this.ypoints = new float[poly.xpoints.length];
        }
        System.arraycopy(poly.xpoints, 0, this.xpoints, 0, poly.npoints);
        System.arraycopy(poly.ypoints, 0, this.ypoints, 0, poly.npoints);
        this.npoints = poly.npoints;
        this.flagDirty = true;
        this.updateBounds();
    }

    public void setPoly(Polygon poly) {
        if (this.xpoints.length < poly.xpoints.length) {
            this.xpoints = new float[poly.xpoints.length];
            this.ypoints = new float[poly.xpoints.length];
        }
        int i = 0;
        while (i < poly.npoints) {
            this.xpoints[i] = poly.xpoints[i];
            this.ypoints[i] = poly.ypoints[i];
            ++i;
        }
        this.npoints = poly.npoints;
        this.flagDirty = true;
        this.updateBounds();
    }

    public void setClosed(boolean flag) {
        this.flagClosed = flag;
    }

    public boolean isClosed() {
        return this.flagClosed;
    }

    private void setArraySize(int newlen) {
        float[] xpointsNew = new float[newlen];
        float[] ypointsNew = new float[newlen];
        boolean flagUpdate = newlen < this.npoints;
        System.arraycopy(this.xpoints, 0, xpointsNew, 0, Math.min(this.npoints, newlen));
        System.arraycopy(this.ypoints, 0, ypointsNew, 0, Math.min(this.npoints, newlen));
        this.xpoints = xpointsNew;
        this.ypoints = ypointsNew;
        if (flagUpdate) {
            this.flagDirty = true;
            this.npoints = newlen;
            this.updateBounds();
        }
    }

    public void trim() {
        if (this.npoints > 0 && this.xpoints.length > this.npoints) {
            this.setArraySize(this.npoints);
        }
    }

    public void addPoint(Point2D pt) {
        this.addPoint(pt.getX(), pt.getY());
    }

    public void addPoint(double x, double y) {
        if (this.xpoints.length <= this.npoints) {
            this.setArraySize(2 * this.xpoints.length);
        }
        this.xpoints[this.npoints] = (float)x;
        this.ypoints[this.npoints] = (float)y;
        ++this.npoints;
        this.updateBounds(x, y);
        this.flagDirty = true;
    }

    public void clearPoints() {
        this.npoints = 0;
    }

    public void translate(double dx, double dy) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + (float)dx;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + (float)dy;
        }
        this.minX += (float)dx;
        this.minY += (float)dy;
        this.maxX += (float)dx;
        this.maxY += (float)dy;
        this.flagDirty = true;
    }

    private void updateBounds() {
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.npoints) {
            this.updateBounds(this.xpoints[i], this.ypoints[i]);
            ++i;
        }
    }

    private void updateBounds(double x, double y) {
        if (x > (double)this.maxX) {
            this.maxX = (float)x;
        }
        if (x < (double)this.minX) {
            this.minX = (float)x;
        }
        if (y > (double)this.maxY) {
            this.maxY = (float)y;
        }
        if (y < (double)this.minY) {
            this.minY = (float)y;
        }
    }

    public Polygon2D simplify() {
        if (this.npoints < 10) {
            return this;
        }
        Object obj = cacheSimplified.get(this.xpoints);
        if (obj != null) {
            return (Polygon2D)obj;
        }
        double[] dThetaArray = new double[this.npoints];
        Polygon2D simplePoly = new Polygon2D();
        double thetaNew = Math.atan2(this.xpoints[0], this.ypoints[0]);
        dThetaArray[0] = Double.MAX_VALUE;
        int i = 1;
        while (i < dThetaArray.length) {
            double thetaOld = thetaNew;
            thetaNew = Math.atan2(this.xpoints[i], this.ypoints[i]);
            dThetaArray[i] = Math.abs(thetaNew - thetaOld);
            ++i;
        }
        i = 0;
        while (i < dThetaArray.length) {
            if (i == 0 || i == dThetaArray.length - 1) {
                simplePoly.addPoint(this.xpoints[i], this.ypoints[i]);
            } else if (dThetaArray[i] <= dThetaArray[i - 1] && dThetaArray[i] <= dThetaArray[i + 1]) {
                simplePoly.addPoint(this.xpoints[i], this.ypoints[i]);
            }
            ++i;
        }
        simplePoly.setClosed(this.isClosed());
        cacheSimplified.put(this.xpoints, simplePoly);
        return simplePoly;
    }

    public void transform(AffineTransform tx) {
        float[] fpts = new float[2 * this.npoints];
        int i = 0;
        while (i < this.npoints) {
            int index = 2 * i;
            fpts[index] = this.xpoints[i];
            fpts[index + 1] = this.ypoints[i];
            ++i;
        }
        tx.transform(fpts, 0, fpts, 0, this.npoints);
        i = 0;
        while (i < fpts.length) {
            if (i % 2 == 0) {
                this.xpoints[i / 2] = fpts[i];
            } else {
                this.ypoints[i / 2] = fpts[i];
            }
            ++i;
        }
        this.flagDirty = true;
        this.updateBounds();
    }

    public Polygon2D transformCopy(AffineTransform tx) {
        Polygon2D p = (Polygon2D)this.clone();
        p.transform(tx);
        return p;
    }

    public boolean isNormalized() {
        boolean flagY;
        boolean flagX = (double)Math.abs(this.minX) < 0.001;
        boolean bl = flagY = (double)Math.abs(this.minY) < 0.001;
        return flagX && flagY;
    }

    public Point2D normalize() {
        Rectangle2D r = this.getBounds2D();
        this.translate((float)(-r.getX()), (float)(-r.getY()));
        this.flagDirty = true;
        return new Point2D.Float((float)(-r.getX()), (float)(-r.getY()));
    }

    public void paste(Polygon2D p) {
        if (this.isClosed() && !p.isClosed()) {
            return;
        }
        if (!this.intersects(p.getBounds2D())) {
            return;
        }
        Area areaA = new Area(this);
        Area areaB = new Area(p);
        areaA.add(areaB);
        if (!areaA.isSingular()) {
            return;
        }
        PathIterator it = areaA.getPathIterator(null);
        this.setToPathIterator(it);
    }

    public void cut(Polygon2D p) {
        if (this.isClosed() && !p.isClosed()) {
            return;
        }
        if (!this.intersects(p.getBounds2D())) {
            return;
        }
        Area areaA = new Area(this);
        Area areaB = new Area(p);
        areaA.subtract(areaB);
        if (!areaA.isSingular()) {
            return;
        }
        PathIterator it = areaA.getPathIterator(null);
        this.setToPathIterator(it);
    }

    public double perimeter() {
        float[] ptsArray = new float[6];
        PolygonPathIterator it = new PolygonPathIterator(this, null);
        double len = 0.0;
        float origX = 0.0f;
        float origY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        while (!it.isDone()) {
            int segtype = it.currentSegment(ptsArray);
            switch (segtype) {
                case 0: {
                    origX = ptsArray[0];
                    origY = ptsArray[1];
                    lastX = origX;
                    lastY = origY;
                    break;
                }
                case 4: {
                    len += (double)GeomLib.distance(lastX, lastY, origX, origY);
                    break;
                }
                default: {
                    len += (double)GeomLib.distance(lastX, lastY, ptsArray[0], ptsArray[1]);
                    lastX = ptsArray[0];
                    lastY = ptsArray[1];
                }
            }
            it.next();
        }
        return len;
    }

    public float minDistance(double x, double y) {
        Line2D.Double lstLine;
        double dis;
        if (this.isClosed() && this.contains(x, y)) {
            return 0.0f;
        }
        if (this.npoints == 1) {
            Point2D.Double firstPoint = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
            return (float)firstPoint.distance(x, y);
        }
        double minDistance = 3.4028234663852886E38;
        Line2D line = new Line2D.Float();
        ShapeLineIterator it = new ShapeLineIterator(new PolygonPathIterator(this, null));
        while (it.hasNext()) {
            double tmpDistance = (line = it.next(line)).ptSegDist(x, y);
            if (!(tmpDistance < minDistance)) continue;
            minDistance = tmpDistance;
        }
        if (this.isClosed() && (dis = (lstLine = new Line2D.Double(this.xpoints[0], this.ypoints[0], this.xpoints[this.xpoints.length - 1], this.ypoints[this.ypoints.length - 1])).ptSegDist(x, y)) < minDistance) {
            minDistance = dis;
        }
        return (float)minDistance;
    }

    public float minDistance(Polygon p) {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < p.npoints) {
            min = Math.min(min, this.minDistance(p.xpoints[i], p.ypoints[i]));
            ++i;
        }
        return min;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer(10 * this.npoints);
        strbuf.append("[");
        int i = 0;
        while (i < this.npoints) {
            strbuf.append("(" + this.xpoints[i] + "," + this.ypoints[i] + ")");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public Object clone() {
        Polygon2D ret = new Polygon2D();
        this.clone(ret);
        return ret;
    }

    public Object clone(Polygon2D p) {
        p.minX = this.minX;
        p.minY = this.minY;
        p.maxX = this.maxX;
        p.maxY = this.maxY;
        p.npoints = this.npoints;
        p.xpoints = new float[this.npoints];
        p.ypoints = new float[this.npoints];
        int i = 0;
        while (i < this.npoints) {
            p.xpoints[i] = this.xpoints[i];
            p.ypoints[i] = this.ypoints[i];
            ++i;
        }
        p.flagClosed = this.flagClosed;
        return p;
    }

    public static void main(String[] argv) {
        int segtype;
        Polygon2D paa = new Polygon2D();
        paa.addPoint(0.0, 0.0);
        paa.addPoint(10.0, 0.0);
        paa.addPoint(10.0, 10.0);
        paa.addPoint(0.0, 10.0);
        paa.setClosed(true);
        System.out.println(paa);
        Polygon2D pbb = new Polygon2D(paa);
        System.out.println(pbb);
        System.out.println("------------");
        Polygon2D p1 = new Polygon2D();
        float[] pts = new float[6];
        p1.addPoint(0.0, 0.0);
        p1.addPoint(10.0, 0.0);
        p1.addPoint(10.0, 10.0);
        p1.addPoint(0.0, 10.0);
        p1.setClosed(true);
        Polygon2D p2 = (Polygon2D)p1.clone();
        p2.setClosed(false);
        PathIterator it = p1.getPathIterator(null);
        while (!it.isDone()) {
            segtype = it.currentSegment(pts);
            System.out.println(String.valueOf(StringLib.getSegmentType(segtype)) + " " + pts[0] + " " + pts[1]);
            it.next();
        }
        System.out.println();
        it = p2.getPathIterator(null);
        while (!it.isDone()) {
            segtype = it.currentSegment(pts);
            System.out.println(String.valueOf(StringLib.getSegmentType(segtype)) + " " + pts[0] + " " + pts[1]);
            it.next();
        }
    }

    private class PolygonPathIterator
    implements PathIterator {
        Polygon2D poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(Polygon2D p, AffineTransform tx) {
            this.poly = p;
            this.transform = tx;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            if (Polygon2D.this.flagClosed) {
                return this.index > this.poly.npoints;
            }
            return this.index >= this.poly.npoints;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] coords2) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords2[0] = this.poly.xpoints[this.index];
            coords2[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords2, 0, coords2, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords2) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords2[0] = this.poly.xpoints[this.index];
            coords2[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords2, 0, coords2, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

