/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.geom;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.awt.geom.ShapeLineIterator;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public final class GeomLib {
    static WeakHashMap cache = new WeakHashMap(500);

    private GeomLib() {
    }

    public static final Polygon clonePolygon(Polygon p) {
        int nPts = p.npoints;
        int[] xPts = new int[nPts];
        int[] yPts = new int[nPts];
        System.arraycopy(p.xpoints, 0, xPts, 0, nPts);
        System.arraycopy(p.ypoints, 0, yPts, 0, nPts);
        return new Polygon(xPts, yPts, nPts);
    }

    public static final Polygon makePolygon(Rectangle rect) {
        Polygon p = new Polygon();
        p.addPoint(rect.x, rect.y);
        p.addPoint(rect.x + rect.width, rect.y);
        p.addPoint(rect.x + rect.width, rect.y + rect.height);
        p.addPoint(rect.x, rect.y + rect.height);
        return p;
    }

    public static final Polygon makePolygon(Rectangle2D rect) {
        Polygon p = new Polygon();
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        p.addPoint(x, y);
        p.addPoint(x + w, y);
        p.addPoint(x + w, y + h);
        p.addPoint(x, y + h);
        return p;
    }

    public static final Polygon makePolygon(Shape s) {
        ShapeLineIterator it = new ShapeLineIterator(s);
        Polygon p = new Polygon();
        Line2D.Double line = new Line2D.Double();
        if (it.hasNext()) {
            it.next(line);
            p.addPoint((int)((Line2D)line).getX2(), (int)((Line2D)line).getY2());
        }
        while (it.hasNext()) {
            it.next(line);
            p.addPoint((int)((Line2D)line).getX2(), (int)((Line2D)line).getY2());
        }
        return p;
    }

    public static final Rectangle2D makeRectangle(float x1, float y1, float x2, float y2) {
        return GeomLib.makeRectangle(x1, y1, x2, y2, 0.0f);
    }

    public static final Rectangle2D makeRectangle(float x1, float y1, float x2, float y2, float halo) {
        return new Rectangle2D.Float(Math.min(x1, x2) - halo, Math.min(y1, y2) - halo, Math.abs(x2 - x1) + 2.0f * halo, Math.abs(y2 - y1) + 2.0f * halo);
    }

    public static final Rectangle2D makeRectangle(Point2D ptAA, Point2D ptBB) {
        return GeomLib.makeRectangle((float)ptAA.getX(), (float)ptAA.getY(), (float)ptBB.getX(), (float)ptBB.getY(), 0.0f);
    }

    public static final Rectangle2D makeRectangle(Point2D ptAA, Point2D ptBB, float halo) {
        return GeomLib.makeRectangle((float)ptAA.getX(), (float)ptAA.getY(), (float)ptBB.getX(), (float)ptBB.getY(), halo);
    }

    public static final Polygon simplify(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints < 8) {
            return new Polygon(xpoints, ypoints, npoints);
        }
        Object obj = cache.get(xpoints);
        if (obj != null) {
            return (Polygon)obj;
        }
        double[] dThetaArray = new double[npoints];
        Polygon simplePoly = new Polygon();
        double thetaNew = Math.atan2(xpoints[0], ypoints[0]);
        dThetaArray[0] = Double.MAX_VALUE;
        int i = 1;
        while (i < dThetaArray.length) {
            double thetaOld = thetaNew;
            thetaNew = Math.atan2(xpoints[i], ypoints[i]);
            dThetaArray[i] = Math.abs(thetaNew - thetaOld);
            ++i;
        }
        i = 0;
        while (i < dThetaArray.length) {
            if (i == 0 || i == dThetaArray.length - 1) {
                simplePoly.addPoint(xpoints[i], ypoints[i]);
            } else if (dThetaArray[i] <= dThetaArray[i - 1] && dThetaArray[i] <= dThetaArray[i + 1]) {
                simplePoly.addPoint(xpoints[i], ypoints[i]);
            }
            ++i;
        }
        cache.put(xpoints, simplePoly);
        return simplePoly;
    }

    public static final Polygon simplify(Polygon p) {
        return GeomLib.simplify(p.xpoints, p.ypoints, p.npoints);
    }

    public static AffineTransform calcPassthrough(AffineTransform txA, AffineTransform txB, AffineTransform txOut) {
        if (txOut == null) {
            txOut = new AffineTransform();
        }
        txOut.setTransform(txA);
        txOut.concatenate(txB);
        try {
            txOut.preConcatenate(txB.createInverse());
        }
        catch (Exception e) {
            System.err.println("This error should never happen");
            System.err.println(e);
        }
        return txOut;
    }

    private static float[] polygonToArray(Polygon p) {
        float[] fptsOld = new float[2 * p.npoints];
        int i = 0;
        while (i < p.npoints) {
            int index = 2 * i;
            fptsOld[index] = p.xpoints[i];
            fptsOld[index + 1] = p.ypoints[i];
            ++i;
        }
        return fptsOld;
    }

    public static Polygon transformPolygonInPlace(AffineTransform tx, Polygon p) {
        float[] fpts = GeomLib.polygonToArray(p);
        tx.transform(fpts, 0, fpts, 0, p.npoints);
        int i = 0;
        while (i < fpts.length) {
            if (i % 2 == 0) {
                p.xpoints[i / 2] = (int)fpts[i];
            } else {
                p.ypoints[i / 2] = (int)fpts[i];
            }
            ++i;
        }
        return p;
    }

    public static Polygon transformPolygon(AffineTransform tx, Polygon p) {
        return GeomLib.transformPolygonInPlace(tx, GeomLib.clonePolygon(p));
    }

    public static Rectangle2D transformRectangle(AffineTransform tx, Rectangle2D rSrc) {
        return GeomLib.transformRectangle(tx, rSrc, new Rectangle2D.Double());
    }

    public static Rectangle2D transformRectangle(AffineTransform tx, Rectangle2D rSrc, Rectangle2D rDst) {
        double y2;
        double y1;
        double x2;
        double x1;
        double[] rectArray = new double[]{rSrc.getX(), rSrc.getY(), rSrc.getX() + rSrc.getWidth(), rSrc.getY(), rSrc.getX() + rSrc.getWidth(), rSrc.getY() + rSrc.getHeight(), rSrc.getX(), rSrc.getY() + rSrc.getHeight()};
        tx.transform(rectArray, 0, rectArray, 0, 4);
        int min = rectArray[0] < rectArray[2] ? 0 : 2;
        if (rectArray[4] < rectArray[6]) {
            x1 = Math.min(rectArray[4], rectArray[min]);
            x2 = Math.max(rectArray[6], rectArray[(min + 2) % 4]);
        } else {
            x1 = Math.min(rectArray[6], rectArray[min]);
            x2 = Math.max(rectArray[4], rectArray[(min + 2) % 4]);
        }
        min = rectArray[1] < rectArray[3] ? 1 : 3;
        if (rectArray[5] < rectArray[7]) {
            y1 = Math.min(rectArray[5], rectArray[min]);
            y2 = Math.max(rectArray[7], rectArray[(min + 2) % 4]);
        } else {
            y1 = Math.min(rectArray[7], rectArray[min]);
            y2 = Math.max(rectArray[5], rectArray[(min + 2) % 4]);
        }
        rDst.setRect(x1, y1, x2 - x1, y2 - y1);
        return rDst;
    }

    public static final Polygon pathIteratorToPolygon(PathIterator it) {
        Polygon p = new Polygon();
        float[] ptsArray = new float[6];
        while (!it.isDone()) {
            int segmentType = it.currentSegment(ptsArray);
            Point2D newPt = GeomLib.getEndPointOfPathIteratorSegment(segmentType, ptsArray);
            if (newPt != null) {
                p.addPoint((int)newPt.getX(), (int)newPt.getY());
            }
            it.next();
        }
        return p;
    }

    public static final Polygon2D pathIteratorToPolygon2D(PathIterator it) {
        Polygon2D p = new Polygon2D();
        float[] ptsArray = new float[6];
        p.setClosed(false);
        while (!it.isDone()) {
            int segmentType = it.currentSegment(ptsArray);
            Point2D newPt = GeomLib.getEndPointOfPathIteratorSegment(segmentType, ptsArray);
            if (newPt != null) {
                p.addPoint(newPt);
            } else {
                p.setClosed(true);
            }
            it.next();
        }
        return p;
    }

    public static final Point2D getEndPointOfPathIteratorSegment(int segmentType, float[] coords2) {
        Point2D.Float endPoint = null;
        if (segmentType == 1 || segmentType == 0) {
            endPoint = new Point2D.Float(coords2[0], coords2[1]);
        } else if (segmentType == 2) {
            endPoint = new Point2D.Float(coords2[2], coords2[3]);
        } else if (segmentType == 3) {
            endPoint = new Point2D.Float(coords2[4], coords2[5]);
        }
        return endPoint;
    }

    public static final Polygon mergePolygons(Polygon a, Polygon b) {
        Rectangle rectB;
        Rectangle rectA = a.getBounds();
        if (!rectA.intersects(rectB = b.getBounds())) {
            return a;
        }
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.add(areaB);
        if (!areaA.isSingular()) {
            return a;
        }
        PathIterator it = areaA.getPathIterator(new AffineTransform());
        return GeomLib.pathIteratorToPolygon(it);
    }

    public static final Polygon cutPolygon(Polygon a, Polygon b) {
        Rectangle rectB;
        Rectangle rectA = a.getBounds();
        if (!rectA.intersects(rectB = b.getBounds())) {
            return a;
        }
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.subtract(areaB);
        if (!areaA.isSingular()) {
            return a;
        }
        PathIterator it = areaA.getPathIterator(new AffineTransform());
        return GeomLib.pathIteratorToPolygon(it);
    }

    public static final double minDistance(Shape saa, Shape sbb) {
        double mind = Double.MAX_VALUE;
        double tmpd = Double.MAX_VALUE;
        float[] ptaa = new float[6];
        float[] ptbb = new float[6];
        PathIterator itaa = saa.getPathIterator(null);
        while (!itaa.isDone()) {
            itaa.currentSegment(ptaa);
            PathIterator itbb = sbb.getPathIterator(null);
            while (!itbb.isDone()) {
                itbb.currentSegment(ptbb);
                tmpd = GeomLib.distance(ptaa[0], ptaa[1], ptbb[0], ptbb[1]);
                mind = Math.min(mind, tmpd);
                itbb.next();
            }
            itaa.next();
        }
        return mind;
    }

    public static final float minDistance(Polygon p, int x, int y) {
        double minDistance = 3.4028234663852886E38;
        Line2D line = new Line2D.Float();
        ShapeLineIterator it = new ShapeLineIterator(p.getPathIterator(new AffineTransform()));
        while (it.hasNext()) {
            double tmpDistance = (line = it.next(line)).ptSegDist(x, y);
            if (!(tmpDistance < minDistance)) continue;
            minDistance = tmpDistance;
        }
        return (float)minDistance;
    }

    public static final float minDistance(Polygon polyA, Polygon polyB) {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < polyB.npoints) {
            min = Math.min(min, GeomLib.minDistance(polyA, polyB.xpoints[i], polyB.ypoints[i]));
            ++i;
        }
        return min;
    }

    public static final float minDistanceToCenter(Rectangle r, int x, int y) {
        return GeomLib.distance(x, y, r.width / 2, r.height / 2);
    }

    public static final float distance(int x1, int y1, int x2, int y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static final float distance(double x1, double y1, double x2, double y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static final float distance(Point2D p1, Point2D p2) {
        return GeomLib.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final List calcIntersectPoints(Line2D l, Shape s) {
        ShapeLineIterator it = new ShapeLineIterator(s);
        LinkedList<Point2D> list = new LinkedList<Point2D>();
        while (it.hasNext()) {
            Line2D line = it.next();
            Point2D pt = GeomLib.calcIntersectPoint(l, line);
            if (pt == null) continue;
            list.add(pt);
        }
        return list;
    }

    public static final Point2D calcIntersectPoint(Line2D lAA, Line2D lBB) {
        return GeomLib.calcIntersectPoint(lAA.getX1(), lAA.getY1(), lAA.getX2(), lAA.getY2(), lBB.getX1(), lBB.getY1(), lBB.getX2(), lBB.getY2());
    }

    public static final Point2D calcIntersectPoint(double xa1, double ya1, double xa2, double ya2, double xb1, double yb1, double xb2, double yb2) {
        Point2D.Double pt = null;
        if (!Line2D.linesIntersect(xa1, ya1, xa2, ya2, xb1, yb1, xb2, yb2)) {
            return pt;
        }
        double dxa = xa2 - xa1;
        double dya = ya2 - ya1;
        double dxb = xb2 - xb1;
        double dyb = yb2 - yb1;
        double a = (ya1 * dxb - yb1 * dxb - xa1 * dyb + xb1 * dyb) / (dxa * dyb - dya * dxb);
        pt = new Point2D.Double(xa1 + a * dxa, ya1 + a * dya);
        return pt;
    }
}

