/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt.geom;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Interpolation;
import edu.berkeley.guir.lib.awt.geom.LinearInterpolation;
import edu.berkeley.guir.lib.awt.geom.SlowInSlowOutInterpolation;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class AffineTransformLib {
    private static boolean flagApproxScale = false;

    public static boolean getApproxScale() {
        return flagApproxScale;
    }

    public static void setApproxScale(boolean flag) {
        flagApproxScale = flag;
    }

    private AffineTransformLib() {
    }

    public static AffineTransform scaleAndCenterAt(double scale, double x, double y, Rectangle2D rect) {
        AffineTransform tx = AffineTransform.getTranslateInstance(rect.getWidth() / 2.0, rect.getHeight() / 2.0);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public static AffineTransform scaleAndKeepConstant(double scale, double x, double y) {
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public static AffineTransform[] interpolate(AffineTransform txStart, AffineTransform txFinish, Interpolation intrp, int numFrames) {
        AffineTransform[] txArray = new AffineTransform[numFrames];
        double[] startMatrix = new double[6];
        double[] finishMatrix = new double[6];
        double[] tmpMatrix = new double[6];
        txStart.getMatrix(startMatrix);
        txFinish.getMatrix(finishMatrix);
        int i = 0;
        while (i < numFrames) {
            tmpMatrix[0] = intrp.interpolate(startMatrix[0], finishMatrix[0], i, numFrames);
            tmpMatrix[1] = intrp.interpolate(startMatrix[1], finishMatrix[1], i, numFrames);
            tmpMatrix[2] = intrp.interpolate(startMatrix[2], finishMatrix[2], i, numFrames);
            tmpMatrix[3] = intrp.interpolate(startMatrix[3], finishMatrix[3], i, numFrames);
            tmpMatrix[4] = intrp.interpolate(startMatrix[4], finishMatrix[4], i, numFrames);
            tmpMatrix[5] = intrp.interpolate(startMatrix[5], finishMatrix[5], i, numFrames);
            txArray[i] = new AffineTransform(tmpMatrix);
            ++i;
        }
        try {
            i = numFrames - 1;
            while (i >= 1) {
                txArray[i].concatenate(txArray[i - 1].createInverse());
                --i;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return txArray;
    }

    public static AffineTransform[] animateLinearly(AffineTransform txFinish, int numFrames) {
        return AffineTransformLib.interpolate(new AffineTransform(), txFinish, new LinearInterpolation(), numFrames);
    }

    public static AffineTransform[] animateSlowInSlowOut(AffineTransform txFinish, int numFrames) {
        return AffineTransformLib.interpolate(new AffineTransform(), txFinish, new SlowInSlowOutInterpolation(), numFrames);
    }

    public static AffineTransform resize(Rectangle2D oldRect, Rectangle2D newRect) {
        double scaleX = newRect.getWidth() / oldRect.getWidth();
        double scaleY = newRect.getHeight() / oldRect.getHeight();
        AffineTransform txScale = AffineTransform.getScaleInstance(scaleX, scaleY);
        Rectangle2D tmpRect = GeomLib.transformRectangle(txScale, oldRect);
        AffineTransform txTranslate = AffineTransform.getTranslateInstance(newRect.getX() - tmpRect.getX(), newRect.getY() - tmpRect.getY());
        txTranslate.concatenate(txScale);
        return txTranslate;
    }

    public static final double getScaleFactor(AffineTransform tx) {
        if (flagApproxScale) {
            return tx.getScaleX();
        }
        Point2D.Float ptAA = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float ptBB = new Point2D.Float(0.0f, 1.0f);
        tx.transform(ptAA, ptAA);
        tx.transform(ptBB, ptBB);
        double x1 = ((Point2D)ptAA).getX();
        double y1 = ((Point2D)ptAA).getY();
        double x2 = ((Point2D)ptBB).getX();
        double y2 = ((Point2D)ptBB).getY();
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y2 - y1) * (y2 - y1));
    }

    public static final Point2D getTranslateFactor(AffineTransform tx) {
        Point2D.Float ptAA = new Point2D.Float();
        ((Point2D)ptAA).setLocation(0.0, 0.0);
        tx.transform(ptAA, ptAA);
        return ptAA;
    }

    public static final double getRotationFactor(AffineTransform tx) {
        double[] matrix = new double[6];
        tx.getMatrix(matrix);
        double scale = AffineTransformLib.getScaleFactor(tx);
        matrix[0] = matrix[0] / scale;
        matrix[1] = matrix[1] / scale;
        if (matrix[0] > 1.0) {
            matrix[0] = 1.0;
        }
        if (matrix[0] < -1.0) {
            matrix[0] = -1.0;
        }
        if (matrix[1] > 1.0) {
            matrix[1] = 1.0;
        }
        if (matrix[1] < -1.0) {
            matrix[1] = -1.0;
        }
        double theta_x1 = Math.acos(matrix[0]);
        double theta_x2 = Math.PI * 2 - theta_x1;
        double theta_y1 = Math.asin(matrix[1]);
        double theta_y2 = Math.PI - theta_y1;
        if (theta_y1 < 0.0) {
            theta_y1 += Math.PI * 2;
        }
        if (theta_y2 < 0.0) {
            theta_y2 += Math.PI * 2;
        }
        if (AffineTransformLib.nearEquals(theta_x1, theta_y1) || AffineTransformLib.nearEquals(theta_x1, theta_y2)) {
            return theta_x1;
        }
        if (AffineTransformLib.nearEquals(theta_x2, theta_y1) || AffineTransformLib.nearEquals(theta_x2, theta_y2)) {
            return theta_x2;
        }
        return 0.0;
    }

    private static final boolean nearEquals(double aa, double bb) {
        return Math.abs(aa - bb) < 1.0E-4;
    }

    public static void main(String[] argv) throws Exception {
        Rectangle r1 = new Rectangle(0, 0, 5, 7);
        Rectangle r2 = new Rectangle(-3, -4, 12, 7);
        AffineTransform tx = AffineTransformLib.resize(r1, r2);
        System.out.println(r1);
        System.out.println(r2);
        System.out.println(tx);
        System.out.println(GeomLib.transformRectangle(tx, r1));
        System.out.println();
        r1 = new Rectangle(9, 120, 534, 237);
        r2 = new Rectangle(-36, -24, 132, 673);
        tx = AffineTransformLib.resize(r1, r2);
        System.out.println(r1);
        System.out.println(r2);
        System.out.println(tx);
        System.out.println(GeomLib.transformRectangle(tx, r1));
    }
}

