/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;

public class LoggingEventQueue
extends EventQueue {
    private boolean flagDragLeft = false;
    private boolean flagDragMid = false;
    private boolean flagDragRight = false;
    private long lastTime;
    private long eventTime;
    private long time;
    protected BufferedWriter out;
    protected String filename;

    private static String createShortDateTimeString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return df.format(new Date());
    }

    public LoggingEventQueue() throws IOException {
        this("test_" + LoggingEventQueue.createShortDateTimeString() + ".txt");
    }

    public LoggingEventQueue(String filename) throws IOException {
        this.filename = filename;
        this.lastTime = -1L;
        this.time = 0L;
        this.out = new BufferedWriter(new FileWriter(filename));
    }

    public void dispatchEvent(AWTEvent evt) {
        try {
            String event = " ";
            boolean writeEvent = false;
            if (evt instanceof MouseEvent) {
                MouseEvent msevt = (MouseEvent)evt;
                Component comp = (Component)msevt.getSource();
                String source = comp.getName();
                String relCoords = "(" + msevt.getX() + "," + msevt.getY() + ")";
                String screenCoords = this.convertCoords(comp, msevt);
                this.eventTime = new Date().getTime();
                switch (msevt.getID()) {
                    case 501: {
                        event = "MouseEvent[ MOUSE_PRESSED";
                        if (SwingUtilities.isLeftMouseButton(msevt)) {
                            this.flagDragLeft = false;
                            event = String.valueOf(event) + " LT";
                        }
                        if (SwingUtilities.isMiddleMouseButton(msevt)) {
                            this.flagDragMid = false;
                            event = String.valueOf(event) + " MI";
                        }
                        if (SwingUtilities.isRightMouseButton(msevt)) {
                            this.flagDragRight = false;
                            event = String.valueOf(event) + " RT";
                        }
                        writeEvent = true;
                        break;
                    }
                    case 502: {
                        event = "MouseEvent[ MOUSE_RELEASED";
                        if (SwingUtilities.isLeftMouseButton(msevt)) {
                            this.flagDragLeft = false;
                            event = String.valueOf(event) + " LT";
                        }
                        if (SwingUtilities.isMiddleMouseButton(msevt)) {
                            this.flagDragMid = false;
                            event = String.valueOf(event) + " MI";
                        }
                        if (SwingUtilities.isRightMouseButton(msevt)) {
                            this.flagDragRight = false;
                            event = String.valueOf(event) + " RT";
                        }
                        writeEvent = true;
                        break;
                    }
                    case 503: 
                    case 506: {
                        event = "MouseEvent[ MOUSE_MOVED";
                        if (SwingUtilities.isLeftMouseButton(msevt)) {
                            this.flagDragLeft = true;
                            event = String.valueOf(event) + " LT";
                        }
                        if (SwingUtilities.isMiddleMouseButton(msevt)) {
                            this.flagDragMid = true;
                            event = String.valueOf(event) + " MI";
                        }
                        if (SwingUtilities.isRightMouseButton(msevt)) {
                            this.flagDragRight = true;
                            event = String.valueOf(event) + " RT";
                        }
                        writeEvent = true;
                        break;
                    }
                }
                if (this.lastTime != -1L) {
                    this.time = this.eventTime - this.lastTime;
                }
                this.lastTime = this.eventTime;
                if (writeEvent) {
                    this.out.write(String.valueOf(this.time) + "ms\t\t" + event + "\t\t" + screenCoords + "\t\t" + relCoords + "\t\t" + source + "]\n");
                }
            } else if (evt instanceof KeyEvent) {
                KeyEvent kevt = (KeyEvent)evt;
                this.eventTime = new Date().getTime();
                switch (kevt.getID()) {
                    case 401: {
                        event = "KeyEvent[ KEY_PRESSED";
                        writeEvent = true;
                        break;
                    }
                    case 402: {
                        event = "KeyEvent[ KEY_RELEASED";
                        writeEvent = true;
                        break;
                    }
                }
                if (this.lastTime != -1L) {
                    this.time = this.eventTime - this.lastTime;
                }
                this.lastTime = this.eventTime;
                if (writeEvent) {
                    this.out.write(String.valueOf(this.time) + "ms\t\t" + event + "\t\t KeyCode" + kevt.getKeyCode() + "]\n");
                }
            }
        }
        catch (IOException e) {
            System.out.println("ERROR: IOException");
        }
        super.dispatchEvent(evt);
    }

    private String convertCoords(Component comp, MouseEvent msevt) {
        Point pt = comp.getLocationOnScreen();
        int xCoord = (int)pt.getX() + msevt.getX();
        int yCoord = (int)pt.getY() + msevt.getY();
        return "(" + xCoord + "," + yCoord + ")-S";
    }

    public void pop() {
        super.pop();
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            System.out.println("File " + this.filename + " closed.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

