/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.awt;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class EventPlayer {
    protected BufferedReader in;
    protected Robot robot;
    protected float speedFactor;

    public EventPlayer(String filename) throws AWTException, FileNotFoundException {
        this.in = new BufferedReader(new FileReader(filename));
        this.robot = new Robot();
        this.speedFactor = 1.0f;
    }

    public EventPlayer(String filename, float speedFactor) throws AWTException, FileNotFoundException {
        this.in = new BufferedReader(new FileReader(filename));
        this.robot = new Robot();
        this.speedFactor = speedFactor;
    }

    public void play() {
        try {
            String line = this.in.readLine();
            while (line != null) {
                int newdelay;
                int delay = Integer.parseInt(line.substring(0, line.indexOf("ms")));
                int offset = line.indexOf("MouseEvent[ MOUSE");
                if (offset == -1) {
                    offset = line.indexOf("KeyEvent[ KEY");
                }
                if ((newdelay = (int)((float)delay * this.speedFactor)) < 0) {
                    newdelay = 0;
                }
                if (newdelay > 2000) {
                    newdelay = 2000;
                }
                delay = newdelay;
                if (line.startsWith("MouseEvent[ MOUSE_MOVED", offset)) {
                    String coords2 = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")-S"));
                    int x = Integer.parseInt(coords2.substring(0, coords2.indexOf(",")));
                    int y = 0;
                    y = coords2.indexOf(")") == -1 ? Integer.parseInt(coords2.substring(coords2.indexOf(",") + 1)) : Integer.parseInt(coords2.substring(coords2.indexOf(",") + 1, coords2.indexOf(")")));
                    this.robot.delay(delay);
                    this.robot.mouseMove(x, y);
                } else if (line.startsWith("MouseEvent[ MOUSE_PRESSED", offset)) {
                    int button = -1;
                    if (line.indexOf("LT") != -1) {
                        button = 16;
                    } else if (line.indexOf("MI") != -1) {
                        button = 8;
                    } else if (line.indexOf("RT") != -1) {
                        button = 4;
                    }
                    this.robot.delay(delay);
                    this.robot.mousePress(button);
                } else if (line.startsWith("MouseEvent[ MOUSE_RELEASED", offset)) {
                    int button = -1;
                    if (line.indexOf("LT") != -1) {
                        button = 16;
                    } else if (line.indexOf("MI") != -1) {
                        button = 8;
                    } else if (line.indexOf("RT") != -1) {
                        button = 4;
                    }
                    this.robot.delay(delay);
                    this.robot.mouseRelease(button);
                } else if (line.startsWith("KeyEvent[ KEY_PRESSED", offset)) {
                    int keyCode = this.getKeyCode(line);
                    this.robot.delay(delay);
                    this.robot.keyPress(keyCode);
                } else if (line.startsWith("KeyEvent[ KEY_RELEASED", offset)) {
                    int keyCode = this.getKeyCode(line);
                    this.robot.delay(delay);
                    this.robot.keyRelease(keyCode);
                }
                line = this.in.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("ERROR IOException: " + e);
        }
    }

    private int getKeyCode(String line) {
        int offset = 7;
        String keyString = line.substring(line.lastIndexOf("KeyCode") + offset, line.indexOf("]"));
        return Integer.parseInt(keyString);
    }
}

