/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.event;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddControlCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.command.SetVoicePromptTextCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.event.StyledTextEventHandler;
import edu.berkeley.guir.damask.view.visual.component.ComboBox;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.lib.util.StringLib;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ResponseTextHandler
extends StyledTextEventHandler {
    private Response pickedResponse = null;
    private List pickedResponseText = new ArrayList();
    private final PStyledText styledText = this.createText();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.event.ResponseTextHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ResponseTextHandler() {
        this.init();
    }

    public ResponseTextHandler(JTextComponent editor) {
        super(editor);
        this.init();
    }

    private void init() {
        DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
    }

    public void mousePressed(PInputEvent event) {
        PNode pickedNode = event.getPickedNode();
        VoiceCanvas canvas = (VoiceCanvas)event.getComponent();
        canvas.setActiveTextHandler(this);
        if (pickedNode instanceof Response.TextGroup) {
            PNode pickedTextGroup = pickedNode;
            this.pickedResponse = (Response)pickedTextGroup.getParent();
            DamaskLayer layer = this.pickedResponse.getLayer();
            this.pickedResponseText.clear();
            int numTextNodes = 0;
            PText firstTextNode = null;
            Iterator i = pickedTextGroup.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                if (!(child instanceof PText)) continue;
                PText textNode = (PText)child;
                if (++numTextNodes == 1) {
                    firstTextNode = textNode;
                }
                this.pickedResponseText.add(textNode.getText());
            }
            if (firstTextNode == null || firstTextNode.getText().trim().equals("")) {
                this.pickedResponseText.clear();
                this.pickedResponseText.add("Text");
            }
            DamaskAppUtils.setText(this.styledText, StringLib.join(this.pickedResponseText, "\n"));
            DamaskAppUtils.setFontSize(this.styledText, DeviceType.VOICE.getDefaultFontSize());
            Insets pInsets = this.styledText.getInsets();
            layer.addChild(this.styledText);
            PBounds textGroupGlobalBounds = pickedTextGroup.getFullBounds();
            pickedTextGroup.getParent().localToGlobal(textGroupGlobalBounds);
            Point2D position = textGroupGlobalBounds.getOrigin();
            this.styledText.setOffset(position.getX() + 10.0 - (double)pInsets.left, position.getY() - (double)pInsets.top);
            this.startEditing(event, this.styledText);
        }
    }

    public void stopEditing() {
        if (this.canvas instanceof DamaskCanvas) {
            ((DamaskCanvas)this.canvas).setTextEditing(false);
        }
        if (this.editedText != null) {
            DamaskCanvas damaskCanvas = (DamaskCanvas)this.canvas;
            DamaskLayer damaskLayer = (DamaskLayer)this.canvas.getLayer();
            Document editedDoc = this.editedText.getDocument();
            editedDoc.removeDocumentListener(this.docListener);
            this.editedText.setEditing(false);
            this.editedText.syncWithDocument();
            this.editedText.removeFromParent();
            try {
                Control control = (Control)this.pickedResponse.getModel();
                Control beforeControl = DamaskUtils.getPreviousLowLevelControl(control.getPageRegion(damaskCanvas.getDeviceType()), control);
                ModifyGraphMacroCommand command = new ModifyGraphMacroCommand();
                String[] newTextArray = editedDoc.getText(0, editedDoc.getLength()).trim().split("\\n");
                if (newTextArray.length != 0) {
                    if (newTextArray.length == 1) {
                        if (newTextArray[0].equals("*")) {
                            if (!(control instanceof TextInput)) {
                                if (control instanceof Trigger) {
                                    command.addCommand(new SetVoicePromptTextCommand(((Trigger)control).getContent(), "OK"));
                                    if (!(beforeControl instanceof TextInput)) {
                                        command.addCommand(new AddControlCommand(beforeControl, (Control)new TextInput(damaskLayer.getDeviceTypeForNewElement())));
                                    }
                                    if (beforeControl instanceof SelectOne || beforeControl instanceof SelectMany.Item) {
                                        DamaskUtils.addCommandsForRemovingControlToMacroCommand(command, beforeControl);
                                    }
                                } else {
                                    Trigger trigger = new Trigger(damaskLayer.getDeviceTypeForNewElement(), new Content(damaskLayer.getDeviceTypeForNewElement(), "OK"));
                                    command.addCommand(new AddControlCommand(beforeControl, (Control)trigger));
                                    command.addCommand(new AddControlCommand(beforeControl, (Control)new TextInput(damaskLayer.getDeviceTypeForNewElement())));
                                    if (control instanceof SelectOne || control instanceof SelectMany.Item) {
                                        DamaskUtils.addCommandsForRemovingControlToMacroCommand(command, control);
                                    }
                                }
                            }
                        } else if (control instanceof SelectOne && ((SelectOne)control).getItems().size() == 1) {
                            SelectOne selectOne = (SelectOne)control;
                            DamaskAppUtils.addCommandsToModifySelectItemsToMacroCommand(selectOne, damaskCanvas, newTextArray, command, true);
                        } else if (control instanceof Trigger) {
                            command.addCommand(new SetVoicePromptTextCommand(((Trigger)control).getContent(), newTextArray[0]));
                            if (beforeControl instanceof TextInput || beforeControl instanceof SelectOne || beforeControl instanceof SelectMany.Item) {
                                DamaskUtils.addCommandsForRemovingControlToMacroCommand(command, beforeControl);
                            }
                        } else {
                            Trigger trigger = new Trigger(damaskLayer.getDeviceTypeForNewElement(), new Content(damaskLayer.getDeviceTypeForNewElement(), newTextArray[0]));
                            command.addCommand(new AddControlCommand(beforeControl, (Control)trigger));
                            command.addCommand(new AddControlCommand(beforeControl, (Control)new TextInput(damaskLayer.getDeviceTypeForNewElement())));
                            if (control instanceof TextInput || control instanceof SelectOne || control instanceof SelectMany.Item) {
                                DamaskUtils.addCommandsForRemovingControlToMacroCommand(command, control);
                            }
                        }
                    } else if (newTextArray.length == 2) {
                        Control controlToChange;
                        SelectOne selectOne;
                        if (this.pickedResponseText.size() <= 1) {
                            selectOne = new SelectOne(damaskLayer.getDeviceTypeForNewElement());
                            command.addCommand(new AddControlCommand(beforeControl, (Control)selectOne));
                            Iterator i = damaskLayer.getDeviceTypeForNewElement().getSpecificDeviceTypes().iterator();
                            while (i.hasNext()) {
                                DeviceType aDeviceType = (DeviceType)i.next();
                                if (aDeviceType == DeviceType.VOICE) continue;
                                selectOne.setStyle(aDeviceType, Select.MINIMAL);
                                command.addCommand(new SetTransformCommand(selectOne, aDeviceType, beforeControl.getTransform(aDeviceType)));
                                AffineTransform newTriggerTransform = control.getTransform(aDeviceType);
                                newTriggerTransform.translate(0.0, ComboBox.createTempView().getHeight());
                                control.setTransform(aDeviceType, newTriggerTransform);
                            }
                            controlToChange = selectOne;
                        } else {
                            controlToChange = control instanceof Trigger ? beforeControl : control;
                        }
                        if (controlToChange instanceof SelectMany.Item) {
                            ((SelectMany.Item)controlToChange).setVoiceResponseTextList(Arrays.asList(newTextArray));
                        } else if (controlToChange instanceof SelectOne) {
                            selectOne = (SelectOne)controlToChange;
                            DamaskAppUtils.addCommandsToModifySelectItemsToMacroCommand(selectOne, damaskCanvas, newTextArray, command, true);
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Control to change must be select-one or select-many item");
                        }
                    } else {
                        SelectOne selectOneToChange;
                        if (this.pickedResponseText.size() <= 1) {
                            SelectOne selectOne = new SelectOne(damaskLayer.getDeviceTypeForNewElement());
                            command.addCommand(new AddControlCommand(beforeControl, (Control)selectOne));
                            Iterator i = damaskLayer.getDeviceTypeForNewElement().getSpecificDeviceTypes().iterator();
                            while (i.hasNext()) {
                                DeviceType aDeviceType = (DeviceType)i.next();
                                if (aDeviceType == DeviceType.VOICE) continue;
                                selectOne.setStyle(aDeviceType, Select.MINIMAL);
                                command.addCommand(new SetTransformCommand(selectOne, aDeviceType, beforeControl.getTransform(aDeviceType)));
                                AffineTransform newTriggerTransform = control.getTransform(aDeviceType);
                                newTriggerTransform.translate(0.0, ComboBox.createTempView().getHeight());
                                control.setTransform(aDeviceType, newTriggerTransform);
                            }
                            selectOneToChange = selectOne;
                            ((Trigger)control).getContent().setText("OK");
                        } else if (this.pickedResponseText.size() == 2 && beforeControl instanceof SelectMany.Item) {
                            SelectOne selectOne = new SelectOne(damaskLayer.getDeviceTypeForNewElement());
                            command.addCommand(new AddControlCommand(beforeControl, (Control)selectOne));
                            selectOneToChange = selectOne;
                            ((Trigger)control).getContent().setText("OK");
                            DamaskUtils.addCommandsForRemovingControlToMacroCommand(command, beforeControl);
                        } else {
                            selectOneToChange = (SelectOne)beforeControl;
                        }
                        DamaskAppUtils.addCommandsToModifySelectItemsToMacroCommand(selectOneToChange, damaskCanvas, newTextArray, command, true);
                    }
                }
                if (!command.isEmpty()) {
                    damaskCanvas.getDocument().getCommandQueue().doCommand(damaskCanvas, command);
                }
            }
            catch (BadLocationException e) {
                DamaskAppExceptionHandler.log(e);
            }
        }
        this.editor.setVisible(false);
        if (this.canvas != null) {
            this.canvas.repaint();
        }
        this.editedText = null;
    }

    protected JTextComponent createDefaultEditor() {
        JTextComponent tComp = super.createDefaultEditor();
        tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
        return tComp;
    }
}

