/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.event;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.event.StyledTextEventHandler;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class InsertPromptHandler
extends StyledTextEventHandler {
    private Form form = null;
    private final PStyledText styledText = this.createText();

    public InsertPromptHandler() {
        this.init();
    }

    public InsertPromptHandler(JTextComponent editor) {
        super(editor);
        this.init();
    }

    private void init() {
        DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
    }

    public void mousePressed(PInputEvent event) {
        PNode pickedNode = event.getPickedNode();
        VoiceCanvas canvas = (VoiceCanvas)event.getComponent();
        canvas.setActiveTextHandler(this);
        DamaskAppUtils.setText(this.styledText, "");
        DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
        if (pickedNode instanceof Form.Contents) {
            this.form = (Form)pickedNode.getParent();
            Insets pInsets = this.styledText.getInsets();
            pickedNode.addChild(this.styledText);
            Point2D position = event.getPosition();
            pickedNode.globalToLocal(position);
            this.styledText.setOffset(position.getX() - (double)pInsets.left, position.getY() - (double)pInsets.top);
            this.startEditing(event, this.styledText);
        }
    }

    public void stopEditing() {
        if (this.canvas instanceof DamaskCanvas) {
            ((DamaskCanvas)this.canvas).setTextEditing(false);
        }
        if (this.editedText != null) {
            DamaskCanvas damaskCanvas = (DamaskCanvas)this.canvas;
            Document editedDoc = this.editedText.getDocument();
            editedDoc.removeDocumentListener(this.docListener);
            this.editedText.setEditing(false);
            this.editedText.syncWithDocument();
            this.editedText.removeFromParent();
            if (this.editedText.getDocument().getLength() != 0) {
                DamaskAppUtils.setFontSize(this.editedText, this.form.getDeviceType().getDefaultFontSize());
                PBounds bounds = this.editedText.getBounds();
                PAffineTransform transform = this.editedText.getTransform();
                try {
                    Dialog dialog = (Dialog)this.form.getModel();
                    DamaskLayer layer = (DamaskLayer)damaskCanvas.getLayer();
                    DeviceType deviceTypeForText = layer.getDeviceTypeForNewElement();
                    Content content = new Content(deviceTypeForText, editedDoc.getText(0, editedDoc.getLength()));
                    content.setTransform(deviceTypeForText, transform);
                    content.setVoicePromptBounds(bounds);
                    Iterator i = deviceTypeForText.getSpecificDeviceTypes().iterator();
                    while (i.hasNext()) {
                        DeviceType aDeviceType = (DeviceType)i.next();
                        DamaskAppUtils.setFontSize(this.editedText, aDeviceType.getDefaultFontSize());
                        PBounds aDeviceBounds = this.editedText.getBounds();
                        content.setBounds(aDeviceType, aDeviceBounds);
                    }
                    Page lastPage = dialog.getLastPage(damaskCanvas.getDeviceType());
                    Page pageForNewContent = lastPage.getRegion(Direction.CENTER).getControls().isEmpty() ? lastPage : lastPage.split(Collections.EMPTY_LIST);
                    ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
                    DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, content, pageForNewContent.getRegion(Direction.CENTER));
                    damaskCanvas.getDocument().getCommandQueue().doCommand(damaskCanvas, cmd);
                }
                catch (BadLocationException e) {
                    DamaskAppExceptionHandler.log(e);
                }
            }
            this.editor.setVisible(false);
            this.canvas.repaint();
            this.editedText = null;
            this.form = null;
        }
    }

    protected JTextComponent createDefaultEditor() {
        JTextComponent tComp = super.createDefaultEditor();
        tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
        return tComp;
    }
}

