/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddDialogCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.voice.VoiceLayer;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class InsertFormHandler
extends PDragSequenceEventHandler {
    private static final String DEFAULT_TITLE = "Title";
    private static final Color DRAG_RECT_BORDER = new Color(0, 0, 0, 30);
    private static final Color PAGE_RECT_BORDER = new Color(0, 0, 0, 75);
    private static final Color PAGE_RECT_FILL = new Color(255, 255, 255, 100);
    private PPath dragRectangle;
    private PPath pageRectangle;
    private Point2D pressPoint;
    private Point2D dragPoint;
    private boolean startedInTemplatePane;
    private DeviceType deviceType;
    private boolean textEditing;

    public InsertFormHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        this.textEditing = canvas.isTextEditing();
        if (this.textEditing) {
            canvas.stopTextEditing();
            return;
        }
        VoiceLayer layer = (VoiceLayer)canvas.getLayer();
        this.dragPoint = this.pressPoint = e.getPosition();
        TemplatePane templatePane = layer.getTemplatePane();
        this.startedInTemplatePane = templatePane.localToParent(templatePane.getBounds()).contains(this.pressPoint);
        if (this.startedInTemplatePane) {
            return;
        }
        this.pageRectangle = new PPath();
        this.pageRectangle.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
        this.pageRectangle.setPaint(PAGE_RECT_FILL);
        this.pageRectangle.setStrokePaint(PAGE_RECT_BORDER);
        layer.addChild(this.pageRectangle);
        this.dragRectangle = new PPath();
        this.dragRectangle.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
        this.dragRectangle.setStrokePaint(DRAG_RECT_BORDER);
        layer.addChild(this.dragRectangle);
        this.deviceType = layer.getDeviceType();
        this.updateRectangles();
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        if (this.textEditing) {
            return;
        }
        if (this.startedInTemplatePane) {
            return;
        }
        this.dragPoint = e.getPosition();
        this.updateRectangles();
    }

    public void endDrag(PInputEvent e) {
        super.endDrag(e);
        if (this.textEditing) {
            return;
        }
        if (this.startedInTemplatePane) {
            return;
        }
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        DamaskLayer layer = (DamaskLayer)canvas.getLayer();
        layer.removeChild(this.dragRectangle);
        layer.removeChild(this.pageRectangle);
        Content dialogTitle = new Content(layer.getDeviceTypeForNewElement(), DEFAULT_TITLE);
        dialogTitle.setTextSize(layer.getDeviceTypeForNewElement(), 18);
        AddDialogCommand command = new AddDialogCommand(canvas.getDocument().getGraph(), dialogTitle, layer.getDeviceType(), layer.getDeviceTypeLayer() == DamaskLayer.DeviceTypeLayer.ALL, new Rectangle2D.Double(0.0, 0.0, this.pageRectangle.getWidth(), this.pageRectangle.getHeight()), AffineTransform.getTranslateInstance(this.pageRectangle.getX(), this.pageRectangle.getY()));
        canvas.getDocument().getCommandQueue().doCommand(canvas, command);
    }

    private void updateRectangles() {
        PBounds dragRectBounds = new PBounds();
        dragRectBounds.add(this.pressPoint);
        dragRectBounds.add(this.dragPoint);
        this.dragRectangle.setPathTo(dragRectBounds);
        float newWidth = Math.max((float)dragRectBounds.getWidth(), (float)this.deviceType.getDefaultWidth());
        float newHeight = Math.max((float)dragRectBounds.getHeight(), (float)this.deviceType.getDefaultHeight());
        this.pageRectangle.setPathToRectangle((float)this.pressPoint.getX(), (float)this.pressPoint.getY(), newWidth, newHeight);
    }
}

