/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.event;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.AddConnectionCommand;
import edu.berkeley.guir.damask.command.AddControlCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveConnectionCommand;
import edu.berkeley.guir.damask.command.RemoveControlCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.command.SetVoiceResponseLineCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;

public class DragResponseHotSpotHandler
extends PDragSequenceEventHandler {
    private Point2D origStartPt = null;
    private Point2D origEndPt = null;
    private Line2D line = new Line2D.Double();
    private Response.HotSpot hotSpot = null;
    private Response response = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DragResponseHotSpotHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    private void updateLine(PInputEvent e) {
        if (this.hotSpot == this.response.getStartHotSpot()) {
            this.line.setLine(e.getPositionRelativeTo(this.response), this.origEndPt);
        } else {
            this.line.setLine(this.origStartPt, e.getPositionRelativeTo(this.response));
        }
        this.response.updateArrow(this.line);
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        ((DamaskCanvas)e.getComponent()).stopTextEditing();
        PNode startNode = e.getPickedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.component.Response$HotSpot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.hotSpot = (Response.HotSpot)DamaskAppUtils.getAncestor(startNode, clazz);
        if (this.hotSpot == null) {
            return;
        }
        this.response = this.hotSpot.getResponse();
        this.origStartPt = this.response.globalToLocal(this.response.getStartHotSpot().localToGlobal(this.response.getStartHotSpot().getBounds().getCenter2D()));
        this.origEndPt = this.response.globalToLocal(this.response.getEndHotSpot().localToGlobal(this.response.getEndHotSpot().getBounds().getCenter2D()));
        this.updateLine(e);
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        if (this.hotSpot == null) {
            return;
        }
        this.updateLine(e);
    }

    public void endDrag(PInputEvent e) {
        boolean endDangling;
        super.endDrag(e);
        if (this.hotSpot == null) {
            return;
        }
        this.updateLine(e);
        boolean origResponsePickable = this.response.getPickable();
        boolean origHotSpotPickable = this.hotSpot.getPickable();
        this.response.setPickable(false);
        this.hotSpot.setPickable(false);
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        DeviceType canvasDeviceType = canvas.getDeviceType();
        Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
        PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
        this.response.setPickable(origResponsePickable);
        this.hotSpot.setPickable(origHotSpotPickable);
        Form form = this.response.getForm();
        Trigger trigger = (Trigger)this.response.getModel();
        ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
        Connection origOutConnection = null;
        if (this.response.getDest() != null) {
            InteractionElement originalResponseDestModel = this.response.getDest().getModel();
            Iterator i = trigger.getOutConnections().iterator();
            while (i.hasNext()) {
                Connection connection = (Connection)i.next();
                if (connection.getConnectionDest(canvasDeviceType) != originalResponseDestModel) continue;
                origOutConnection = (NavConnection)connection;
                break;
            }
        }
        ConnectionDest origOutConnectionDest = origOutConnection == null ? null : origOutConnection.getConnectionDest(canvasDeviceType);
        if (this.hotSpot == this.response.getStartHotSpot()) {
            AbstractInteractionElement addTarget;
            if (endNode instanceof Prompt && endNode != this.response.getSource()) {
                addTarget = (Control)((Prompt)endNode).getModel();
                endDangling = false;
            } else {
                Page lastPage = ((Dialog)form.getModel()).getLastPage(canvasDeviceType);
                Page pageForNewContent = lastPage.getRegion(Direction.CENTER).getControls().isEmpty() ? lastPage : lastPage.split(Collections.EMPTY_LIST);
                addTarget = pageForNewContent.getRegion(Direction.CENTER);
                endDangling = true;
            }
            cmd.addCommand(new RemoveControlCommand(trigger));
            if (addTarget instanceof PageRegion) {
                cmd.addCommand(new AddControlCommand((PageRegion)addTarget, (Control)trigger));
            } else {
                cmd.addCommand(new AddControlCommand((Control)addTarget, (Control)trigger));
            }
            Control beforeControl = DamaskUtils.getPreviousLowLevelControl(trigger.getPageRegion(canvasDeviceType), trigger);
            if (beforeControl instanceof SelectMany.Item) {
                SelectMany.Item item = (SelectMany.Item)beforeControl;
                AffineTransform itemTransform = item.getTransform(canvasDeviceType);
                SelectMany selectMany = (SelectMany)item.getParent();
                Content newContent = new Content(item.getContent(), selectMany.getDeviceType());
                cmd.addCommand(new AddControlCommand(selectMany, (Control)newContent));
                cmd.addCommand(new RemoveControlCommand(selectMany));
                SelectOne newSelectOne = new SelectOne(selectMany.getDeviceType());
                newSelectOne.addItem(new SelectOne.Item(new Content(selectMany.getDeviceType(), item.getVoiceResponseText(0))));
                newSelectOne.addItem(new SelectOne.Item(new Content(selectMany.getDeviceType(), item.getVoiceResponseText(1))));
                if (addTarget instanceof PageRegion) {
                    cmd.addCommand(new AddControlCommand((PageRegion)addTarget, (Control)newSelectOne));
                } else {
                    cmd.addCommand(new AddControlCommand((Control)addTarget, (Control)newSelectOne));
                }
                cmd.addCommand(new SetTransformCommand(newSelectOne, canvasDeviceType, itemTransform));
                cmd.addCommand(new SetTransformCommand(newContent, canvasDeviceType, itemTransform));
            } else if (beforeControl instanceof SelectOne || beforeControl instanceof TextInput) {
                cmd.addCommand(new RemoveControlCommand(beforeControl));
                if (addTarget instanceof PageRegion) {
                    cmd.addCommand(new AddControlCommand((PageRegion)addTarget, beforeControl));
                } else {
                    cmd.addCommand(new AddControlCommand((Control)addTarget, beforeControl));
                }
            }
            if (origOutConnectionDest != null) {
                boolean connectionDestIsForAllDeviceTypes = origOutConnectionDest instanceof Control ? ((Control)origOutConnectionDest).isForAllDeviceTypes() : ((Page)origOutConnectionDest).getDialog().getDeviceType() == DeviceType.ALL;
                cmd.addCommand(new AddConnectionCommand(canvasDeviceType, trigger.isForAllDeviceTypes() && connectionDestIsForAllDeviceTypes, trigger, new InvokeEvent(trigger), form.getDesignTimeCondition(), origOutConnectionDest, new GeneralPath(this.line)));
            }
        } else {
            ConnectionDest connectionDest = null;
            if (endNode instanceof Prompt && endNode != this.response.getDest()) {
                connectionDest = (ConnectionDest)((Prompt)endNode).getModel();
            } else {
                Form endForm;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.voice.dialog.Form");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((endForm = (Form)DamaskAppUtils.getAncestor(endNode, clazz)) != null && endForm != form) {
                    connectionDest = ((Dialog)endForm.getModel()).getFirstPage(canvasDeviceType);
                }
            }
            boolean bl = endDangling = connectionDest == null;
            if (origOutConnection != null) {
                cmd.addCommand(new RemoveConnectionCommand(origOutConnection, false));
            }
            if (connectionDest != null) {
                boolean connectionDestIsForAllDeviceTypes = connectionDest instanceof Control ? ((Control)connectionDest).isForAllDeviceTypes() : ((Page)connectionDest).getDialog().getDeviceType() == DeviceType.ALL;
                cmd.addCommand(new AddConnectionCommand(canvasDeviceType, trigger.isForAllDeviceTypes() && connectionDestIsForAllDeviceTypes, trigger, new InvokeEvent(trigger), form.getDesignTimeCondition(), connectionDest, new GeneralPath(this.line)));
            }
        }
        if (endDangling) {
            cmd.addCommand(new SetVoiceResponseLineCommand((Control)this.response.getModel(), form.getDesignTimeCondition(), this.line));
        }
        if (!cmd.isEmpty()) {
            canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
        }
    }
}

