/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.event;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddConnectionCommand;
import edu.berkeley.guir.damask.command.AddControlCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class DragFromPromptHandler
extends PDragSequenceEventHandler {
    private DamaskPPath linePath = new DamaskPPath();
    private Line2D line = new Line2D.Double();
    private Prompt startPrompt = null;
    private PPath startFormContents = null;
    private final Prompt.TextHandler promptTextHandler = new Prompt.TextHandler();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DragFromPromptHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        ((DamaskCanvas)e.getComponent()).stopTextEditing();
        PNode startNode = e.getPickedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.component.Prompt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.startPrompt = (Prompt)DamaskAppUtils.getAncestor(startNode, clazz);
        this.startFormContents = this.startPrompt.getForm().getContents();
        this.line.setLine(this.startFormContents.globalToLocal(this.startPrompt.localToGlobal(this.startPrompt.getBounds().getCenter2D())), e.getPositionRelativeTo(this.startFormContents));
        this.linePath.setPathTo(this.line);
        this.linePath.setStrokePaint(Color.BLACK);
        this.startFormContents.addChild(this.linePath);
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        this.line.setLine(this.line.getP1(), e.getPositionRelativeTo(this.startFormContents));
        this.linePath.setPathTo(this.line);
    }

    public void endDrag(PInputEvent e) {
        super.endDrag(e);
        this.line.setLine(this.line.getP1(), e.getPositionRelativeTo(this.startFormContents));
        this.linePath.setPathTo(this.line);
        this.startFormContents.removeChild(this.linePath);
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        DeviceType canvasDeviceType = canvas.getDeviceType();
        Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
        PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
        int startFormCondition = this.startPrompt.getForm().getDesignTimeCondition();
        DeviceType deviceTypeForNewElement = ((DamaskLayer)canvas.getLayer()).getDeviceTypeForNewElement();
        System.out.println("endNode: " + endNode);
        if (endNode == this.startPrompt) {
            this.promptTextHandler.startEditing(e, this.startPrompt);
        } else if (endNode instanceof Prompt || endNode instanceof Response.HotSpot || endNode instanceof DamaskWindowTitle || endNode.getParent() instanceof DamaskWindowTitle || endNode instanceof Form.Contents) {
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Content triggerContent = new Content(deviceTypeForNewElement, "Text");
            Trigger trigger = new Trigger(deviceTypeForNewElement, triggerContent);
            Iterator i = deviceTypeForNewElement.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (aDeviceType == DeviceType.VOICE) continue;
                Rectangle2D aDeviceBounds = DamaskAppUtils.getRenderedTextBounds("Text", aDeviceType.getDefaultFontSize());
                triggerContent.setBounds(aDeviceType, aDeviceBounds);
                trigger.setBounds(aDeviceType, aDeviceBounds);
                AffineTransform newTransform = trigger.getTransform(DeviceType.VOICE);
                newTransform.translate(this.line.getX1(), this.line.getY1());
                trigger.setTransform(aDeviceType, newTransform);
            }
            cmd.addCommand(new AddControlCommand((Control)this.startPrompt.getModel(), (Control)trigger));
            AbstractInteractionElement connectionDest = null;
            if (endNode instanceof Prompt) {
                connectionDest = (Control)((Prompt)endNode).getModel();
            } else if (endNode instanceof Response.HotSpot) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.voice.component.Response");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Response response = (Response)DamaskAppUtils.getAncestor(endNode, clazz);
                connectionDest = (Control)response.getModel();
            } else if (endNode instanceof Form.Contents || endNode instanceof DamaskWindowTitle || endNode.getParent() instanceof DamaskWindowTitle) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("edu.berkeley.guir.damask.view.voice.dialog.Form");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Form endForm = (Form)DamaskAppUtils.getAncestor(endNode, clazz);
                if (this.startPrompt.getForm() != endForm) {
                    connectionDest = ((Dialog)endForm.getModel()).getFirstPage(canvasDeviceType);
                }
            }
            if (connectionDest != null) {
                boolean connectionDestIsForAllDeviceTypes = connectionDest instanceof Control ? connectionDest.isForAllDeviceTypes() : ((Page)connectionDest).getDialog().getDeviceType() == DeviceType.ALL;
                cmd.addCommand(new AddConnectionCommand(canvasDeviceType, deviceTypeForNewElement == DeviceType.ALL && connectionDestIsForAllDeviceTypes, trigger, new InvokeEvent(trigger), startFormCondition, (ConnectionDest)((Object)connectionDest), new GeneralPath(this.line)));
            }
            if (!cmd.isEmpty()) {
                canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
                if (connectionDest == null) {
                    trigger.setVoiceResponseLine(startFormCondition, this.line);
                }
            }
        }
    }
}

