/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.dialog;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.SetPageIndexCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.nodes.DamaskWindow;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.dialog.Conversation;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Form
extends DamaskWindow {
    private static final Color DEFAULT_TITLE_BAR_PAINT = new Color(140, 140, 255, 100);
    private final Paint CONTENTS_PAINT = new Color(255, 255, 255, 100);
    private final DialogHandler dialogHandler = new DialogHandler();
    private int designTimeCondition = 0;
    private boolean contentsSelectable = true;

    public Form(Dialog dialog) {
        super(dialog);
        dialog.addElementContainerListener(this.dialogHandler);
        this.addInputEventListener(new BasicInputEventHandler());
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Iterator i = ((Dialog)this.getModel()).getPages(this.getDeviceType()).iterator();
        while (i.hasNext()) {
            Page p = (Page)i.next();
            this.getContents().addChild(new Conversation(p));
        }
        this.setContentsSelectable(true);
    }

    protected PPath createContents() {
        return new Contents();
    }

    protected Content getTitleContent() {
        return ((Dialog)this.getModel()).getFirstPage(this.getDeviceType()).getTitle();
    }

    public DeviceType getDeviceType() {
        DamaskLayer layer = this.getLayer();
        if (layer != null) {
            return layer.getDeviceType();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        ((Dialog)this.getModel()).removeElementContainerListener(this.dialogHandler);
    }

    protected Paint getContentsPaint() {
        return this.CONTENTS_PAINT;
    }

    protected Paint getDeviceSpecificContentsPaintInAllLayer() {
        return this.CONTENTS_PAINT;
    }

    protected Color getTitleColor() {
        return DEFAULT_TITLE_BAR_PAINT;
    }

    public void setContentsSelectable(boolean selectable) {
        this.contentsSelectable = selectable;
        DamaskLayer layer = this.getLayer();
        Iterator i = this.getContents().getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof Conversation)) continue;
            Iterator j = child.getChildrenIterator();
            while (j.hasNext()) {
                int n;
                int k;
                PNode grandchild = (PNode)j.next();
                if (!(grandchild instanceof VoiceControl)) continue;
                VoiceControl voiceControl = (VoiceControl)grandchild;
                if (selectable) {
                    layer.addSelectableParent(voiceControl);
                    k = 0;
                    n = ((Dialog)this.getModel()).getNumConditions();
                    while (k < n) {
                        if (voiceControl.getResponse(k) != null) {
                            layer.addSelectableParent(voiceControl.getResponse(k));
                        }
                        ++k;
                    }
                    continue;
                }
                layer.removeSelectableParent(voiceControl);
                k = 0;
                n = ((Dialog)this.getModel()).getNumConditions();
                while (k < n) {
                    if (voiceControl.getResponse(k) != null) {
                        layer.removeSelectableParent(voiceControl.getResponse(k));
                    }
                    ++k;
                }
            }
        }
    }

    public boolean isContentsSelectable() {
        return this.contentsSelectable;
    }

    public int getDesignTimeCondition() {
        return this.designTimeCondition;
    }

    public void setDesignTimeCondition(int condition) {
        Dialog dialog = (Dialog)this.getModel();
        if (condition >= dialog.getNumConditions()) {
            throw new IllegalArgumentException();
        }
        this.designTimeCondition = condition;
    }

    public void deviceTypeLayerChanged() {
        super.deviceTypeLayerChanged();
        Iterator i = this.getContents().getChildrenIterator();
        while (i.hasNext()) {
            PNode dialogChild = (PNode)i.next();
            if (!(dialogChild instanceof Conversation)) continue;
            ((Conversation)dialogChild).deviceTypeLayerChanged();
        }
    }

    protected Dialog getDialogModel() {
        return (Dialog)this.getModel();
    }

    protected Point2D getAnchorPt() {
        PBounds formBounds = this.getBounds();
        return new Point2D.Double(formBounds.getCenterX(), formBounds.getMinY() + 1.0);
    }

    public class Contents
    extends PPath {
        private static final int HOTSPOT_RADIUS = 10;
        private DamaskPPath arrowToFirstPrompt = new DamaskPPath();
        private HotSpot firstPromptHotSpot = new HotSpot(new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
        private boolean endPointBeingDragged = false;

        public Contents() {
            this.addChild(this.arrowToFirstPrompt);
            this.arrowToFirstPrompt.setPickable(false);
            this.firstPromptHotSpot.setPaint(DamaskAppUtils.NO_COLOR);
            this.firstPromptHotSpot.setStrokePaint(DamaskAppUtils.NO_COLOR);
            this.addChild(this.firstPromptHotSpot);
        }

        public Form getForm() {
            return (Form)this.getParent();
        }

        public void setEndPointBeingDragged(boolean flag) {
            this.endPointBeingDragged = flag;
        }

        public boolean isEndPointBeingDragged() {
            return this.endPointBeingDragged;
        }

        public void setArrowEndPoint(Point2D endPt) {
            Point2D anchorPt = Form.this.getAnchorPt();
            Form.this.localToGlobal(anchorPt);
            this.globalToLocal(anchorPt);
            this.arrowToFirstPrompt.setPathTo(new Line2D.Double(anchorPt, endPt));
            this.arrowToFirstPrompt.setVisible(true);
            this.firstPromptHotSpot.setOffset(endPt.getX() - 10.0, endPt.getY() - 10.0);
            this.firstPromptHotSpot.setVisible(true);
        }

        public void layoutChildren() {
            if (this.endPointBeingDragged) {
                return;
            }
            this.firstPromptHotSpot.setVisible(false);
            PNode firstConversation = null;
            PBounds bounds = this.getBounds();
            Iterator i = this.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                if (!(child instanceof Conversation)) continue;
                if (firstConversation == null) {
                    firstConversation = (Conversation)child;
                }
                Iterator j = child.getChildrenIterator();
                while (j.hasNext()) {
                    PNode view = (PNode)j.next();
                    PBounds viewBounds = view.getFullBounds();
                    child.localToGlobal(viewBounds);
                    this.globalToLocal(viewBounds);
                    view.setVisible(bounds.intersects(viewBounds));
                }
            }
            if (firstConversation != null) {
                VoiceControl firstControl = null;
                Iterator i2 = firstConversation.getChildrenIterator();
                while (i2.hasNext()) {
                    PNode child = (PNode)i2.next();
                    if (!(child instanceof VoiceControl)) continue;
                    firstControl = (VoiceControl)child;
                    break;
                }
                if (firstControl != null) {
                    Point2D endPt;
                    Point2D anchorPt = Form.this.getAnchorPt();
                    Form.this.localToGlobal(anchorPt);
                    this.globalToLocal(anchorPt);
                    Prompt firstPrompt = firstControl.getPrompt();
                    if (firstPrompt != null) {
                        PBounds promptBounds = firstPrompt.getBounds();
                        firstPrompt.localToGlobal(promptBounds);
                        this.globalToLocal(promptBounds);
                        Point2D centerPt = promptBounds.getCenter2D();
                        List intersectPts = GeomLib.calcIntersectPoints(new Line2D.Double(anchorPt, centerPt), promptBounds);
                        endPt = intersectPts.isEmpty() ? centerPt : (Point2D)intersectPts.get(0);
                    } else {
                        Response firstResponse = firstControl.getResponse(Form.this.getDesignTimeCondition());
                        if (firstResponse != null) {
                            Response.HotSpot hotSpot = firstResponse.getStartHotSpot();
                            endPt = hotSpot.getBounds().getCenter2D();
                            hotSpot.localToGlobal(endPt);
                            this.globalToLocal(endPt);
                        } else {
                            endPt = null;
                        }
                    }
                    if (endPt != null) {
                        this.setArrowEndPoint(endPt);
                    } else {
                        this.arrowToFirstPrompt.setVisible(false);
                    }
                }
            }
        }

        protected void paint(PPaintContext paintContext) {
            super.paint(paintContext);
            if (this.arrowToFirstPrompt.getVisible() && !this.arrowToFirstPrompt.getBounds().isEmpty()) {
                DamaskAppUtils.drawArrowheads(this.arrowToFirstPrompt, paintContext);
            }
        }
    }

    public static class HotSpot
    extends PPath {
        public HotSpot() {
            this.addInputEventListener(new DragHotSpotHandler());
        }

        public HotSpot(Shape aShape) {
            super(aShape);
            this.addInputEventListener(new DragHotSpotHandler());
        }

        public HotSpot(Shape aShape, Stroke aStroke) {
            super(aShape, aStroke);
            this.addInputEventListener(new DragHotSpotHandler());
        }

        public Contents getContents() {
            return (Contents)this.getParent();
        }

        public class DragHotSpotHandler
        extends PDragSequenceEventHandler {
            private HotSpot hotSpot = null;
            private Contents contents = null;
            static /* synthetic */ Class class$0;

            public DragHotSpotHandler() {
                this.setEventFilter(new PInputEventFilter(16));
            }

            private void updateLine(PInputEvent e) {
                this.contents.setArrowEndPoint(e.getPositionRelativeTo(this.contents));
            }

            public void startDrag(PInputEvent e) {
                super.startDrag(e);
                ((DamaskCanvas)e.getComponent()).stopTextEditing();
                PNode startNode = e.getPickedNode();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.dialog.Form$HotSpot");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.hotSpot = (HotSpot)DamaskAppUtils.getAncestor(startNode, clazz);
                if (this.hotSpot == null) {
                    return;
                }
                this.contents = this.hotSpot.getContents();
                this.contents.setEndPointBeingDragged(true);
            }

            public void drag(PInputEvent e) {
                super.drag(e);
                if (this.hotSpot == null) {
                    return;
                }
                this.updateLine(e);
            }

            public void endDrag(PInputEvent e) {
                Prompt endPrompt;
                super.endDrag(e);
                if (this.hotSpot == null) {
                    return;
                }
                this.updateLine(e);
                this.contents.setEndPointBeingDragged(false);
                boolean origHotSpotPickable = this.hotSpot.getPickable();
                this.hotSpot.setPickable(false);
                DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
                Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
                PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
                this.hotSpot.setPickable(origHotSpotPickable);
                if (endNode instanceof Prompt && (endPrompt = (Prompt)endNode).getForm() == this.contents.getForm()) {
                    Conversation conversation = endPrompt.getConversation();
                    Page newFirstPage = (Page)conversation.getModel();
                    canvas.getDocument().getCommandQueue().doCommand(canvas, new SetPageIndexCommand(newFirstPage, 0));
                }
            }
        }
    }

    private final class DialogHandler
    implements ElementContainerListener,
    InteractionElementListener {
        DialogHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Page p;
            if (e.getElement() instanceof Page && (p = (Page)e.getElement()).getDeviceType() == Form.this.getDeviceType()) {
                Form.this.getContents().addChild(p.getDialog().indexOf(p), new Conversation(p));
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            Page p;
            if (e.getElement() instanceof Page && (p = (Page)e.getElement()).getDeviceType() == Form.this.getDeviceType()) {
                Iterator i = new ArrayList(Form.this.getContents().getChildrenReference()).iterator();
                while (i.hasNext()) {
                    Conversation c;
                    PNode n = (PNode)i.next();
                    if (!(n instanceof Conversation) || (c = (Conversation)n).getModel() != p) continue;
                    Form.this.getContents().removeChild(c);
                    c.dispose();
                }
            }
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class BasicInputEventHandler
    extends PBasicInputEventHandler {
        BasicInputEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            if (event.getComponent() instanceof VoiceCanvas) {
                this.updateHandles(event);
            }
        }

        private void updateHandles(PInputEvent event) {
            if (event.getComponent() instanceof VoiceCanvas) {
                ((VoiceCanvas)event.getComponent()).attachHandles(Form.this, event.getCamera());
            }
        }
    }
}

