/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.dialog;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.pattern.PatternInstanceView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.voice.ResponseDest;
import edu.berkeley.guir.damask.view.voice.VoiceLayer;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceComponent;
import edu.berkeley.guir.damask.view.voice.component.VoiceContent;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.component.VoicePanel;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectMany;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectManyItem;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectOne;
import edu.berkeley.guir.damask.view.voice.component.VoiceTextInput;
import edu.berkeley.guir.damask.view.voice.component.VoiceTrigger;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Conversation
extends InteractionElementView
implements ResponseDest {
    private static final int TEMPLATE_CONTROLS_ALPHA = 127;
    private final ElementContainerListener regionHandler = new PageRegionHandler();
    private final ElementContainerListener templateHandler = new TemplatePageRegionHandler();
    private final ElementContainerListener dialogHandler = new DialogHandler();
    private final ElementContainerListener selectManyHandler = new SelectManyHandler();
    private final Map views = new HashMap();
    private final Map viewsFromTemplate = new HashMap();
    private int firstNormalChildIndex = 0;
    private int firstGroupIndex = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.dialog.Conversation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected Conversation(Page page) {
        super(page);
        this.setPaint(null);
        this.setStrokePaint(null);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Page page = (Page)this.getModel();
        PageRegion region = this.getRegionModel();
        region.addElementContainerListener(this.regionHandler);
        region.getPage().getDialog().addElementContainerListener(this.dialogHandler);
        Iterator i = region.getControls().iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            this.addViewForNormalControl(control);
        }
        i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof VoiceControl)) continue;
            int j = 0;
            int n = ((Dialog)this.getForm().getModel()).getNumConditions();
            while (j < n) {
                Response response = ((VoiceControl)child).getResponse(j);
                if (response != null) {
                    response.updateDestFromModel();
                }
                ++j;
            }
        }
        i = page.getDialog().getGroups().iterator();
        while (i.hasNext()) {
            ComponentGroup group = (ComponentGroup)i.next();
            if (group.getTransformInPageRegion(region) == null) continue;
            this.addViewForGroup(group);
        }
    }

    public void dispose() {
        PageRegion regionModel = this.getRegionModel();
        Dialog dialogModel = ((Page)this.getModel()).getDialog();
        super.dispose();
        regionModel.removeElementContainerListener(this.regionHandler);
        dialogModel.removeElementContainerListener(this.dialogHandler);
    }

    public DeviceType getDeviceType() {
        return ((Page)this.getModel()).getDeviceType();
    }

    public PageRegion getRegionModel() {
        return ((Page)this.getModel()).getRegion(Direction.CENTER);
    }

    private VoiceControl addViewForNormalControl(Control control) {
        return (VoiceControl)this.addViewForComponent(this.getChildrenCount(), control);
    }

    public Form getForm() {
        return (Form)this.getParent().getParent();
    }

    private VoiceControl addViewForNormalControl(int index, Control control) {
        return (VoiceControl)this.addViewForComponent(index + this.firstNormalChildIndex, control);
    }

    private VoiceControl addViewForTemplateControl(Page template, Control control) {
        return this.addViewForTemplateControl(template, this.firstGroupIndex, control);
    }

    private VoiceControl addViewForTemplateControl(Page template, int index, Control control) {
        VoiceControl result = (VoiceControl)this.addViewForComponent(index, control);
        ++this.firstNormalChildIndex;
        ++this.firstGroupIndex;
        ((List)this.viewsFromTemplate.get(template)).add(result);
        DamaskAppUtils.setInternalColorAlpha(result, 127);
        result.setSelectable(false);
        return result;
    }

    private VoicePanel addViewForGroup(ComponentGroup group) {
        return this.addViewForGroup(this.firstNormalChildIndex - this.firstGroupIndex, group);
    }

    private VoicePanel addViewForGroup(int index, ComponentGroup group) {
        VoicePanel result = (VoicePanel)this.addViewForComponent(index + this.firstGroupIndex, group);
        ++this.firstNormalChildIndex;
        return result;
    }

    private VoiceComponent addViewForComponent(int index, Component component) {
        VoiceComponent view = null;
        if (component instanceof Content) {
            view = new VoiceContent((Content)component);
        } else if (component instanceof SelectMany) {
            view = new VoiceSelectMany((SelectMany)component);
        } else if (component instanceof SelectOne) {
            view = new VoiceSelectOne((SelectOne)component);
        } else if (component instanceof TextInput) {
            view = new VoiceTextInput((TextInput)component);
        } else if (component instanceof Trigger) {
            view = new VoiceTrigger((Trigger)component);
        } else if (component instanceof ComponentGroup) {
            view = new VoicePanel((ComponentGroup)component);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("element of type " + component.getClass() + " cannot be added to a page region"));
        }
        this.addChild(index, view);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.voice.VoiceLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VoiceLayer layer = (VoiceLayer)DamaskAppUtils.getAncestor(this, clazz);
        Form form = this.getForm();
        if (form != null && layer != null) {
            int n;
            int k;
            VoiceControl voiceControl;
            if (form.isContentsSelectable()) {
                layer.addSelectableParent(view);
                if (view instanceof VoiceControl) {
                    voiceControl = view;
                    k = 0;
                    n = ((Dialog)form.getModel()).getNumConditions();
                    while (k < n) {
                        if (voiceControl.getResponse(k) != null) {
                            layer.addSelectableParent(voiceControl.getResponse(k));
                        }
                        ++k;
                    }
                }
            } else {
                layer.removeSelectableParent(view);
                if (view instanceof VoiceControl) {
                    voiceControl = view;
                    k = 0;
                    n = ((Dialog)form.getModel()).getNumConditions();
                    while (k < n) {
                        if (voiceControl.getResponse(k) != null) {
                            layer.removeSelectableParent(voiceControl.getResponse(k));
                        }
                        ++k;
                    }
                }
            }
        }
        if (layer != null) {
            layer.adjustComponentByDeviceTypeLayer(view);
            layer.adjustComponentByDeviceTypeLayer(view);
            layer.trackAddition(view);
            if (component instanceof Control) {
                Iterator i = ((Control)component).getPatternInstanceMemberships().iterator();
                while (i.hasNext()) {
                    PatternInstance instance = (PatternInstance)i.next();
                    PatternInstanceView instanceView = (PatternInstanceView)layer.getView(instance);
                    if (instanceView == null) continue;
                    instanceView.addMemberView(view);
                }
            }
        }
        this.views.put(component, view);
        return view;
    }

    private void removeViewForTemplateControl(Page template, Control control) {
        VoiceControl removedView = (VoiceControl)this.removeViewForComponent(control);
        ((List)this.viewsFromTemplate.get(template)).remove(removedView);
        --this.firstNormalChildIndex;
        --this.firstGroupIndex;
    }

    private void removeViewForGroup(ComponentGroup group) {
        this.removeViewForComponent(group);
        --this.firstNormalChildIndex;
    }

    private VoiceComponent removeViewForComponent(Component component) {
        DamaskLayer layer;
        VoiceControl view = (VoiceControl)this.views.get(component);
        view.removeFromParent();
        view.dispose();
        this.views.remove(component);
        if (component instanceof Select) {
            ((Select)component).removeElementContainerListener(this.selectManyHandler);
        }
        if ((layer = this.getLayer()) != null && component instanceof Control) {
            Iterator i = ((Control)component).getPatternInstanceMemberships().iterator();
            while (i.hasNext()) {
                PatternInstance instance = (PatternInstance)i.next();
                PatternInstanceView instanceView = (PatternInstanceView)layer.getView(instance);
                if (instanceView == null) continue;
                instanceView.removeMemberView(view);
            }
        }
        return view;
    }

    protected void addTemplate(Page newTemplate) {
        if (newTemplate != null) {
            if (this.viewsFromTemplate.get(newTemplate) == null) {
                this.viewsFromTemplate.put(newTemplate, new ArrayList());
            }
            PageRegion region = this.getRegionModel();
            PageRegion templateRegion = newTemplate.getRegion(region.getName());
            Iterator i = templateRegion.getControls().iterator();
            while (i.hasNext()) {
                Control control = (Control)i.next();
                VoiceControl view = this.addViewForTemplateControl(newTemplate, control);
                view.setSelectable(false);
                DamaskAppUtils.setInternalColorAlpha(view, 127);
            }
            templateRegion.addElementContainerListener(this.templateHandler);
        }
    }

    protected void removeTemplate(Page oldTemplate) {
        if (oldTemplate != null) {
            PageRegion region = this.getRegionModel();
            PageRegion templateRegion = oldTemplate.getRegion(region.getName());
            List templateControlViews = (List)this.viewsFromTemplate.get(oldTemplate);
            Iterator i = templateControlViews.iterator();
            while (i.hasNext()) {
                ControlView controlView = (ControlView)i.next();
                this.removeChild(controlView);
                --this.firstNormalChildIndex;
                --this.firstGroupIndex;
            }
            templateControlViews.clear();
            templateRegion.removeElementContainerListener(this.templateHandler);
        }
    }

    public VoiceControl getPreviousLowLevelControl(VoiceControl voiceControl) {
        if (voiceControl instanceof VoiceSelectManyItem) {
            VoiceSelectManyItem voiceItem = (VoiceSelectManyItem)voiceControl;
            VoiceSelectMany voiceSelect = (VoiceSelectMany)voiceItem.getParent();
            int index = voiceSelect.indexOfChild(voiceItem);
            if (index > 0) {
                return (VoiceSelectManyItem)voiceSelect.getChild(index - 1);
            }
            return this.getPreviousLowLevelControl((VoiceSelectMany)voiceItem.getParent());
        }
        int childIndex = this.indexOfChild(voiceControl);
        if (childIndex > 0) {
            VoiceControl voiceControlBefore = (VoiceControl)this.getChild(childIndex - 1);
            if (voiceControlBefore instanceof VoiceSelectMany) {
                return (VoiceSelectManyItem)voiceControlBefore.getChild(voiceControlBefore.getChildrenCount() - 1);
            }
            return voiceControlBefore;
        }
        return null;
    }

    public VoiceControl getNextLowLevelControl(VoiceControl voiceControl) {
        if (voiceControl instanceof VoiceSelectManyItem) {
            VoiceSelectManyItem voiceItem = (VoiceSelectManyItem)voiceControl;
            VoiceSelectMany voiceSelect = (VoiceSelectMany)voiceItem.getParent();
            int index = voiceSelect.indexOfChild(voiceItem);
            if (index < voiceSelect.getChildrenCount() - 1) {
                return (VoiceSelectManyItem)voiceSelect.getChild(index + 1);
            }
            return this.getNextLowLevelControl((VoiceSelectMany)voiceItem.getParent());
        }
        int childIndex = this.indexOfChild(voiceControl);
        if (childIndex < this.getChildrenCount() - 1) {
            VoiceControl voiceControlAfter = (VoiceControl)this.getChild(childIndex + 1);
            if (voiceControlAfter instanceof VoiceSelectMany) {
                return (VoiceSelectManyItem)voiceControlAfter.getChild(0);
            }
            return voiceControlAfter;
        }
        return null;
    }

    public VoiceControl getPreviousVoiceControlWithPrompt(VoiceControl voiceControl) {
        VoiceControl prevVoiceControl = this.getPreviousLowLevelControl(voiceControl);
        Prompt prevPrompt = prevVoiceControl == null ? null : prevVoiceControl.getPrompt();
        while (prevPrompt == null && prevVoiceControl != null) {
            Prompt prompt = prevPrompt = (prevVoiceControl = this.getPreviousLowLevelControl(prevVoiceControl)) == null ? null : prevVoiceControl.getPrompt();
        }
        return prevVoiceControl;
    }

    public VoiceControl getNextVoiceControlWithPrompt(VoiceControl voiceControl) {
        VoiceControl nextVoiceControl = this.getNextLowLevelControl(voiceControl);
        Prompt nextPrompt = nextVoiceControl == null ? null : nextVoiceControl.getPrompt();
        while (nextPrompt == null && nextVoiceControl != null) {
            Prompt prompt = nextPrompt = (nextVoiceControl = this.getNextLowLevelControl(nextVoiceControl)) == null ? null : nextVoiceControl.getPrompt();
        }
        return nextVoiceControl;
    }

    protected void deviceTypeLayerChanged() {
        Iterator j = this.getChildrenIterator();
        while (j.hasNext()) {
            PNode child = (PNode)j.next();
            if (!(child instanceof VoiceControl)) continue;
            ((VoiceControl)child).deviceTypeLayerChanged();
        }
    }

    public Point2D getAnchorPt() {
        Form form = this.getForm();
        if (form.getContents().indexOfChild(this) == 0) {
            Point2D anchorPt = form.getAnchorPt();
            form.localToGlobal(anchorPt);
            this.globalToLocal(anchorPt);
            return anchorPt;
        }
        if (this.getChildrenCount() > 0) {
            PNode firstChild = this.getChild(this.firstNormalChildIndex);
            if (firstChild instanceof VoiceControl) {
                Prompt firstPrompt = ((VoiceControl)this.getChild(this.firstNormalChildIndex)).getPrompt();
                Point2D anchorPt = firstPrompt.getBounds().getCenter2D();
                firstPrompt.localToGlobal(anchorPt);
                this.globalToLocal(anchorPt);
                return anchorPt;
            }
            Point2D.Double anchorPt = new Point2D.Double(this.getBounds().getCenterX(), this.getBounds().getMinY());
            return anchorPt;
        }
        Point2D.Double anchorPt = new Point2D.Double(this.getBounds().getCenterX(), this.getBounds().getMinY());
        return anchorPt;
    }

    public Rectangle2D getDestBounds() {
        PBounds bounds;
        Form form = this.getForm();
        if (form.getContents().indexOfChild(this) == 0) {
            bounds = form.getBounds();
            form.localToGlobal(bounds);
            this.globalToLocal(bounds);
        } else if (this.getChildrenCount() == 0) {
            bounds = this.getBounds();
        } else {
            VoiceControl firstControl = (VoiceControl)this.getChild(this.firstNormalChildIndex);
            if (firstControl == null) {
                bounds = this.getBounds();
            } else {
                Prompt firstPrompt = firstControl.getPrompt();
                if (firstPrompt == null) {
                    bounds = this.getBounds();
                } else {
                    bounds = firstPrompt.getBounds();
                    firstPrompt.localToGlobal(bounds);
                    this.globalToLocal(bounds);
                }
            }
        }
        return bounds;
    }

    private class PageRegionHandler
    implements ElementContainerListener {
        PageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Conversation.this.addViewForNormalControl(e.getIndex(), (Control)e.getElement());
        }

        public void elementRemoved(ElementContainerEvent e) {
            Conversation.this.removeViewForComponent((Control)e.getElement());
        }
    }

    private class DialogHandler
    implements ElementContainerListener {
        DialogHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            ComponentGroup group;
            if (e.getElement() instanceof ComponentGroup && (group = (ComponentGroup)e.getElement()).getDeviceTypesVisibleTo().contains(Conversation.this.getDeviceType()) && group.getTransformInPageRegion(Conversation.this.getRegionModel()) != null) {
                Conversation.this.addViewForGroup(group);
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            ComponentGroup group;
            if (e.getElement() instanceof ComponentGroup && (group = (ComponentGroup)e.getElement()).getDeviceTypesVisibleTo().contains(Conversation.this.getDeviceType()) && group.getTransformInPageRegion(Conversation.this.getRegionModel()) != null) {
                Conversation.this.removeViewForGroup(group);
            }
        }
    }

    private class TemplatePageRegionHandler
    implements ElementContainerListener {
        TemplatePageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Conversation.this.addViewForTemplateControl(((PageRegion)e.getSource()).getPage(), e.getIndex(), (Control)e.getElement());
        }

        public void elementRemoved(ElementContainerEvent e) {
            Conversation.this.removeViewForTemplateControl(((PageRegion)e.getSource()).getPage(), (Control)e.getElement());
        }
    }

    private class SelectManyHandler
    implements ElementContainerListener {
        SelectManyHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Conversation.this.addViewForNormalControl((Control)e.getElement());
        }

        public void elementRemoved(ElementContainerEvent e) {
            Conversation.this.removeViewForComponent((Control)e.getElement());
        }
    }
}

