/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.event.ConnectionSourceEvent;
import edu.berkeley.guir.damask.event.ConnectionSourceListener;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.voice.ResponseSource;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.dialog.Conversation;

public class VoiceTrigger
extends VoiceControl {
    private final ConnectionSourceHandler connectionSourceHandler = new ConnectionSourceHandler();

    public VoiceTrigger(Trigger model) {
        super(model);
        model.addConnectionSourceListener(this.connectionSourceHandler);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Trigger trigger = (Trigger)this.getModel();
        Conversation conversation = this.getConversation();
        ResponseSource responseSource = (ResponseSource)((Object)conversation.getPreviousVoiceControlWithPrompt(this));
        int i = 0;
        int n = ((Dialog)this.getForm().getModel()).getNumConditions();
        while (i < n) {
            NavConnection navConnection = trigger.getOutConnection(DeviceType.VOICE, new InvokeEvent(this), i);
            this.setResponse(i, new Response(this, responseSource, navConnection));
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        ((Trigger)this.getModel()).removeConnectionSourceListener(this.connectionSourceHandler);
    }

    private class ConnectionSourceHandler
    implements ConnectionSourceListener {
        ConnectionSourceHandler() {
        }

        public void outConnectionAdded(ConnectionSourceEvent e) {
            if (e.getSource() == VoiceTrigger.this.getModel()) {
                NavConnection connection = (NavConnection)e.getConnection();
                int condition = connection.getCondition();
                Response oldResponse = VoiceTrigger.this.getResponse(condition);
                ResponseSource responseSource = (ResponseSource)((Object)VoiceTrigger.this.getConversation().getPreviousVoiceControlWithPrompt(VoiceTrigger.this));
                VoiceTrigger.this.setResponse(condition, new Response(VoiceTrigger.this, responseSource, connection));
                if (oldResponse != null) {
                    oldResponse.dispose();
                }
            }
        }

        public void outConnectionRemoved(ConnectionSourceEvent e) {
            if (e.getSource() == VoiceTrigger.this.getModel()) {
                NavConnection connection = (NavConnection)e.getConnection();
                int condition = connection.getCondition();
                Response oldResponse = VoiceTrigger.this.getResponse(condition);
                ResponseSource responseSource = (ResponseSource)((Object)VoiceTrigger.this.getConversation().getPreviousVoiceControlWithPrompt(VoiceTrigger.this));
                VoiceTrigger.this.setResponse(condition, new Response(VoiceTrigger.this, responseSource, null));
                if (oldResponse != null) {
                    oldResponse.dispose();
                }
            }
        }
    }
}

