/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectManyItem;
import edu.umd.cs.piccolo.PNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VoiceSelectMany
extends VoiceControl {
    private final Map views = new HashMap();
    private final SelectManyHandler selectManyHandler = new SelectManyHandler();
    private boolean childrenSelectable = true;

    public VoiceSelectMany(SelectMany selectMany) {
        super(selectMany);
        selectMany.addElementContainerListener(this.selectManyHandler);
        super.setSelectable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Iterator i = ((SelectMany)this.getModel()).getItems().iterator();
        while (i.hasNext()) {
            SelectMany.Item selectManyItem = (SelectMany.Item)i.next();
            VoiceSelectManyItem voiceSelectManyItem = new VoiceSelectManyItem(selectManyItem);
            this.addChild(voiceSelectManyItem);
            this.views.put(selectManyItem, voiceSelectManyItem);
        }
    }

    public void dispose() {
        super.dispose();
        ((SelectMany)this.getModel()).removeElementContainerListener(this.selectManyHandler);
    }

    public void setSelectable(boolean flag) {
        this.childrenSelectable = flag;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            VoiceSelectManyItem item = (VoiceSelectManyItem)i.next();
            item.setSelectable(flag);
        }
    }

    public void setPickable(boolean flag) {
        super.setPickable(flag);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            VoiceSelectManyItem item = (VoiceSelectManyItem)i.next();
            item.setPickable(flag);
        }
    }

    public class SelectManyHandler
    implements ElementContainerListener {
        public void elementAdded(ElementContainerEvent e) {
            SelectMany.Item selectManyItem = (SelectMany.Item)e.getElement();
            VoiceSelectManyItem voiceSelectManyItem = new VoiceSelectManyItem(selectManyItem);
            VoiceSelectMany.this.addChild(voiceSelectManyItem);
            voiceSelectManyItem.setSelectable(VoiceSelectMany.this.childrenSelectable);
            voiceSelectManyItem.setPickable(VoiceSelectMany.this.getPickable());
            VoiceSelectMany.this.views.put(selectManyItem, voiceSelectManyItem);
        }

        public void elementRemoved(ElementContainerEvent e) {
            InteractionElement element = e.getElement();
            PNode elementView = (PNode)VoiceSelectMany.this.views.get(element);
            elementView.removeFromParent();
            VoiceSelectMany.this.views.remove(element);
        }
    }
}

