/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.GroupEvent;
import edu.berkeley.guir.damask.event.GroupListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.voice.component.VoiceComponent;
import edu.berkeley.guir.damask.view.voice.dialog.Conversation;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class VoicePanel
extends VoiceComponent {
    public static final int INITIAL_SIZE = 40;
    private static final Color BOUNDARY_COLOR = Color.DARK_GRAY;
    private static final Color BACKGROUND_COLOR = DamaskAppUtils.NO_COLOR;
    private static final Color TEXT_COLOR = Color.DARK_GRAY;
    private static final float TEXT_SIZE = 36.0f;
    private static final Stroke BOUNDARY_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private final GroupListener groupHandler = new GroupHandler();
    private boolean inRunMode = false;

    public VoicePanel(ComponentGroup group) {
        super(group);
        this.setPaint(BACKGROUND_COLOR);
        this.setStrokePaint(BOUNDARY_COLOR);
        this.setStroke(BOUNDARY_STROKE);
        group.addGroupListener(this.groupHandler);
    }

    protected void initAfterAddToParent() {
        PageRegion region = ((Conversation)this.getParent()).getRegionModel();
        ComponentGroup group = (ComponentGroup)this.getModel();
        Rectangle2D bounds = group.getBoundsInPageRegion(region);
        if (bounds != null) {
            this.setBounds(bounds);
            this.setPathTo(bounds);
        }
        this.setTransform(group.getTransformInPageRegion(region));
    }

    public static PNode createTempView() {
        PPath border = new PPath(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
        border.setStrokePaint(BOUNDARY_COLOR);
        border.setStroke(BOUNDARY_STROKE);
        return border;
    }

    public Object getEditableContents() {
        return null;
    }

    public boolean isInRunMode() {
        return this.inRunMode;
    }

    public void setInRunMode(boolean flag) {
        this.inRunMode = flag;
        if (this.inRunMode) {
            this.setStrokePaint(null);
            this.setStroke(null);
        } else {
            this.setStrokePaint(BOUNDARY_COLOR);
            this.setStroke(BOUNDARY_STROKE);
        }
    }

    private class GroupHandler
    implements GroupListener {
        GroupHandler() {
        }

        public void elementBoundsUpdated(GroupEvent e) {
            if (e.getPageRegion() == VoicePanel.this.getForm().getModel()) {
                VoicePanel.this.setBounds(e.getComponentGroup().getBoundsInPageRegion(e.getPageRegion()));
            }
        }

        public void elementTransformUpdated(GroupEvent e) {
            if (e.getPageRegion() == VoicePanel.this.getForm().getModel()) {
                AffineTransform newTransform = e.getComponentGroup().getTransformInPageRegion(e.getPageRegion());
                PAffineTransform oldTransform = VoicePanel.this.getTransform();
                if (!oldTransform.equals(newTransform)) {
                    VoicePanel.this.setTransform(newTransform);
                }
            }
        }
    }
}

