/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class VoiceControl
extends VoiceComponent {
    private Prompt prompt;
    private Map responses = new HashMap();

    protected VoiceControl(Control model) {
        super(model);
        this.setStrokePaint(null);
        this.setResizable(false);
    }

    public void dispose() {
        super.dispose();
        if (this.prompt != null) {
            this.prompt.removeFromParent();
            this.prompt.dispose();
        }
        Iterator i = this.responses.values().iterator();
        while (i.hasNext()) {
            Response response = (Response)i.next();
            if (response == null) continue;
            response.removeFromParent();
            response.dispose();
        }
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    protected void setPrompt(Prompt prompt) {
        if (this.prompt != null) {
            this.prompt.removeFromParent();
        }
        this.prompt = prompt;
        if (this.prompt != null) {
            this.addChild(0, prompt);
        }
    }

    public Response getResponse(int condition) {
        return (Response)this.responses.get(new Integer(condition));
    }

    protected void setResponse(int condition, Response response) {
        DamaskLayer layer;
        Response oldResponse = this.getResponse(condition);
        if (oldResponse != null) {
            oldResponse.removeFromParent();
        }
        this.responses.put(new Integer(condition), response);
        if (response != null) {
            this.addChild(response);
        }
        if ((layer = this.getLayer()) != null) {
            if (oldResponse != null) {
                layer.removeSelectableParent(oldResponse);
            }
            if (response != null) {
                layer.addSelectableParent(response);
            }
        }
    }

    public void deviceTypeLayerChanged() {
        if (this.prompt != null) {
            this.prompt.deviceTypeLayerChanged();
        }
        Iterator i = this.responses.values().iterator();
        while (i.hasNext()) {
            Response response = (Response)i.next();
            response.deviceTypeLayerChanged();
        }
    }
}

