/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.event.ContentEvent;
import edu.berkeley.guir.damask.event.ContentListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SyncButton
extends DamaskPPath {
    private DamaskPPath leftArrowNode;
    private DamaskPPath rightArrowNode;
    private boolean sync = true;
    private final List contentsToHandle;
    private ContentListener contentHandler = new ContentHandler();
    private final Paint onPaint;
    private final Paint offPaint;

    public SyncButton(Rectangle2D bounds, List contentsToHandle, Paint onPaint, Paint offPaint) {
        Content content;
        this.contentsToHandle = new ArrayList(contentsToHandle);
        this.onPaint = onPaint;
        this.offPaint = offPaint;
        this.setPathTo(bounds);
        float syncButtonWidth = (float)this.getWidth();
        GeneralPath leftArrow = new GeneralPath();
        leftArrow.moveTo(syncButtonWidth - 4.0f, 0.0f);
        leftArrow.lineTo(0.0f, 0.0f);
        leftArrow.moveTo(3.0f, -3.0f);
        leftArrow.lineTo(0.0f, 0.0f);
        leftArrow.lineTo(3.0f, 3.0f);
        this.leftArrowNode = new DamaskPPath(leftArrow);
        this.leftArrowNode.setPickable(false);
        this.addChild(this.leftArrowNode);
        GeneralPath rightArrow = new GeneralPath();
        rightArrow.moveTo(0.0f, 0.0f);
        rightArrow.lineTo(syncButtonWidth - 4.0f, 0.0f);
        rightArrow.moveTo(syncButtonWidth - 7.0f, -3.0f);
        rightArrow.lineTo(syncButtonWidth - 4.0f, 0.0f);
        rightArrow.lineTo(syncButtonWidth - 7.0f, 3.0f);
        this.rightArrowNode = new DamaskPPath(rightArrow);
        this.rightArrowNode.setPickable(false);
        this.addChild(this.rightArrowNode);
        Iterator i = contentsToHandle.iterator();
        while (i.hasNext()) {
            content = (Content)i.next();
            this.setSyncStatus(content.isPromptTextSyncedWithText());
        }
        this.setPaint(DamaskAppUtils.NO_COLOR);
        this.setStrokePaint(DamaskAppUtils.NO_COLOR);
        this.addInputEventListener(new SyncButtonHandler());
        i = contentsToHandle.iterator();
        while (i.hasNext()) {
            content = (Content)i.next();
            content.addContentEventListener(this.contentHandler);
        }
    }

    public void dispose() {
        Iterator i = this.contentsToHandle.iterator();
        while (i.hasNext()) {
            Content content = (Content)i.next();
            content.removeContentEventListener(this.contentHandler);
        }
    }

    protected void layoutChildren() {
        float syncButtonHeight = (float)this.getHeight();
        this.leftArrowNode.setOffset(this.getX() + 2.0, this.getY() + (double)(syncButtonHeight / 2.0f) - this.leftArrowNode.getHeight() - 2.0);
        this.rightArrowNode.setOffset(this.getX() + 2.0, this.getY() + (double)(syncButtonHeight / 2.0f) + 2.0);
    }

    public boolean getSyncStatus() {
        return this.sync;
    }

    public void setSyncStatus(boolean flag) {
        this.sync = flag;
        Paint arrowPaint = this.sync ? this.onPaint : this.offPaint;
        this.leftArrowNode.setStrokePaint(arrowPaint);
        this.rightArrowNode.setStrokePaint(arrowPaint);
    }

    private class SyncButtonHandler
    extends PBasicInputEventHandler {
        SyncButtonHandler() {
        }

        public void mousePressed(PInputEvent event) {
            boolean newSyncStatus = !SyncButton.this.getSyncStatus();
            Iterator i = SyncButton.this.contentsToHandle.iterator();
            while (i.hasNext()) {
                Content content = (Content)i.next();
                content.setPromptTextSyncedWithText(newSyncStatus);
            }
        }
    }

    private class ContentHandler
    implements ContentListener {
        ContentHandler() {
        }

        public void strokeAdded(ContentEvent e) {
        }

        public void strokeRemoved(ContentEvent e) {
        }

        public void strokesChanged(ContentEvent e) {
        }

        public void textChanged(ContentEvent e) {
        }

        public void imageChanged(ContentEvent e) {
        }

        public void preferredDisplayModeChanged(ContentEvent e) {
        }

        public void promptTextIsSyncedWithText(ContentEvent e) {
            SyncButton.this.setSyncStatus(true);
        }

        public void promptTextIsUnsyncedWithText(ContentEvent e) {
            SyncButton.this.setSyncStatus(false);
        }
    }
}

