/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.voice.ResponseDest;
import edu.berkeley.guir.damask.view.voice.ResponseInternalDest;
import edu.berkeley.guir.damask.view.voice.ResponseSource;
import edu.berkeley.guir.damask.view.voice.VoiceLayer;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.SyncButton;
import edu.berkeley.guir.damask.view.voice.component.VoiceContent;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.component.VoicePart;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectManyItem;
import edu.berkeley.guir.damask.view.voice.component.VoiceSelectOne;
import edu.berkeley.guir.damask.view.voice.component.VoiceTextInput;
import edu.berkeley.guir.damask.view.voice.component.VoiceTrigger;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Response
extends VoicePart {
    public static final String NULL_DISPLAY_STRING = "Text";
    private static final Paint TEXT_FILL_PAINT = new Color(205, 255, 191);
    private static final Paint TEXT_BORDER_PAINT;
    private static final int HOTSPOT_RADIUS = 10;
    public static final int DEFAULT_LENGTH = 225;
    public static final int MIN_RESPONSE_LENGTH_OUTSIDE_BALLOON = 40;
    public static final int SYNC_BUTTON_WIDTH = 10;
    private static final int SYNC_BUTTON_HEIGHT = 20;
    private static final Paint SYNC_ON_COLOR;
    private static final Paint SYNC_OFF_COLOR;
    private static final int INSET = 6;
    private static final int VOICE_BALLOON_POINT_Y = 10;
    private ResponseSource source;
    private ResponseDest dest;
    private NavConnection navConnection;
    private DamaskPPath arrow = new DamaskPPath();
    private HotSpot startHotSpot = new HotSpot(new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
    private HotSpot endHotSpot = new HotSpot(new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
    private final ElementHandler elementHandler = new ElementHandler();
    private final ControlVoiceHandler controlVoiceHandler = new ControlVoiceHandler();
    private final EndpointHandler endpointHandler = new EndpointHandler();
    private final TextGroup textGroup = new TextGroup();
    private final PNode lineGroup = new PNode();
    private SyncButton syncButton = null;
    private int condition;

    static {
        SYNC_ON_COLOR = TEXT_BORDER_PAINT = new Color(19, 142, 52);
        SYNC_OFF_COLOR = new Color(148, 220, 169);
    }

    public Response(VoiceContent voiceContent, ResponseInternalDest dest) {
        super(voiceContent.getModel(), false);
        this.init(voiceContent, dest);
    }

    public Response(VoiceSelectManyItem voiceSelectManyItem, ResponseInternalDest dest) {
        super(voiceSelectManyItem.getModel(), false);
        this.init(voiceSelectManyItem, dest);
    }

    public Response(VoiceSelectOne voiceSelectOne, ResponseSource source, ResponseInternalDest dest) {
        super(voiceSelectOne.getModel(), false);
        this.init(source, dest);
    }

    public Response(VoiceTextInput voiceTextInput, ResponseSource source, ResponseInternalDest dest) {
        super(voiceTextInput.getModel(), false);
        this.init(source, dest);
    }

    public Response(VoiceTrigger voiceTrigger, ResponseSource source, NavConnection connection) {
        super(voiceTrigger.getModel(), false);
        this.navConnection = connection;
        this.init(source, null);
    }

    private void init(final ResponseSource source, final ResponseDest dest) {
        this.setPaint(null);
        this.setStrokePaint(null);
        ((Control)this.getModel()).addControlVoiceListener(this.controlVoiceHandler);
        this.setResizable(false);
        this.setSelectable(false);
        this.arrow.setPickable(false);
        this.startHotSpot.setPaint(DamaskAppUtils.NO_COLOR);
        this.startHotSpot.setStrokePaint(DamaskAppUtils.NO_COLOR);
        this.endHotSpot.setPaint(DamaskAppUtils.NO_COLOR);
        this.endHotSpot.setStrokePaint(DamaskAppUtils.NO_COLOR);
        this.addPropertyChangeListener("parent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (Response.this.getParent() != null) {
                    Response.this.setSource(source);
                    if (Response.this.navConnection != null) {
                        Response.this.updateDestFromConnection();
                    } else {
                        Response.this.setDest(dest);
                    }
                }
            }
        });
        this.textGroup.setPaint(TEXT_FILL_PAINT);
        this.textGroup.setStrokePaint(TEXT_BORDER_PAINT);
        this.lineGroup.setPickable(false);
        this.addChild(this.lineGroup);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Control model = (Control)this.getModel();
        model.addInteractionElementListener(this.elementHandler);
        this.condition = this.getForm().getDesignTimeCondition();
        this.setTransform(new AffineTransform());
        this.updateArrowFromModel();
        this.addChild(this.arrow);
        this.arrow.setPickable(false);
        this.addChild(this.startHotSpot);
        this.addChild(this.endHotSpot);
        this.addChild(this.textGroup);
        this.updateTextString();
    }

    public void dispose() {
        Form form;
        super.dispose();
        this.syncButton.dispose();
        Control model = (Control)this.getModel();
        model.removeControlVoiceListener(this.controlVoiceHandler);
        if (model != null) {
            model.removeInteractionElementListener(this.elementHandler);
        }
        if (this.source != null) {
            this.source.removePropertyChangeListener("bounds", this.endpointHandler);
            this.source.removePropertyChangeListener("transform", this.endpointHandler);
            form = this.source.getForm();
            if (form != null) {
                form.removePropertyChangeListener("bounds", this.endpointHandler);
                form.removePropertyChangeListener("transform", this.endpointHandler);
            }
        }
        if (this.dest != null) {
            this.dest.removePropertyChangeListener("bounds", this.endpointHandler);
            this.dest.removePropertyChangeListener("transform", this.endpointHandler);
            form = this.dest.getForm();
            if (form != null) {
                form.removePropertyChangeListener("bounds", this.endpointHandler);
                form.removePropertyChangeListener("transform", this.endpointHandler);
            }
        }
    }

    public ResponseSource getSource() {
        return this.source;
    }

    public void setSource(ResponseSource source) {
        Form form;
        if (this.source != null) {
            this.source.removePropertyChangeListener("bounds", this.endpointHandler);
            this.source.removePropertyChangeListener("transform", this.endpointHandler);
            form = this.source.getForm();
            if (form != null) {
                form.removePropertyChangeListener("bounds", this.endpointHandler);
                form.removePropertyChangeListener("transform", this.endpointHandler);
            }
        }
        this.source = source;
        this.updateArrowFromModel();
        if (source != null) {
            source.addPropertyChangeListener("bounds", this.endpointHandler);
            source.addPropertyChangeListener("transform", this.endpointHandler);
            form = source.getForm();
            if (form != null) {
                form.addPropertyChangeListener("bounds", this.endpointHandler);
                form.addPropertyChangeListener("transform", this.endpointHandler);
            }
        }
        this.setMovable(source == null && this.dest == null);
    }

    public ResponseDest getDest() {
        return this.dest;
    }

    public void setDest(ResponseDest dest) {
        Form form;
        if (this.dest != null) {
            this.dest.removePropertyChangeListener("bounds", this.endpointHandler);
            this.dest.removePropertyChangeListener("transform", this.endpointHandler);
            form = this.dest.getForm();
            if (form != null) {
                form.removePropertyChangeListener("bounds", this.endpointHandler);
                form.removePropertyChangeListener("transform", this.endpointHandler);
            }
        }
        this.dest = dest;
        this.updateArrowFromModel();
        if (dest != null) {
            dest.addPropertyChangeListener("bounds", this.endpointHandler);
            dest.addPropertyChangeListener("transform", this.endpointHandler);
            form = dest.getForm();
            if (form != null) {
                form.addPropertyChangeListener("bounds", this.endpointHandler);
                form.addPropertyChangeListener("transform", this.endpointHandler);
            }
        }
        this.setMovable(this.source == null && dest == null);
    }

    protected void updateDestFromConnection() {
        if (this.navConnection == null) {
            return;
        }
        this.setDest((ResponseDest)((Object)this.getLayer().getView(this.navConnection.getDest(DeviceType.VOICE))));
    }

    protected void layoutChildren() {
        PText textNode;
        PText textNode2;
        PNode child;
        boolean hasResponseText = true;
        this.lineGroup.removeAllChildren();
        double height = 0.0;
        PBounds textGroupBounds = new PBounds();
        Iterator i = this.textGroup.getChildrenIterator();
        while (i.hasNext()) {
            child = (PNode)i.next();
            if (!(child instanceof PText)) continue;
            textNode2 = (PText)child;
            textNode2.setOffset(0.0, height);
            height += textNode2.getHeight();
            textGroupBounds.add(textNode2.localToParent(textNode2.getBounds()));
        }
        i = this.textGroup.getChildrenIterator();
        while (i.hasNext()) {
            child = (PNode)i.next();
            if (!(child instanceof PText)) continue;
            textNode2 = (PText)child;
            double width = textNode2.getWidth();
            textNode2.offset((textGroupBounds.getWidth() - width) / 2.0, 0.0);
        }
        PBounds newTextBounds = new PBounds();
        PText firstTextNode = null;
        Iterator i2 = this.textGroup.getChildrenIterator();
        while (i2.hasNext()) {
            PNode child2 = (PNode)i2.next();
            if (!(child2 instanceof PText)) continue;
            textNode = (PText)child2;
            if (firstTextNode == null) {
                firstTextNode = textNode;
            }
            newTextBounds.add(textNode.localToParent(textNode.getBounds()));
        }
        newTextBounds = new PBounds(newTextBounds.getX() - 10.0, newTextBounds.getY() - 6.0, newTextBounds.getWidth() + 10.0 + 6.0, newTextBounds.getHeight() + 12.0);
        if (firstTextNode == null || firstTextNode.getText().trim().equals("")) {
            hasResponseText = false;
            textGroupBounds.setFrame(newTextBounds.getX(), newTextBounds.getY(), 20.0, 20.0);
            this.textGroup.setPathTo(DamaskAppUtils.createDiamond(textGroupBounds));
        } else {
            this.textGroup.setPathTo(DamaskAppUtils.createVoiceBalloon(newTextBounds, 20.0f, 20.0f, 20.0f, 15.0f, 10.0f, 25.0f));
        }
        PBounds arrowBounds = this.arrow.getBounds();
        if (hasResponseText) {
            this.textGroup.setOffset((((RectangularShape)arrowBounds).getWidth() - textGroupBounds.getWidth()) / 2.0 + ((RectangularShape)arrowBounds).getX(), (((RectangularShape)arrowBounds).getHeight() - textGroupBounds.getHeight()) / 2.0 + ((RectangularShape)arrowBounds).getY());
        } else {
            this.textGroup.setOffset(((RectangularShape)arrowBounds).getWidth() / 2.0 + ((RectangularShape)arrowBounds).getX(), ((RectangularShape)arrowBounds).getHeight() / 2.0 + ((RectangularShape)arrowBounds).getY());
        }
        PBounds newTextGroupBounds = this.textGroup.getBounds();
        this.textGroup.localToParent(newTextGroupBounds);
        ArrayList<PText> textNodes = new ArrayList<PText>();
        Iterator i3 = this.textGroup.getChildrenIterator();
        while (i3.hasNext()) {
            PNode child3 = (PNode)i3.next();
            if (!(child3 instanceof PText)) continue;
            textNodes.add((PText)child3);
        }
        i3 = textNodes.iterator();
        while (i3.hasNext()) {
            textNode = (PText)i3.next();
            if (!i3.hasNext()) continue;
            PBounds textBounds = textNode.getBounds();
            textNode.localToGlobal(textBounds);
            this.lineGroup.globalToLocal(textBounds);
            PPath line = new PPath(new Line2D.Double(newTextGroupBounds.getX() + 10.0 + 5.0, textBounds.getMaxY(), newTextGroupBounds.getMaxX() - 5.0, textBounds.getMaxY()));
            line.setStrokePaint(TEXT_BORDER_PAINT);
            this.lineGroup.addChild(line);
        }
        if (hasResponseText) {
            PPath verticalLine = new PPath(new Line2D.Double(newTextGroupBounds.getX() + 10.0, newTextGroupBounds.getMinY() + 5.0, newTextGroupBounds.getX() + 10.0, newTextGroupBounds.getMaxY() - 10.0 - 5.0));
            verticalLine.setStrokePaint(TEXT_BORDER_PAINT);
            this.lineGroup.addChild(verticalLine);
        }
        this.lineGroup.moveToFront();
    }

    protected void updateTextString() {
        List responseTextList = ((Control)this.getModel()).getVoiceResponseTextList();
        Iterator i = this.textGroup.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof PText)) continue;
            i.remove();
        }
        i = responseTextList.iterator();
        while (i.hasNext()) {
            String text = (String)i.next();
            PText textNode = new PText();
            textNode.setPickable(false);
            DamaskAppUtils.setFontSize(textNode, DeviceType.VOICE.getDefaultFontSize());
            if (text == null) {
                textNode.setText(NULL_DISPLAY_STRING);
            } else {
                textNode.setText(text);
            }
            this.textGroup.addChild(textNode);
        }
        if (this.syncButton != null) {
            this.syncButton.dispose();
            this.syncButton.removeFromParent();
        }
        this.syncButton = new SyncButton(new Rectangle2D.Double(0.0, 0.0, 10.0, 20.0), this.getContentModels(), SYNC_ON_COLOR, SYNC_OFF_COLOR);
        this.syncButton.setOffset(-10.0, 0.0);
        if (this.getContentSource().isForAllDeviceTypes()) {
            this.textGroup.addChild(this.syncButton);
        }
    }

    protected Control getContentSource() {
        Control beforeControl;
        PageRegion region;
        Control control;
        Control contentSourceControl = control = (Control)this.getModel();
        if (control instanceof Trigger && this.getDeviceType() != null && (region = control.getPageRegion(this.getDeviceType())) != null && ((beforeControl = region.getPreviousControl(control)) instanceof SelectOne || beforeControl instanceof SelectMany || beforeControl instanceof TextInput)) {
            contentSourceControl = beforeControl;
        }
        return contentSourceControl;
    }

    protected List getContentModels() {
        ArrayList<Content> result = new ArrayList<Content>();
        Control contentSourceControl = this.getContentSource();
        if (contentSourceControl instanceof Trigger) {
            result.add(((Trigger)contentSourceControl).getContent());
        } else if (contentSourceControl instanceof SelectOne) {
            Iterator i = ((SelectOne)contentSourceControl).getItems().iterator();
            while (i.hasNext()) {
                SelectOne.Item item = (SelectOne.Item)i.next();
                result.add(item.getContent());
            }
        }
        return result;
    }

    private void updateArrowFromView() {
        Point2D sourcePt = null;
        Point2D destPt = null;
        Polygon2D poly = GeomLib.pathIteratorToPolygon2D(this.getPathReference().getPathIterator(new AffineTransform()));
        if (poly.npoints == 0) {
            return;
        }
        if (((Control)this.getModel()).getVoiceResponseLine(this.condition) == null) {
            this.updateArrow(null);
            return;
        }
        double dx = poly.xpoints[poly.npoints - 1] - poly.xpoints[0];
        double dy = poly.ypoints[poly.npoints - 1] - poly.ypoints[0];
        if (this.source == null && this.dest == null) {
            sourcePt = new Point2D.Double(poly.xpoints[0], poly.ypoints[0]);
            destPt = new Point2D.Double(poly.xpoints[poly.npoints - 1], poly.ypoints[poly.npoints - 1]);
        } else {
            double fracY;
            double fracX;
            PBounds promptBounds;
            Prompt prompt;
            if (this.source != null) {
                sourcePt = this.source.getAnchorPt();
                this.source.localToGlobal(sourcePt);
                this.globalToLocal(sourcePt);
            }
            if (this.dest != null) {
                destPt = this.dest.getAnchorPt();
                this.dest.localToGlobal(destPt);
                this.globalToLocal(destPt);
            }
            if (this.source == null) {
                sourcePt = new Point2D.Double(destPt.getX() - dx, destPt.getY() - dy);
            }
            if (this.dest == null) {
                destPt = new Point2D.Double(sourcePt.getX() + dx, sourcePt.getY() + dy);
            }
            Point2D origSourcePt = sourcePt;
            if (this.source instanceof VoiceControl) {
                prompt = ((VoiceControl)((Object)this.source)).getPrompt();
                promptBounds = prompt.getBounds();
                prompt.localToGlobal(promptBounds);
                this.globalToLocal(promptBounds);
                if (destPt.getY() > sourcePt.getY()) {
                    fracX = 0.25;
                    fracY = 0.75;
                } else {
                    fracX = 0.75;
                    fracY = 0.25;
                }
                sourcePt = new Point2D.Double(((RectangularShape)promptBounds).getX() + fracX * ((RectangularShape)promptBounds).getWidth(), ((RectangularShape)promptBounds).getY() + fracY * ((RectangularShape)promptBounds).getHeight());
            }
            if (this.dest instanceof VoiceControl) {
                prompt = ((VoiceControl)((Object)this.dest)).getPrompt();
                promptBounds = prompt.getBounds();
                prompt.localToGlobal(promptBounds);
                this.globalToLocal(promptBounds);
                if (destPt.getY() > origSourcePt.getY()) {
                    fracX = 0.25;
                    fracY = 0.75;
                } else {
                    fracX = 0.75;
                    fracY = 0.25;
                }
                destPt = new Point2D.Double(((RectangularShape)promptBounds).getX() + fracX * ((RectangularShape)promptBounds).getWidth(), ((RectangularShape)promptBounds).getY() + fracY * ((RectangularShape)promptBounds).getHeight());
            }
            if (this.source == null) {
                sourcePt = new Point2D.Double(destPt.getX() - dx, destPt.getY() - dy);
            }
            if (this.dest == null) {
                destPt = new Point2D.Double(sourcePt.getX() + dx, sourcePt.getY() + dy);
            }
        }
        this.updateArrow(new Line2D.Double(sourcePt, destPt));
    }

    private void updateArrowFromModel() {
        this.updateArrow(((Control)this.getModel()).getVoiceResponseLine(this.condition));
    }

    public void updateArrow(Line2D newLine) {
        if (newLine == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.setPathTo(newLine);
            Point2D startPoint = newLine.getP1();
            if (this.source != null) {
                Rectangle2D sourceBounds = this.source.getSourceBounds();
                this.source.localToGlobal(sourceBounds);
                this.globalToLocal(sourceBounds);
                List intersectPts = GeomLib.calcIntersectPoints(newLine, sourceBounds);
                if (!intersectPts.isEmpty()) {
                    startPoint = (Point2D)intersectPts.get(0);
                }
            }
            Point2D endPoint = newLine.getP2();
            if (this.dest != null) {
                Rectangle2D destBounds = this.dest.getDestBounds();
                this.dest.localToGlobal(destBounds);
                this.globalToLocal(destBounds);
                List intersectPts = GeomLib.calcIntersectPoints(newLine, destBounds);
                if (!intersectPts.isEmpty()) {
                    endPoint = (Point2D)intersectPts.get(0);
                }
            }
            this.startHotSpot.setOffset(startPoint.getX() - 10.0, startPoint.getY() - 10.0);
            this.endHotSpot.setOffset(endPoint.getX() - 10.0, endPoint.getY() - 10.0);
            this.arrow.setPathTo(new Line2D.Double(startPoint, endPoint));
        }
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        Paint startFillPaint = this.source == null ? Color.WHITE : this.arrow.getStrokePaint();
        Paint startBorderPaint = this.arrow.getStrokePaint();
        Paint endFillPaint = this.dest == null ? Color.WHITE : this.arrow.getStrokePaint();
        Paint endBorderPaint = this.arrow.getStrokePaint();
        DamaskAppUtils.drawArrowheads(this.arrow, paintContext, startFillPaint, startBorderPaint, endFillPaint, endBorderPaint);
    }

    public HotSpot getStartHotSpot() {
        return this.startHotSpot;
    }

    public HotSpot getEndHotSpot() {
        return this.endHotSpot;
    }

    protected void updateSourceFromModel() {
        Control control = (Control)this.getModel();
        VoiceLayer layer = (VoiceLayer)this.getLayer();
        if (layer == null) {
            return;
        }
        VoiceControl voiceControl = (VoiceControl)layer.getView(control.getVoiceResponseSource());
        this.setSource((ResponseSource)((Object)voiceControl));
    }

    public void updateDestFromModel() {
        Control control = (Control)this.getModel();
        VoiceLayer layer = (VoiceLayer)this.getLayer();
        if (layer == null) {
            return;
        }
        InteractionElementView destView = layer.getView(control.getVoiceResponseDest(this.condition));
        this.setDest((ResponseDest)((Object)destView));
    }

    protected void deviceTypeLayerChanged() {
        DamaskLayer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        Control control = (Control)this.getModel();
        DeviceType controlDeviceType = control.getDeviceType();
        if (controlDeviceType == layer.getDeviceTypeForNewElement()) {
            DamaskAppUtils.setInternalColorAlpha(this, 255);
        } else {
            DamaskAppUtils.setInternalColorAlpha(this, 100);
        }
        Control beforeControl = control.getPageRegion(this.getDeviceType()).getPreviousControl(control);
        if (beforeControl instanceof SelectOne || beforeControl instanceof SelectMany || beforeControl instanceof TextInput) {
            DeviceType beforeControlDeviceType = beforeControl.getDeviceType();
            if (beforeControlDeviceType == layer.getDeviceTypeForNewElement()) {
                DamaskAppUtils.setInternalColorAlpha(this.textGroup, 255);
            } else {
                DamaskAppUtils.setInternalColorAlpha(this.textGroup, 100);
            }
        }
        this.repaint();
    }

    private class ElementHandler
    implements InteractionElementListener {
        ElementHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Response.this.getDeviceType()) {
                Response.this.updateArrowFromModel();
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class ControlVoiceHandler
    implements ControlVoiceListener {
        ControlVoiceHandler() {
        }

        public void responseSourceChanged(ControlVoiceEvent e) {
            Response.this.updateSourceFromModel();
        }

        public void responseDestChanged(ControlVoiceEvent e) {
            if (e.getCondition() == Response.this.condition) {
                Response.this.updateDestFromModel();
            }
        }

        public void responseLineChanged(ControlVoiceEvent e) {
            if (e.getCondition() == Response.this.condition) {
                Response.this.updateArrowFromModel();
            }
        }

        public void responseTextChanged(ControlVoiceEvent e) {
            Response.this.updateTextString();
        }

        public void promptTextChanged(ControlVoiceEvent e) {
        }

        public void promptBoundsChanged(ControlVoiceEvent e) {
        }
    }

    private class EndpointHandler
    implements PropertyChangeListener {
        EndpointHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Response.this.updateArrowFromView();
        }
    }

    public static class TextGroup
    extends PPath {
        public Response getResponse() {
            return (Response)this.getParent();
        }
    }

    public static class HotSpot
    extends PPath {
        public HotSpot() {
        }

        public HotSpot(Shape aShape) {
            super(aShape);
        }

        public HotSpot(Shape aShape, Stroke aStroke) {
            super(aShape, aStroke);
        }

        public Response getResponse() {
            return (Response)this.getParent();
        }
    }
}

