/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.SetVoicePromptTextCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.event.ControlVoiceEvent;
import edu.berkeley.guir.damask.event.ControlVoiceListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.event.StyledTextEventHandler;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.component.SyncButton;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.component.VoicePart;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class Prompt
extends VoicePart {
    private static final int CORNER_RADIUS = 10;
    private static final Color BORDER_COLOR = new Color(186, 125, 0);
    private static final Color INTERIOR_COLOR = new Color(255, 239, 165);
    private static final Color SYNC_ON_COLOR = BORDER_COLOR;
    private static final Color SYNC_OFF_COLOR = new Color(223, 214, 175);
    private static final int INSET = 6;
    private final ControlVoiceHandler voiceHandler = new ControlVoiceHandler();
    private final PText text = new PText();
    private SyncButton syncButton;
    private final ElementHandler elementHandler = new ElementHandler();

    public Prompt(VoiceControl voiceControl) {
        super(voiceControl.getModel(), false);
        this.init();
    }

    private void init() {
        this.setPaint(INTERIOR_COLOR);
        this.setStrokePaint(BORDER_COLOR);
        this.setResizable(false);
        DamaskAppUtils.setFontSize(this.text, DeviceType.VOICE.getDefaultFontSize());
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Control model = (Control)this.getModel();
        model.addControlVoiceListener(this.voiceHandler);
        Rectangle2D modelPromptBounds = model.getVoicePromptBounds();
        this.text.setBounds(modelPromptBounds);
        this.setPathTo(new RoundRectangle2D.Double(modelPromptBounds.getX() - 6.0 - 10.0, modelPromptBounds.getY() - 6.0, modelPromptBounds.getWidth() + 10.0 + 12.0, modelPromptBounds.getHeight() + 12.0, 10.0, 10.0));
        this.setTransform(new AffineTransform());
        this.text.setPickable(false);
        this.setTextString(model.getVoicePromptText());
        this.addChild(this.text);
        model.addInteractionElementListener(this.elementHandler);
        ArrayList<Content> contentModel = new ArrayList<Content>();
        contentModel.add(this.getContentModel());
        this.syncButton = new SyncButton(new Rectangle2D.Double(this.getBounds().getX(), this.getBounds().getY(), 10.0, (float)this.getHeight()), contentModel, SYNC_ON_COLOR, SYNC_OFF_COLOR);
        if (model.isForAllDeviceTypes()) {
            this.addChild(this.syncButton);
        }
    }

    public void dispose() {
        super.dispose();
        this.syncButton.dispose();
        ((Control)this.getModel()).removeControlVoiceListener(this.voiceHandler);
    }

    protected PText getText() {
        return this.text;
    }

    public String getTextString() {
        return this.text.getText();
    }

    private Content getContentModel() {
        Control control = (Control)this.getModel();
        if (control instanceof Content) {
            return (Content)control;
        }
        return ((SelectMany.Item)control).getContent();
    }

    protected void setTextString(String newString) {
        this.text.setText(newString);
    }

    protected void deviceTypeLayerChanged() {
        DeviceType componentDeviceType = ((Component)this.getModel()).getDeviceType();
        DamaskLayer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        if (componentDeviceType == layer.getDeviceTypeForNewElement()) {
            DamaskAppUtils.setInternalColorAlpha(this, 255);
        } else {
            DamaskAppUtils.setInternalColorAlpha(this, 100);
        }
        this.repaint();
    }

    private class ElementHandler
    implements InteractionElementListener {
        ElementHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Prompt.this.getDeviceType()) {
                Rectangle2D modelPromptBounds = ((Control)e.getElement()).getVoicePromptBounds();
                Prompt.this.setPathTo(new RoundRectangle2D.Double(modelPromptBounds.getX() - 10.0 - 6.0, modelPromptBounds.getY() - 6.0, modelPromptBounds.getWidth() + 10.0 + 12.0, modelPromptBounds.getHeight() + 12.0, 10.0, 10.0));
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class ControlVoiceHandler
    implements ControlVoiceListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.component.Prompt$ControlVoiceHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ControlVoiceHandler() {
        }

        public void promptTextChanged(ControlVoiceEvent e) {
            if (!$assertionsDisabled && e.getSource() != Prompt.this.getModel()) {
                throw new AssertionError();
            }
            Prompt.this.setTextString(((Control)Prompt.this.getModel()).getVoicePromptText());
        }

        public void promptBoundsChanged(ControlVoiceEvent e) {
        }

        public void responseSourceChanged(ControlVoiceEvent e) {
        }

        public void responseDestChanged(ControlVoiceEvent e) {
        }

        public void responseLineChanged(ControlVoiceEvent e) {
        }

        public void responseTextChanged(ControlVoiceEvent e) {
        }
    }

    public static class TextHandler
    extends StyledTextEventHandler {
        private Prompt pickedPrompt;
        private final PStyledText styledText = this.createText();

        public TextHandler() {
            this.init();
        }

        public TextHandler(JTextComponent editor) {
            super(editor);
            this.init();
        }

        private void init() {
            DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
        }

        public void mousePressed(PInputEvent event) {
        }

        public void startEditing(PInputEvent event, Prompt prompt) {
            VoiceCanvas canvas = (VoiceCanvas)event.getComponent();
            canvas.setTextEditing(true);
            canvas.setActiveTextHandler(this);
            DamaskLayer layer = prompt.getLayer();
            this.pickedPrompt = prompt;
            DamaskAppUtils.setText(this.styledText, this.pickedPrompt.getTextString());
            DamaskAppUtils.setFontSize(this.styledText, this.pickedPrompt.getText().getFont().getSize());
            Insets pInsets = this.styledText.getInsets();
            layer.addChild(this.styledText);
            PBounds textGlobalBounds = this.pickedPrompt.getText().getFullBounds();
            this.pickedPrompt.getText().getParent().localToGlobal(textGlobalBounds);
            Point2D position = textGlobalBounds.getOrigin();
            this.styledText.setOffset(position.getX() - (double)pInsets.left, position.getY() - (double)pInsets.top);
            this.startEditing(event, this.styledText);
        }

        public void stopEditing() {
            if (this.canvas instanceof DamaskCanvas) {
                ((DamaskCanvas)this.canvas).setTextEditing(false);
            }
            if (this.editedText != null) {
                DamaskCanvas damaskCanvas = (DamaskCanvas)this.canvas;
                Document editedDoc = this.editedText.getDocument();
                editedDoc.removeDocumentListener(this.docListener);
                this.editedText.setEditing(false);
                this.editedText.syncWithDocument();
                this.editedText.removeFromParent();
                if (this.editedText.getDocument().getLength() != 0) {
                    try {
                        damaskCanvas.getDocument().getCommandQueue().doCommand(damaskCanvas, new SetVoicePromptTextCommand(this.pickedPrompt.getContentModel(), editedDoc.getText(0, editedDoc.getLength())));
                    }
                    catch (BadLocationException e) {
                        DamaskAppExceptionHandler.log(e);
                    }
                }
                this.editor.setVisible(false);
                this.canvas.repaint();
                this.editedText = null;
            }
        }

        protected JTextComponent createDefaultEditor() {
            JTextComponent tComp = super.createDefaultEditor();
            tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
            return tComp;
        }
    }
}

