/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class VoicePreview {
    private Page currentPage;
    private final Component parentComponent;
    private final String documentName;
    private final Map templateResponses = new HashMap();
    private final Map responses = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.VoicePreview");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VoicePreview(Component parentComponent, String documentName, Dialog startDialog) {
        this.parentComponent = parentComponent;
        this.documentName = documentName;
        this.currentPage = startDialog.getFirstPage(DeviceType.VOICE);
        InteractionGraph graph = startDialog.getInteractionGraph();
        Iterator i = graph.getTemplates(DeviceType.VOICE).iterator();
        while (i.hasNext()) {
            TemplateDialog templateDialog = (TemplateDialog)i.next();
            Iterator j = templateDialog.getPages(DeviceType.VOICE).iterator();
            while (j.hasNext()) {
                Page templatePage = (Page)j.next();
                Iterator k = templatePage.getRegion(Direction.CENTER).getControls().iterator();
                while (k.hasNext()) {
                    Control templateControl = (Control)k.next();
                    if (!(templateControl instanceof Trigger)) continue;
                    Trigger trigger = (Trigger)templateControl;
                    this.addTriggerDestsToJumpTable(trigger, this.templateResponses);
                }
            }
        }
    }

    public void go() {
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = this.displayCurrentPage();
        }
    }

    protected boolean displayCurrentPage() {
        ArrayList<JTextField> origDialogComponents = new ArrayList<JTextField>();
        JTextField textField = new JTextField();
        boolean hasAddedTextField = false;
        this.responses.clear();
        hasAddedTextField = this.fillDialogBoxFromPage(origDialogComponents, textField, hasAddedTextField);
        if (!hasAddedTextField && !this.templateResponses.isEmpty()) {
            origDialogComponents.add(textField);
            hasAddedTextField = true;
        }
        int dialogType = hasAddedTextField ? 2 : -1;
        ArrayList<String> dialogComponents = new ArrayList<String>(origDialogComponents);
        boolean validResult = false;
        while (!validResult) {
            int result = JOptionPane.showConfirmDialog(this.parentComponent, dialogComponents.toArray(), String.valueOf(this.documentName) + " [Run - " + this.currentPage.getDeviceType() + "] - Damask", dialogType, -1);
            if (result == -1 || dialogType == 2 && result == 2 || dialogType == -1 && result == 0) {
                return false;
            }
            String userResponse = textField.getText();
            if (userResponse.equals("")) {
                dialogComponents = new ArrayList(origDialogComponents);
                dialogComponents.add(0, "I'm sorry, I didn't hear you.");
                continue;
            }
            if (this.hasDestination(userResponse, this.responses)) {
                Page nextPage = this.getDestination(userResponse, this.responses);
                if (nextPage == null) {
                    nextPage = this.getDestination("*", this.responses);
                }
                if (nextPage == null) {
                    JOptionPane.showMessageDialog(this.parentComponent, "[No destination for your response, " + userResponse + "]");
                    return false;
                }
                this.currentPage = nextPage;
                validResult = true;
                continue;
            }
            dialogComponents = new ArrayList(origDialogComponents);
            dialogComponents.add(0, "I'm sorry, I didn't get that.");
        }
        return true;
    }

    private boolean fillDialogBoxFromPage(List dialogComponents, JTextField textField, boolean hasAddedTextField) {
        Page origCurrentPage = this.currentPage;
        Iterator i = this.currentPage.getRegion(Direction.CENTER).getControls().iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            if (control instanceof Content) {
                dialogComponents.add(new JLabel(((Content)control).getVoicePromptText()));
            } else if (control instanceof SelectMany) {
                SelectMany.Item item = (SelectMany.Item)((SelectMany)control).getItems().get(0);
                dialogComponents.add(new JLabel(item.getVoicePromptText()));
            }
            if (!(control instanceof Content || control instanceof Trigger && ((Trigger)control).getVoiceResponseTextList().size() == 1 && ((Trigger)control).getVoiceResponseTextList().get(0).equals("") || hasAddedTextField)) {
                dialogComponents.add(textField);
                hasAddedTextField = true;
            }
            if (control instanceof Select) {
                Control nextControl;
                Control controlToOutput;
                ArrayList<String> itemTexts = new ArrayList<String>();
                if (control instanceof SelectOne) {
                    controlToOutput = control;
                } else {
                    if (!$assertionsDisabled && ((SelectMany)control).getItems().size() != 1) {
                        throw new AssertionError();
                    }
                    controlToOutput = (SelectMany.Item)((SelectMany)control).getItems().get(0);
                }
                Iterator k = controlToOutput.getVoiceResponseTextList().iterator();
                while (k.hasNext()) {
                    String text = (String)k.next();
                    if (text.contains(" ")) {
                        itemTexts.add("(" + text.toLowerCase() + ")");
                        continue;
                    }
                    itemTexts.add(text.toLowerCase());
                }
                if (!i.hasNext() || !((nextControl = (Control)i.next()) instanceof Trigger)) continue;
                this.addTriggerDestsToJumpTable((Trigger)nextControl, this.responses);
                continue;
            }
            if (control instanceof TextInput) {
                Control nextControl;
                if (!i.hasNext() || !((nextControl = (Control)i.next()) instanceof Trigger)) continue;
                this.addTriggerDestsToJumpTable((Trigger)nextControl, this.responses);
                continue;
            }
            if (!(control instanceof Trigger)) continue;
            Trigger trigger = (Trigger)control;
            if (trigger.getVoiceResponseTextList().size() == 1 && trigger.getVoiceResponseTextList().get(0).equals("")) {
                Page destPage;
                dialogComponents.add(new JLabel("------"));
                NavConnection connection = trigger.getOutConnection(DeviceType.VOICE, new InvokeEvent(trigger), 0);
                if (connection == null || (destPage = connection.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE)) == null) continue;
                this.currentPage = destPage;
                break;
            }
            this.addTriggerDestsToJumpTable(trigger, this.responses);
        }
        if (origCurrentPage != this.currentPage) {
            hasAddedTextField = this.fillDialogBoxFromPage(dialogComponents, textField, hasAddedTextField);
        }
        return hasAddedTextField;
    }

    private boolean hasDestination(String userResponse, Map localResponses) {
        return localResponses.containsKey(userResponse.toLowerCase()) || this.templateResponses.containsKey(userResponse.toLowerCase()) || localResponses.containsKey("*") || this.templateResponses.containsKey("*");
    }

    private Page getDestination(String userResponse, Map localResponses) {
        Page nextPage = (Page)localResponses.get(userResponse.toLowerCase());
        if (nextPage == null) {
            nextPage = (Page)localResponses.get("*");
        }
        if (nextPage == null) {
            nextPage = (Page)this.templateResponses.get(userResponse.toLowerCase());
        }
        if (nextPage == null) {
            nextPage = (Page)this.templateResponses.get("*");
        }
        return nextPage;
    }

    private void addTriggerDestsToJumpTable(Trigger trigger, Map jumpTable) {
        NavConnection connection = trigger.getOutConnection(DeviceType.VOICE, new InvokeEvent(trigger), 0);
        Page destPage = connection == null ? null : connection.getDest(DeviceType.VOICE).getPage(DeviceType.VOICE);
        Iterator i = trigger.getVoiceResponseTextList().iterator();
        while (i.hasNext()) {
            String triggerText = (String)i.next();
            jumpTable.put(triggerText.toLowerCase(), destPage);
        }
    }
}

