/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.pattern.PatternInstanceView;
import edu.berkeley.guir.damask.view.voice.ResponseDest;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.component.VoiceComponent;
import edu.berkeley.guir.damask.view.voice.component.VoiceTrigger;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VoiceLayer
extends DamaskLayer {
    public static final int OTHER_LAYER_ALPHA = 100;
    private List forms;
    private List homeForms;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.VoiceLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VoiceLayer(DamaskDocument doc, DeviceType deviceType) {
        this(doc, deviceType, 1.0);
    }

    public VoiceLayer(DamaskDocument doc, DeviceType deviceType, double pageTitleScale) {
        super(doc, deviceType, pageTitleScale);
        this.addPropertyChangeListener("cameras", new CamerasHandler());
    }

    protected void initBeforeAddingViews() {
        this.forms = new ArrayList();
        this.homeForms = new ArrayList();
    }

    private List getFormsIncludingTemplates() {
        ArrayList allForms = new ArrayList();
        allForms.addAll(this.forms);
        allForms.addAll(this.getTemplatePane().getViewsOfTemplateDialogs());
        return Collections.unmodifiableList(allForms);
    }

    protected void addViewForElement(InteractionElement element) {
        DeviceType deviceType = this.getDeviceType();
        TemplatePane templatePane = this.getTemplatePane();
        if (element instanceof Dialog) {
            Dialog d = (Dialog)element;
            if (!(d instanceof TemplateDialog) && d.isEnabled(deviceType)) {
                Form form = new Form(d);
                this.views.put(d, form);
                this.addChild(this.indexOfChild(templatePane), form);
                this.forms.add(form);
                form.setContentsSelectable(true);
                this.trackAddition(form);
            }
        } else if (element instanceof Connection) {
            VoiceTrigger voiceTrigger;
            ConnectionSource source;
            Connection c = (Connection)element;
            if (c.isVisibleToDeviceType(deviceType) && (source = c.getConnectionSource(deviceType)) instanceof Trigger && (voiceTrigger = (VoiceTrigger)this.getView(source)) != null) {
                voiceTrigger.getResponse(voiceTrigger.getForm().getDesignTimeCondition()).setDest((ResponseDest)((Object)this.getView(c.getConnectionDest(deviceType))));
            }
        } else if (element instanceof PatternInstance) {
            PatternInstance pi = (PatternInstance)element;
            if (pi.isVisibleToDeviceType(deviceType)) {
                PatternInstanceView piView = new PatternInstanceView(pi);
                this.addChild(this.indexOfChild(templatePane), piView);
                this.views.put(pi, piView);
                this.trackAddition(piView);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
        }
    }

    protected void removeViewForElement(InteractionElement element) {
        DeviceType deviceType = this.getDeviceType();
        if (element instanceof Dialog) {
            Dialog d = (Dialog)element;
            if (!(d instanceof TemplateDialog) && d.isEnabled(deviceType)) {
                Form form = (Form)this.views.get(d);
                form.setContentsSelectable(false);
                this.removeChild(form);
                this.forms.remove(form);
                Iterator i = this.getCamerasReference().iterator();
                while (i.hasNext()) {
                    VoiceCanvas canvas;
                    Form oldSelectedForm;
                    PCamera camera = (PCamera)i.next();
                    PComponent component = camera.getComponent();
                    if (!(component instanceof VoiceCanvas) || (oldSelectedForm = (canvas = (VoiceCanvas)component).getSelectedForm()) != form) continue;
                    canvas.attachHandles(null, camera);
                }
                form.dispose();
            }
        } else if (!(element instanceof Connection)) {
            if (element instanceof PatternInstance) {
                PatternInstance pi = (PatternInstance)element;
                if (pi.isVisibleToDeviceType(deviceType)) {
                    PatternInstanceView piView = (PatternInstanceView)this.views.get(pi);
                    piView.dispose();
                    this.removeChild(piView);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
            }
        }
    }

    public void adjustComponentByDeviceTypeLayer(VoiceComponent component) {
    }

    public void updateHomePage() {
        InteractionGraph graph = this.getDocument().getGraph();
        DeviceType deviceType = this.getDeviceType();
        Iterator i = this.homeForms.iterator();
        while (i.hasNext()) {
            PNode homeForm = (PNode)i.next();
            if (!(homeForm instanceof Form)) continue;
            ((Form)homeForm).setHome(false);
        }
        Page homePage = graph.getHomePage(deviceType);
        Dialog homeDialog = homePage == null ? null : homePage.getDialog();
        this.homeForms.clear();
        this.homeForms = this.getViews(homeDialog);
        Iterator i2 = this.homeForms.iterator();
        while (i2.hasNext()) {
            PNode homeForm = (PNode)i2.next();
            if (!(homeForm instanceof Form)) continue;
            ((Form)homeForm).setHome(true);
        }
    }

    protected void internalSetDeviceTypeLayer(DamaskLayer.DeviceTypeLayer deviceTypeLayer) {
        PNode node;
        super.internalSetDeviceTypeLayer(deviceTypeLayer);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            node = (PNode)i.next();
            if (!(node instanceof Form)) continue;
            ((Form)node).deviceTypeLayerChanged();
        }
        i = this.getTemplatePane().getViewsOfTemplateDialogs().iterator();
        while (i.hasNext()) {
            node = (InteractionElementView)i.next();
            if (!(node instanceof Form)) continue;
            ((Form)node).deviceTypeLayerChanged();
        }
    }

    private class CamerasHandler
    implements PropertyChangeListener {
        CamerasHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Iterator i = VoiceLayer.this.getFormsIncludingTemplates().iterator();
            while (i.hasNext()) {
                Form form = (Form)i.next();
                form.setContentsSelectable(true);
            }
        }
    }
}

