/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.voice;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.RemoveDialogCommand;
import edu.berkeley.guir.damask.command.SetHomePageCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppMode;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.DamaskToolbar;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import edu.berkeley.guir.damask.view.event.EraserEventHandler;
import edu.berkeley.guir.damask.view.event.StyledTextEventHandler;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.nodes.NonResizableHandle;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.voice.VoiceMode;
import edu.berkeley.guir.damask.view.voice.VoicePreview;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceControl;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.berkeley.guir.damask.view.voice.event.DragFromPromptHandler;
import edu.berkeley.guir.damask.view.voice.event.DragResponseHotSpotHandler;
import edu.berkeley.guir.damask.view.voice.event.DragResponseTextHandler;
import edu.berkeley.guir.damask.view.voice.event.InsertFormHandler;
import edu.berkeley.guir.damask.view.voice.event.InsertPromptHandler;
import edu.berkeley.guir.damask.view.voice.event.ResponseTextHandler;
import edu.berkeley.guir.damask.view.voice.event.VoiceTextHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;

public class VoiceCanvas
extends DamaskCanvas {
    private static final Logger logger;
    public static final String DRAW_MODE = "Draw";
    public static final String ERASER_MODE = "Eraser";
    private final VoiceTextHandler formTitleHandler = new VoiceTextHandler();
    private PInputEventListener appModeHandler = null;
    private StyledTextEventHandler activeTextHandler = null;
    private final Action cutFormAction = new CutFormAction();
    private final Action copyFormAction = new CopyFormAction();
    private final Action pasteFormAction = new PasteFormAction();
    private final Action deleteFormAction = new DeleteFormAction();
    private final Action setHomeFormAction = new SetHomeFormAction();
    private final Action runFromHomeAction = new RunFromHomeAction();
    private final Action runFromSelectedPageAction = new RunFromSelectedPageAction();
    private final JPopupMenu formPopupMenu = new JPopupMenu();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public VoiceCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType) {
        this(group, deviceType, 1.0);
    }

    public VoiceCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType, double pageTitleScale) {
        super(group, deviceType, pageTitleScale);
        this.addCanvasListener(new SelectionChangeHandler());
        Cursor eraserCursor = DamaskAppUtils.createCursor("eraser.gif", new Point(0, 0), ERASER_MODE);
        EraserEventHandler eraserHandler = new EraserEventHandler();
        this.addMode(new VoiceMode(ERASER_MODE, null, null, eraserHandler, eraserHandler, eraserHandler, null, null, eraserCursor, eraserCursor, eraserCursor));
        this.addMode(new VoiceMode(DRAW_MODE, new InsertFormHandler(), new InsertPromptHandler(), new DragFromPromptHandler(), new ResponseTextHandler(), new DragResponseHotSpotHandler(), DamaskAppUtils.createCursor("page.gif", new Point(0, 0), "Page"), Cursor.getPredefinedCursor(2), Cursor.getPredefinedCursor(2), Cursor.getPredefinedCursor(2), Cursor.getPredefinedCursor(13)));
        this.runFromHomeAction.setEnabled(!this.getDocument().getGraph().getDialogs(this.getDeviceType()).isEmpty());
        this.runFromSelectedPageAction.setEnabled(false);
        this.formPopupMenu.add(new JMenuItem(this.cutFormAction));
        this.formPopupMenu.add(new JMenuItem(this.copyFormAction));
        this.formPopupMenu.add(new JMenuItem(this.getPasteAction()));
        this.formPopupMenu.add(new JMenuItem(this.deleteFormAction));
        this.formPopupMenu.add(new JSeparator());
        this.formPopupMenu.add(new JMenuItem(this.setHomeFormAction));
        this.formPopupMenu.add(new JSeparator());
        JMenuItem runFromThisPageItem = new JMenuItem(this.getRunFromSelectedPageAction());
        runFromThisPageItem.setText("Run From This Form");
        runFromThisPageItem.setMnemonic(82);
        this.formPopupMenu.add(runFromThisPageItem);
    }

    public DamaskAppMode getSelectionAppMode() {
        return new VoiceMode("Select/Move", this.getSelectionEventHandler(), this.getSelectionEventHandler(), this.getSelectionEventHandler(), new DragResponseTextHandler(), new DragResponseHotSpotHandler(), null, null, Cursor.getPredefinedCursor(13), Cursor.getPredefinedCursor(13), Cursor.getPredefinedCursor(13));
    }

    protected void setModeEventHandlerEnabled(boolean flag) {
        PNode insideNode = this.getInsideNode();
        DamaskAppMode appMode = this.getMode();
        if (!(appMode instanceof VoiceMode)) {
            super.setModeEventHandlerEnabled(flag);
            return;
        }
        VoiceMode voiceMode = (VoiceMode)appMode;
        if (flag) {
            Cursor cursorToUse;
            if (insideNode instanceof Form.Contents || insideNode instanceof DamaskWindowTitle || insideNode instanceof VoiceControl) {
                this.appModeHandler = voiceMode.getFormHandler();
                cursorToUse = voiceMode.getFormCursor();
            } else if (insideNode instanceof Prompt) {
                this.appModeHandler = voiceMode.getPromptHandler();
                cursorToUse = voiceMode.getPromptCursor();
            } else if (insideNode instanceof Response.TextGroup) {
                this.appModeHandler = voiceMode.getResponseTextHandler();
                cursorToUse = voiceMode.getResponseTextCursor();
            } else if (insideNode instanceof Response.HotSpot) {
                this.appModeHandler = voiceMode.getResponseHotSpotHandler();
                cursorToUse = voiceMode.getResponseHotSpotCursor();
            } else if (insideNode instanceof Label) {
                Object contents;
                Label componentView = (Label)insideNode;
                cursorToUse = null;
                if (appMode.getName() == DRAW_MODE && componentView.getParent() instanceof DamaskWindowTitle && ((Label)(contents = componentView.getEditableContents())).getDisplayMode() == Content.TEXT) {
                    this.appModeHandler = this.formTitleHandler;
                    cursorToUse = Cursor.getPredefinedCursor(2);
                }
            } else if (insideNode instanceof Response) {
                cursorToUse = voiceMode.getFormCursor();
            } else if (insideNode == null) {
                this.appModeHandler = voiceMode.getDefaultHandler();
                if (insideNode instanceof PBoundsHandle && !(insideNode instanceof NonResizableHandle)) {
                    PBoundsHandle handle = (PBoundsHandle)insideNode;
                    cursorToUse = handle.getCursorFor(((PBoundsLocator)handle.getLocator()).getSide());
                } else {
                    cursorToUse = appMode.getDefaultCursor();
                }
            } else {
                this.appModeHandler = null;
                cursorToUse = null;
            }
            if (this.appModeHandler != null) {
                this.addInputEventListener(this.appModeHandler);
            }
            this.setCursor(cursorToUse);
        } else {
            if (this.appModeHandler != null) {
                this.removeInputEventListener(this.appModeHandler);
            }
            this.setCursor(null);
        }
    }

    public void setActiveTextHandler(StyledTextEventHandler handler) {
        this.stopTextEditing();
        this.activeTextHandler = handler;
    }

    public void stopTextEditing() {
        if (this.activeTextHandler != null) {
            this.activeTextHandler.stopEditing();
            this.activeTextHandler = null;
        }
    }

    public PageRegion getPasteTargetPageRegion() {
        Form form = this.getSelectedForm();
        if (form == null) {
            return null;
        }
        Page lastPage = ((Dialog)form.getModel()).getLastPage(this.getDeviceType());
        Page pageForPastedContent = lastPage.getRegion(Direction.CENTER).getControls().isEmpty() ? lastPage : lastPage.split(Collections.EMPTY_LIST);
        return pageForPastedContent.getRegion(Direction.CENTER);
    }

    public Form getSelectedForm() {
        return (Form)this.getCurrentWindow();
    }

    public Page getSelectedPage() {
        Form form = this.getSelectedForm();
        if (form == null) {
            return null;
        }
        return ((Dialog)form.getModel()).getFirstPage(this.getDeviceType());
    }

    protected Page getDropTarget(Point2D layerDropPt) {
        return null;
    }

    public JPopupMenu getPopupMenu(PNode pickedNode, boolean isPickedNodeSelectable) {
        if (!isPickedNodeSelectable) {
            if (pickedNode instanceof Form.Contents || pickedNode instanceof DamaskWindowTitle) {
                return this.formPopupMenu;
            }
            return super.getPopupMenu(pickedNode, isPickedNodeSelectable);
        }
        return super.getPopupMenu(pickedNode, isPickedNodeSelectable);
    }

    public Action getCopyPageAction() {
        return this.copyFormAction;
    }

    public Action getCutPageAction() {
        return this.cutFormAction;
    }

    public Action getDeletePageAction() {
        return this.deleteFormAction;
    }

    public Action getPastePageAction() {
        return this.pasteFormAction;
    }

    public Action getSetHomePageAction() {
        return this.setHomeFormAction;
    }

    public Action getRunFromHomeAction() {
        return this.runFromHomeAction;
    }

    public Action getRunFromSelectedPageAction() {
        return this.runFromSelectedPageAction;
    }

    private class CutFormAction
    extends AbstractAction {
        public CutFormAction() {
            super("Cut Form");
            this.putValue("ShortDescription", "Cuts the selected form into the clipboard");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent e) {
            VoiceCanvas.this.getCopyPageAction().actionPerformed(e);
            VoiceCanvas.this.getDeletePageAction().actionPerformed(e);
        }
    }

    private class CopyFormAction
    extends AbstractAction {
        public CopyFormAction() {
            super("Copy Form");
            this.putValue("ShortDescription", "Copies the selected form into the clipboard");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("Begin copy form");
            ArrayList<Form> selectedFormList = new ArrayList<Form>();
            selectedFormList.add(VoiceCanvas.this.getSelectedForm());
            VoiceCanvas.this.setObjectsToCopy(selectedFormList);
            TransferHandler handler = VoiceCanvas.this.getTransferHandler();
            handler.exportToClipboard(VoiceCanvas.this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            VoiceCanvas.this.getPasteAction().setEnabled(true);
            logger.info("End copy form");
        }
    }

    private class PasteFormAction
    extends AbstractAction {
        public PasteFormAction() {
            super("Paste Form");
            this.putValue("ShortDescription", "Pastes the contents of the clipboard");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            TransferHandler handler;
            logger.info("Begin paste form");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(this);
            if (clipData != null && (handler = VoiceCanvas.this.getTransferHandler()).canImport(VoiceCanvas.this, clipData.getTransferDataFlavors())) {
                handler.importData(VoiceCanvas.this, clipData);
            }
            logger.info("End paste form");
        }
    }

    private class DeleteFormAction
    extends AbstractAction {
        public DeleteFormAction() {
            super("Delete Form");
            this.putValue("ShortDescription", "Deletes the selected form");
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            VoiceCanvas.this.getDocument().getCommandQueue().doCommand(VoiceCanvas.this, new RemoveDialogCommand((Dialog)VoiceCanvas.this.getSelectedForm().getModel()));
        }
    }

    private class SetHomeFormAction
    extends AbstractAction {
        public SetHomeFormAction() {
            super("Set as Home Form");
            this.putValue("ShortDescription", "Sets the selected form as the home form");
            this.putValue("MnemonicKey", new Integer(72));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VoiceCanvas.this.getLayer();
            VoiceCanvas.this.getDocument().getCommandQueue().doCommand(VoiceCanvas.this, new SetHomePageCommand(layer.getDocument().getGraph(), layer.getDeviceType(), VoiceCanvas.this.getSelectedPage()));
            this.setEnabled(false);
        }
    }

    private class RunFromHomeAction
    extends AbstractAction {
        public RunFromHomeAction() {
            super("Run from Home Form");
            this.putValue("ShortDescription", "Runs this document");
            this.putValue("MnemonicKey", new Integer(72));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("run_from_home.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("run_from_home.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VoiceCanvas.this.getLayer();
            DamaskDocument document = layer.getDocument();
            DeviceType deviceType = layer.getDeviceType();
            Page homePage = document.getGraph().getHomePage(deviceType);
            VoicePreview voicePreview = new VoicePreview(VoiceCanvas.this, document.getDisplayedFileName(), homePage.getDialog());
            voicePreview.go();
        }
    }

    private class RunFromSelectedPageAction
    extends AbstractAction {
        public RunFromSelectedPageAction() {
            super("Run from Selected Form");
            this.putValue("ShortDescription", "Runs this document from the selected form");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("run.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("run.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VoiceCanvas.this.getLayer();
            DamaskDocument document = layer.getDocument();
            Page selectedPage = VoiceCanvas.this.getSelectedPage();
            VoicePreview voicePreview = new VoicePreview(VoiceCanvas.this, document.getDisplayedFileName(), selectedPage.getDialog());
            voicePreview.go();
        }
    }

    private class SelectionChangeHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.voice.VoiceCanvas$SelectionChangeHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        SelectionChangeHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
        }

        public void selectedPageChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != VoiceCanvas.this) {
                throw new AssertionError((Object)("should be receiving events from " + VoiceCanvas.this + ", not " + e.getCanvas()));
            }
            boolean hasSelectedPage = VoiceCanvas.this.getSelectedForm() != null;
            VoiceCanvas.this.getRunFromSelectedPageAction().setEnabled(hasSelectedPage);
        }
    }
}

