/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.event;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.EditContentCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.SetContentDisplayModeCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.appdialogs.EditListDialog;
import edu.berkeley.guir.damask.view.event.StyledTextEventHandler;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextHandler
extends StyledTextEventHandler {
    private Label label = null;
    private final Color LABEL_EDIT_COLOR = Color.LIGHT_GRAY;
    private Content.DisplayMode labelOrigDispMode = null;
    private PageRegionView regionView = null;
    private final PStyledText styledText = this.createText();

    public TextHandler() {
        this.init();
    }

    public TextHandler(JTextComponent editor) {
        super(editor);
        this.init();
    }

    private void init() {
        DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
    }

    public void mousePressed(PInputEvent event) {
        PNode pickedNode = event.getPickedNode();
        if (this.label != null || this.editedText != null) {
            this.stopEditing();
        }
        DamaskAppUtils.setText(this.styledText, "");
        DamaskAppUtils.setFont(this.styledText, DamaskAppUtils.getDefaultFont());
        if (pickedNode instanceof PageRegionView) {
            this.regionView = (PageRegionView)pickedNode;
            Insets pInsets = this.styledText.getInsets();
            pickedNode.addChild(this.styledText);
            Point2D position = event.getPosition();
            pickedNode.globalToLocal(position);
            this.styledText.setOffset(position.getX() - (double)pInsets.left, position.getY() - (double)pInsets.top);
            this.startEditing(event, this.styledText);
        } else if (pickedNode instanceof ComponentView) {
            ComponentView componentView = (ComponentView)pickedNode;
            Object contents = componentView.getEditableContents();
            if (contents instanceof Label) {
                this.label = (Label)contents;
                DamaskLayer layer = this.label.getLayer();
                if (((Content)this.label.getModel()).getDeviceType() != layer.getDeviceTypeForNewElement() && !DamaskAppUtils.askToChangeLayers(layer, (JComponent)((Object)event.getComponent()))) {
                    this.label = null;
                    return;
                }
                this.labelOrigDispMode = this.label.getDisplayMode();
                this.label.setLabelColor(this.LABEL_EDIT_COLOR);
                Content content = (Content)this.label.getModel();
                DamaskAppUtils.setText(this.styledText, this.label.getText().getText());
                DamaskAppUtils.setFontSize(this.styledText, content.getTextSize(this.label.getDeviceType()));
                Insets pInsets = this.styledText.getInsets();
                this.label.setVisible(false);
                layer.addChild(this.styledText);
                PBounds labelGlobalBounds = this.label.getBounds();
                this.label.localToGlobal(labelGlobalBounds);
                Point2D position = labelGlobalBounds.getOrigin();
                this.styledText.setOffset(position.getX() - (double)pInsets.left, position.getY() - (double)pInsets.top);
                this.startEditing(event, this.styledText);
            } else if (contents instanceof List) {
                this.editContentList(event, (ControlView)componentView, (List)contents);
            }
        }
    }

    private void editContentList(PInputEvent event, ControlView controlView, List contentList) {
        Select select = (Select)controlView.getModel();
        String[] items = new String[contentList.size()];
        int i = 0;
        int n = items.length;
        while (i < n) {
            items[i] = ((Content)((Label)contentList.get(i)).getModel()).getText();
            ++i;
        }
        DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
        Window parentWin = (Window)SwingUtilities.getRoot(canvas);
        Point2D pt = event.getCanvasPosition();
        int x = (int)pt.getX() + canvas.getX();
        int y = (int)pt.getY() + canvas.getY();
        EditListDialog dlg = parentWin instanceof Frame ? new EditListDialog((Frame)parentWin, items, x, y) : new EditListDialog(items);
        dlg.setVisible(true);
        if (dlg.wasOKPressed()) {
            String[] newItems = dlg.getValues();
            ModifyGraphMacroCommand command = new ModifyGraphMacroCommand();
            DamaskAppUtils.addCommandsToModifySelectItemsToMacroCommand(select, canvas, newItems, command, false);
            canvas.getDocument().getCommandQueue().doCommand(canvas, command);
        }
    }

    public void stopEditing() {
        if (this.canvas instanceof DamaskCanvas) {
            ((DamaskCanvas)this.canvas).setTextEditing(false);
        }
        if (this.editedText != null) {
            DamaskCanvas damaskCanvas = (DamaskCanvas)this.canvas;
            Document editedDoc = this.editedText.getDocument();
            editedDoc.removeDocumentListener(this.docListener);
            this.editedText.setEditing(false);
            this.editedText.syncWithDocument();
            this.editedText.removeFromParent();
            if (this.editedText.getDocument().getLength() == 0) {
                if (this.label != null) {
                    this.label.setDisplayMode(this.labelOrigDispMode);
                    this.label.setVisible(true);
                }
            } else if (this.label != null) {
                this.label.setDisplayMode(this.labelOrigDispMode);
                this.label.setVisible(true);
                try {
                    DeviceType aDeviceType;
                    Content content = (Content)this.label.getModel();
                    ModifyGraphMacroCommand command = new ModifyGraphMacroCommand();
                    command.addCommand(new EditContentCommand(content, editedDoc.getText(0, editedDoc.getLength())));
                    Iterator i = content.getDeviceTypesVisibleTo().iterator();
                    while (i.hasNext()) {
                        aDeviceType = (DeviceType)i.next();
                        command.addCommand(new SetContentDisplayModeCommand(content, aDeviceType, Content.TEXT));
                    }
                    if (this.label.getParent().getClientProperty("Resize children anchor") == Direction.CENTER) {
                        i = content.getDeviceTypesVisibleTo().iterator();
                        while (i.hasNext()) {
                            aDeviceType = (DeviceType)i.next();
                            Rectangle2D contentOldLocalBounds = content.getBounds(aDeviceType);
                            AffineTransform contentOldTransform = content.getTransform(aDeviceType);
                            Rectangle2D contentOldBounds = GeomLib.transformRectangle(contentOldTransform, contentOldLocalBounds);
                            Rectangle2D contentNewBoundsSortOf = GeomLib.transformRectangle(contentOldTransform, new Rectangle2D.Double(contentOldLocalBounds.getX(), contentOldLocalBounds.getY(), this.editedText.getWidth(), this.editedText.getHeight()));
                            AffineTransform contentNewTransform = AffineTransform.getTranslateInstance((contentOldBounds.getWidth() - contentNewBoundsSortOf.getWidth()) / 2.0, (contentOldBounds.getHeight() - contentNewBoundsSortOf.getHeight()) / 2.0);
                            contentNewTransform.concatenate(contentOldTransform);
                            command.addCommand(new SetTransformCommand(content, aDeviceType, contentNewTransform));
                        }
                    }
                    damaskCanvas.getDocument().getCommandQueue().doCommand(damaskCanvas, command);
                }
                catch (BadLocationException e) {
                    DamaskAppExceptionHandler.log(e);
                }
            } else {
                PBounds bounds = this.editedText.getBounds();
                PAffineTransform transform = this.editedText.getTransform();
                try {
                    PageRegion region = (PageRegion)this.regionView.getModel();
                    DamaskLayer layer = (DamaskLayer)damaskCanvas.getLayer();
                    DeviceType deviceTypeForText = layer.getDeviceTypeForNewElement();
                    Content content = new Content(deviceTypeForText, editedDoc.getText(0, editedDoc.getLength()));
                    content.setTransform(region.getDeviceType(), transform);
                    if (content.isVisibleToDeviceType(DeviceType.VOICE)) {
                        content.setTransform(DeviceType.VOICE, transform);
                    }
                    content.setBounds(region.getDeviceType(), bounds);
                    ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
                    DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, content, region);
                    damaskCanvas.getDocument().getCommandQueue().doCommand(damaskCanvas, cmd);
                }
                catch (BadLocationException e) {
                    DamaskAppExceptionHandler.log(e);
                }
            }
            this.editor.setVisible(false);
            this.canvas.repaint();
            this.editedText = null;
            this.label = null;
        }
    }

    protected JTextComponent createDefaultEditor() {
        JTextComponent tComp = super.createDefaultEditor();
        tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
        return tComp;
    }
}

