/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.event;

import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.SplitPageCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class SplitEventHandler
extends PBasicInputEventHandler {
    private PageViewContents pageViewContents;
    private DamaskPPath splitter = new DamaskPPath();
    static /* synthetic */ Class class$0;

    public SplitEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    protected void updateSplitter(PInputEvent e) {
        if (this.pageViewContents != null) {
            Point2D pos = e.getPosition();
            this.pageViewContents.getRegionView(Direction.CENTER).globalToLocal(pos);
            PBounds pageViewContentsCenterBounds = this.pageViewContents.getRegionView(Direction.CENTER).getBounds();
            this.splitter.setPathTo(new Line2D.Double(pageViewContentsCenterBounds.getMinX(), pos.getY(), pageViewContentsCenterBounds.getMaxX(), pos.getY()));
        }
    }

    public void mouseEntered(PInputEvent event) {
        PageViewContents contents;
        PNode pNode = event.getPickedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageViewContents");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.pageViewContents != (contents = (PageViewContents)DamaskAppUtils.getAncestor(pNode, clazz))) {
            this.splitter.removeFromParent();
            this.pageViewContents = contents;
            if (this.pageViewContents != null) {
                this.pageViewContents.getRegionView(Direction.CENTER).addChild(0, this.splitter);
            }
        }
        this.updateSplitter(event);
    }

    public void mouseMoved(PInputEvent event) {
        this.updateSplitter(event);
    }

    public void mouseReleased(PInputEvent event) {
        this.updateSplitter(event);
        if (this.pageViewContents != null) {
            Point2D splitterPos = event.getPosition();
            PageRegionView centerView = this.pageViewContents.getRegionView(Direction.CENTER);
            centerView.globalToLocal(splitterPos);
            double splitterY = splitterPos.getY();
            PBounds pageViewContentsCenterBounds = centerView.getBounds();
            if (pageViewContentsCenterBounds.getMinY() <= splitterY && splitterY <= pageViewContentsCenterBounds.getMaxY()) {
                PageRegion centerRegion = (PageRegion)centerView.getModel();
                ArrayList<Control> controlsToSplitAway = new ArrayList<Control>();
                Iterator i = centerRegion.getControls().iterator();
                while (i.hasNext()) {
                    Control control = (Control)i.next();
                    Rectangle2D controlBounds = control.getBoundsInParentCoords(centerRegion.getDeviceType());
                    if (!(controlBounds.getY() >= splitterY)) continue;
                    controlsToSplitAway.add(control);
                }
                VisualCanvas canvas = (VisualCanvas)event.getComponent();
                canvas.getDocument().getCommandQueue().doCommand(canvas, new SplitPageCommand(centerRegion.getPage(), controlsToSplitAway, splitterY));
            }
        }
    }

    public void cleanUp() {
        this.splitter.removeFromParent();
    }
}

