/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.event;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.AddConnectionCommand;
import edu.berkeley.guir.damask.command.AddStrokeCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class PencilEventHandler
extends PDragSequenceEventHandler {
    private static final double DEFAULT_DISTANCE_THRESHOLD = 200.0;
    private static final Color LAST_LABEL_COLOR = Color.GREEN;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private DamaskPPath stroke = null;
    private Label lastLabel = null;
    private DamaskPPath lastStrokeInLabel = null;
    private PNode startNode;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PencilEventHandler() {
        this.getEventFilter().setAndMask(16);
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.startNode = e.getPath().getPickedNode();
        Point2D p = e.getPosition();
        this.stroke = new DamaskPPath();
        this.stroke.setPickable(false);
        this.stroke.moveTo((float)p.getX(), (float)p.getY());
        this.stroke.setStroke(new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
        VisualCanvas canvas = (VisualCanvas)e.getComponent();
        canvas.getLayer().addChild(this.stroke);
        canvas.stopTextEditing();
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        this.updateStroke(e);
    }

    public void endDrag(PInputEvent e) {
        Dialog endDialog;
        Dialog startDialog;
        PageView endPageView;
        super.endDrag(e);
        this.updateStroke(e);
        this.stroke.removeFromParent();
        this.stroke.setStroke(DEFAULT_STROKE);
        Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
        PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageView startPageView = (PageView)DamaskAppUtils.getAncestor(this.startNode, clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((endPageView = (PageView)DamaskAppUtils.getAncestor(endNode, clazz2)) == null) {
            canvas.setInsideNode(null);
        }
        DamaskLayer layer = (DamaskLayer)canvas.getLayer();
        if (startPageView != null && (startDialog = ((Page)startPageView.getModel()).getDialog()).getDeviceType() != DeviceType.ALL && layer.getDeviceTypeForNewElement() == DeviceType.ALL) {
            return;
        }
        if (endPageView != null && (endDialog = ((Page)endPageView.getModel()).getDialog()).getDeviceType() != DeviceType.ALL && layer.getDeviceTypeForNewElement() == DeviceType.ALL) {
            return;
        }
        if (startPageView == endPageView && startPageView != null) {
            this.createOrModifyContentIfPossible(canvas, layer, startPageView);
        } else {
            this.createConnectionIfPossible(canvas, layer, endNode);
        }
    }

    private void createOrModifyContentIfPossible(DamaskCanvas canvas, DamaskLayer layer, PageView startPageView) {
        double strokeArea;
        Page startPage = (Page)startPageView.getModel();
        if (startPage.getDialog().getDeviceType() != DeviceType.ALL && layer.getDeviceTypeLayer() == DamaskLayer.DeviceTypeLayer.ALL) {
            return;
        }
        GeneralPath strokePath = (GeneralPath)this.stroke.getPathReference().clone();
        Rectangle2D strokeBounds = strokePath.getBounds2D();
        DamaskAppUtils.localToGlobal(this.stroke, strokeBounds);
        DamaskWindowTitle pViewTitle = startPageView.getTitleBar();
        PBounds pViewTitleBounds = pViewTitle.getBounds();
        pViewTitle.localToGlobal(pViewTitleBounds);
        Rectangle2D titleIntersection = pViewTitleBounds.createIntersection(strokeBounds);
        double intersectionArea = titleIntersection.isEmpty() ? 0.0 : titleIntersection.getHeight() * titleIntersection.getWidth();
        double d = strokeArea = strokeBounds.isEmpty() ? 0.0 : strokeBounds.getHeight() * strokeBounds.getWidth();
        if (intersectionArea >= strokeArea * 0.5 && intersectionArea != 0.0 && strokeArea != 0.0) {
            return;
        }
        PageViewContents pViewContents = (PageViewContents)startPageView.getContents();
        PBounds pViewContentsBounds = pViewContents.getBounds();
        pViewContents.localToGlobal(pViewContentsBounds);
        if (DamaskAppUtils.containsRect(pViewContentsBounds, strokeBounds)) {
            Command cmd;
            PageRegionView regionView = this.findContainingRegion(pViewContents, strokeBounds);
            DamaskAppUtils.globalToLocal(regionView, strokeBounds);
            GeneralPath resizedPath = (GeneralPath)this.stroke.getPathReference().clone();
            DamaskAppUtils.resizeGeneralPath(resizedPath, strokeBounds);
            this.stroke.setPathTo(resizedPath);
            if (this.lastLabel != null) {
                this.lastLabel.setStrokePaint(null);
            }
            if ((cmd = this.getAddToExistingContentCommand(regionView)) == null) {
                cmd = this.getAddToNearbyContentCommand(regionView);
            }
            if (cmd == null) {
                cmd = this.getCreateNewContentCommand(layer, regionView);
            }
            canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
            if (!(cmd instanceof AddStrokeCommand)) {
                this.lastLabel = regionView.getMostRecentlyAddedLabel();
            }
            this.lastStrokeInLabel = (DamaskPPath)this.lastLabel.getStrokesContainer().getChild(this.lastLabel.getStrokesContainer().getChildrenCount() - 1);
            if (this.lastLabel != null) {
                this.lastLabel.setStrokePaint(LAST_LABEL_COLOR);
            }
        }
    }

    private PageRegionView findContainingRegion(PageViewContents pViewContents, Rectangle2D strokeBounds) {
        double largestIntersectionArea = 0.0;
        PageRegionView regionView = null;
        Iterator k = pViewContents.getRegionViews().iterator();
        while (k.hasNext()) {
            Rectangle2D intersection;
            PageRegionView currentRegionView = (PageRegionView)k.next();
            PBounds currentRegionViewBounds = currentRegionView.getBounds();
            currentRegionView.localToGlobal(currentRegionViewBounds);
            double intersectionArea = strokeBounds.getWidth() == 0.0 && strokeBounds.getHeight() == 0.0 ? (currentRegionViewBounds.contains(strokeBounds.getX(), strokeBounds.getY()) ? 1.0 : 0.0) : (strokeBounds.getWidth() == 0.0 ? (((RectangularShape)currentRegionViewBounds).getX() <= strokeBounds.getX() && strokeBounds.getX() <= currentRegionViewBounds.getMaxX() ? (strokeBounds.getY() <= ((RectangularShape)currentRegionViewBounds).getY() && ((RectangularShape)currentRegionViewBounds).getY() <= strokeBounds.getMaxY() ? strokeBounds.getMaxY() - ((RectangularShape)currentRegionViewBounds).getY() : (strokeBounds.getY() <= currentRegionViewBounds.getMaxY() && currentRegionViewBounds.getMaxY() <= strokeBounds.getMaxY() ? currentRegionViewBounds.getMaxY() - strokeBounds.getY() : (((RectangularShape)currentRegionViewBounds).getY() <= strokeBounds.getY() && strokeBounds.getMaxY() <= currentRegionViewBounds.getMaxY() ? strokeBounds.getHeight() : 0.0))) : 0.0) : (strokeBounds.getHeight() == 0.0 ? (((RectangularShape)currentRegionViewBounds).getY() <= strokeBounds.getY() && strokeBounds.getY() <= currentRegionViewBounds.getMaxY() ? (strokeBounds.getX() <= ((RectangularShape)currentRegionViewBounds).getX() && ((RectangularShape)currentRegionViewBounds).getX() <= strokeBounds.getMaxX() ? strokeBounds.getMaxX() - ((RectangularShape)currentRegionViewBounds).getX() : (strokeBounds.getX() <= currentRegionViewBounds.getMaxX() && currentRegionViewBounds.getMaxX() <= strokeBounds.getMaxX() ? currentRegionViewBounds.getMaxX() - strokeBounds.getX() : (((RectangularShape)currentRegionViewBounds).getX() <= strokeBounds.getX() && strokeBounds.getMaxX() <= currentRegionViewBounds.getMaxX() ? strokeBounds.getWidth() : 0.0))) : 0.0) : ((intersection = ((Rectangle2D)currentRegionViewBounds).createIntersection(strokeBounds)).isEmpty() ? 0.0 : intersection.getHeight() * intersection.getWidth())));
            if (!(intersectionArea > largestIntersectionArea)) continue;
            largestIntersectionArea = intersectionArea;
            regionView = currentRegionView;
        }
        return regionView;
    }

    private Command getAddToExistingContentCommand(PageRegionView regionView) {
        AddStrokeCommand cmd = null;
        GeneralPath strokePath = (GeneralPath)this.stroke.getPathReference().clone();
        Rectangle2D strokeBounds = strokePath.getBounds2D();
        Iterator i = regionView.getChildrenIterator();
        while (i.hasNext()) {
            Label label;
            ComponentView componentView;
            Object editableContents;
            PNode node = (PNode)i.next();
            if (!(node instanceof ComponentView) || !((editableContents = (componentView = (ComponentView)node).getEditableContents()) instanceof Label) || (label = (Label)editableContents).getDisplayMode() != Content.INK || !DamaskAppUtils.containsRect(label.getFullBounds(), strokeBounds)) continue;
            DamaskAppUtils.localToGlobal(regionView, strokeBounds);
            DamaskAppUtils.globalToLocal(label, strokeBounds);
            DamaskAppUtils.resizeGeneralPath(strokePath, strokeBounds);
            Content content = (Content)label.getModel();
            PageRegion region = (PageRegion)regionView.getModel();
            cmd = new AddStrokeCommand(content, this.createPathInContentFullBounds(strokePath, region.getDeviceType(), content));
            break;
        }
        return cmd;
    }

    private Command getAddToNearbyContentCommand(PageRegionView regionView) {
        GeneralPath strokePath = (GeneralPath)this.stroke.getPathReference().clone();
        AddStrokeCommand cmd = null;
        if (this.lastStrokeInLabel != null && this.lastLabel.getDisplayMode().equals(Content.INK)) {
            Rectangle2D strokeBounds = strokePath.getBounds2D();
            DamaskAppUtils.localToGlobal(regionView, strokeBounds);
            DamaskAppUtils.globalToLocal(this.lastLabel, strokeBounds);
            DamaskAppUtils.resizeGeneralPath(strokePath, strokeBounds);
            TimedStroke satinStroke = new TimedStroke(GeomLib.makePolygon(strokePath));
            TimedStroke satinLastStroke = new TimedStroke(GeomLib.makePolygon(this.lastStrokeInLabel.getPathReference()));
            if (StrokeLib.computeHandwritingDistance(satinStroke, satinLastStroke) < 200.0) {
                Content lastContent = (Content)this.lastLabel.getModel();
                PageRegion region = (PageRegion)regionView.getModel();
                cmd = new AddStrokeCommand(lastContent, this.createPathInContentFullBounds(strokePath, region.getDeviceType(), lastContent));
            }
        }
        return cmd;
    }

    private Command getCreateNewContentCommand(DamaskLayer layer, PageRegionView regionView) {
        GeneralPath strokePath = (GeneralPath)this.stroke.getPathReference().clone();
        PageRegion region = (PageRegion)regionView.getModel();
        Rectangle2D strokeBounds = strokePath.getBounds2D();
        Rectangle2D.Double newStrokeBounds = new Rectangle2D.Double(0.0, 0.0, strokeBounds.getWidth(), strokeBounds.getHeight());
        DeviceType deviceType = layer.getDeviceTypeForNewElement();
        AffineTransform transform = AffineTransform.getTranslateInstance(strokeBounds.getX(), strokeBounds.getY());
        strokePath.transform(AffineTransform.getTranslateInstance(-strokeBounds.getX(), -strokeBounds.getY()));
        Content content = new Content(deviceType, strokePath);
        content.setTransform(region.getDeviceType(), transform);
        content.setBounds(region.getDeviceType(), newStrokeBounds);
        ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
        DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, content, region);
        return cmd;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createConnectionIfPossible(DamaskCanvas canvas, DamaskLayer layer, PNode endNode) {
        Class<?> clazz;
        boolean addedArrow = false;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                this.startNode = this.startNode.getParent();
            }
            if (this.startNode == null) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("edu.berkeley.guir.damask.connection.ConnectionSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!this.isModelInstanceOf(this.startNode, clazz));
        if (this.startNode != null) {
            Class<?> clazz2;
            boolean bl2 = true;
            do {
                if (!bl2 || (bl2 = false) || !true) {
                    endNode = endNode.getParent();
                }
                if (endNode == null) break;
                clazz2 = class$2;
                if (clazz2 != null) continue;
                try {
                    clazz2 = Class.forName("edu.berkeley.guir.damask.dialog.Page");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            } while (!this.isModelInstanceOf(endNode, clazz2));
            if (endNode != null) {
                InteractionElementView startElementView = (InteractionElementView)this.startNode;
                int condition = startElementView instanceof ControlView ? ((ControlView)startElementView).getPageView().getDesignTimeCondition() : -1;
                ConnectionSource newConnectionSource = (ConnectionSource)((InteractionElementView)this.startNode).getModel();
                GeneralPath strokePath = (GeneralPath)this.stroke.getPathReference().clone();
                AddConnectionCommand command = new AddConnectionCommand(canvas.getDeviceType(), layer.getDeviceTypeLayer() == DamaskLayer.DeviceTypeLayer.ALL, newConnectionSource, new InvokeEvent(newConnectionSource), condition, (ConnectionDest)((InteractionElementView)endNode).getModel(), strokePath);
                if (command.shouldRun()) {
                    canvas.getDocument().getCommandQueue().doCommand(canvas, command);
                    return;
                }
            }
        }
        if (addedArrow) return;
        canvas.getLayer().addChild(this.stroke);
        canvas.getRoot().addActivity(new FlickerStrokeActivity(this.stroke, 2000L, 500L));
    }

    private boolean isModelInstanceOf(PNode node, Class aClass) {
        if (node instanceof InteractionElementView) {
            return aClass.isInstance(((InteractionElementView)node).getModel());
        }
        return false;
    }

    private void updateStroke(PInputEvent e) {
        Point2D p = e.getPosition();
        this.stroke.lineTo((float)p.getX(), (float)p.getY());
    }

    private GeneralPath createPathInContentFullBounds(GeneralPath path, DeviceType deviceType, Content content) {
        double newHeight;
        double newY;
        double newWidth;
        double newX;
        Rectangle2D contentFullBounds = content.getFullSizeBounds(Content.INK);
        GeneralPath newPath = (GeneralPath)path.clone();
        if (contentFullBounds == null || content.getPreferredDisplayMode(deviceType) != Content.INK) {
            return newPath;
        }
        Rectangle2D contentOldBounds = content.getBounds(deviceType);
        Rectangle2D pathBounds = path.getBounds2D();
        if (contentOldBounds.getWidth() < 1.0 || contentFullBounds.getWidth() < 1.0) {
            newX = pathBounds.getX() - contentOldBounds.getX() + contentFullBounds.getX();
            newWidth = pathBounds.getWidth();
        } else {
            double strokeFracX = (pathBounds.getX() - contentOldBounds.getX()) / contentOldBounds.getWidth();
            double strokeFracWidth = pathBounds.getWidth() / contentOldBounds.getWidth();
            newX = strokeFracX * contentFullBounds.getWidth() + contentFullBounds.getX();
            newWidth = strokeFracWidth * contentFullBounds.getWidth();
        }
        if (contentOldBounds.getHeight() < 1.0 || contentFullBounds.getHeight() < 1.0) {
            newY = pathBounds.getY() - contentOldBounds.getY() + contentFullBounds.getY();
            newHeight = pathBounds.getHeight();
        } else {
            double strokeFracY = (pathBounds.getY() - contentOldBounds.getY()) / contentOldBounds.getHeight();
            double strokeFracHeight = pathBounds.getHeight() / contentOldBounds.getHeight();
            newY = strokeFracY * contentFullBounds.getHeight() + contentFullBounds.getY();
            newHeight = strokeFracHeight * contentFullBounds.getHeight();
        }
        Rectangle2D.Double pathFullBounds = new Rectangle2D.Double(newX, newY, newWidth, newHeight);
        DamaskAppUtils.resizeGeneralPath(newPath, pathFullBounds);
        return newPath;
    }

    private static class FlickerStrokeActivity
    extends PActivity {
        private final DamaskPPath stroke;
        private boolean flag = false;

        FlickerStrokeActivity(DamaskPPath stroke, long aDuration) {
            super(aDuration);
            this.stroke = stroke;
        }

        FlickerStrokeActivity(DamaskPPath stroke, long aDuration, long aStepRate) {
            super(aDuration, aStepRate);
            this.stroke = stroke;
        }

        FlickerStrokeActivity(DamaskPPath stroke, long aDuration, long aStepRate, long aStartTime) {
            super(aDuration, aStepRate, aStartTime);
            this.stroke = stroke;
        }

        protected void activityStep(long elapsedTime) {
            super.activityStep(elapsedTime);
            this.flag = !this.flag;
            this.stroke.setStrokePaint(this.flag ? Color.RED : Color.GRAY);
        }

        protected void activityFinished() {
            super.activityFinished();
            this.stroke.removeFromParent();
        }
    }
}

