/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.event;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.VisualLayer;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class InsertComponentHandler
extends PDragSequenceEventHandler {
    private final Class componentViewType;
    private PNode tempComponentView;
    static /* synthetic */ Class class$0;

    public InsertComponentHandler(Class componentViewType) {
        this.setEventFilter(new PInputEventFilter(16));
        this.componentViewType = componentViewType;
    }

    protected void createTempComponentView(PInputEvent e) {
        try {
            PLayer layer = ((PCanvas)e.getComponent()).getLayer();
            Method createTempViewMethod = this.componentViewType.getMethod("createTempView", null);
            this.tempComponentView = (PNode)createTempViewMethod.invoke(null, null);
            layer.addChild(this.tempComponentView);
            this.updateComponentView(e, this.tempComponentView);
        }
        catch (SecurityException e1) {
            DamaskAppExceptionHandler.log(e1);
        }
        catch (NoSuchMethodException e1) {
            DamaskAppExceptionHandler.log(e1);
        }
        catch (IllegalArgumentException e2) {
            DamaskAppExceptionHandler.log(e2);
        }
        catch (IllegalAccessException e2) {
            DamaskAppExceptionHandler.log(e2);
        }
        catch (InvocationTargetException e2) {
            DamaskAppExceptionHandler.log(e2.getCause());
            DamaskAppExceptionHandler.log(e2);
        }
    }

    protected void updateComponentView(PInputEvent e, PNode componentView) {
        componentView.setOffset(e.getPosition());
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.createTempComponentView(e);
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        this.updateComponentView(e, this.tempComponentView);
    }

    public void endDrag(PInputEvent e) {
        PageRegionView regionView;
        super.endDrag(e);
        this.updateComponentView(e, this.tempComponentView);
        PBounds componentBds = this.tempComponentView.getBounds();
        this.tempComponentView.localToGlobal(componentBds);
        this.tempComponentView.removeFromParent();
        Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
        PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageRegionView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((regionView = (PageRegionView)DamaskAppUtils.getAncestor(endNode, clazz)) != null) {
            VisualCanvas canvas = (VisualCanvas)e.getComponent();
            VisualLayer layer = (VisualLayer)canvas.getLayer();
            regionView.globalToLocal(componentBds);
            canvas.getDocument().getCommandQueue().doCommand(canvas, this.getInsertComponentCommand(layer.getDeviceTypeForNewElement(), (PageRegion)regionView.getModel(), AffineTransform.getTranslateInstance(componentBds.getX(), componentBds.getY()), new Rectangle2D.Double(0.0, 0.0, componentBds.getWidth(), componentBds.getHeight())));
        }
    }

    protected Command getInsertComponentCommand(DeviceType deviceType, PageRegion region, AffineTransform transform, Rectangle2D bounds) {
        Component newComponent = this.createNewComponent(deviceType, region, transform, bounds);
        ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
        DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, newComponent, region);
        return cmd;
    }

    protected abstract Component createNewComponent(DeviceType var1, PageRegion var2, AffineTransform var3, Rectangle2D var4);
}

