/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.dialog;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.nodes.PageRegionViewSizingBorder;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewPart;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PageViewContents
extends PClip
implements PageViewPart {
    private static final Paint FOLD_COLOR = new Color(255, 0, 0, 80);
    private static final Stroke FOLD_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private boolean inRunMode = false;
    private final Map regions = new HashMap();
    private int northInset = Integer.MIN_VALUE;
    private int southInset = Integer.MIN_VALUE;
    private int westInset = Integer.MIN_VALUE;
    private int eastInset = Integer.MIN_VALUE;

    public PageViewContents(final boolean grayOutTemplateElements) {
        this.addPropertyChangeListener("parent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PageViewContents.this.setInRunMode(PageViewContents.this.getPageView().isInRunMode());
                Iterator i = PageViewContents.this.getRegionNames().iterator();
                while (i.hasNext()) {
                    Direction name = (Direction)i.next();
                    PageRegion region = ((Page)PageViewContents.this.getPageView().getModel()).getRegion(name);
                    PageRegionView regionView = new PageRegionView(region, grayOutTemplateElements);
                    PageViewContents.this.regions.put(name, regionView);
                    PageViewContents.this.addChild(regionView);
                }
            }
        });
    }

    public PageView getPageView() {
        return (PageView)this.getParent();
    }

    public Set getRegionNames() {
        return ((Page)this.getPageView().getModel()).getRegionNames();
    }

    public PageRegionView getRegionView(Direction name) {
        return (PageRegionView)this.regions.get(name);
    }

    public Collection getRegionViews() {
        return Collections.unmodifiableCollection(this.regions.values());
    }

    public boolean isInRunMode() {
        return this.inRunMode;
    }

    public void setInRunMode(boolean flag) {
        this.inRunMode = flag;
        Iterator i = this.getRegionViews().iterator();
        while (i.hasNext()) {
            PageRegionView regionView = (PageRegionView)i.next();
            regionView.setInRunMode(flag);
        }
        this.repaint();
    }

    public void addRegionResizingBorders(PCamera camera) {
        PageRegionView centerRegion = this.getRegionView(Direction.CENTER);
        PageRegionView northRegion = this.getRegionView(Direction.NORTH);
        PageRegionView southRegion = this.getRegionView(Direction.SOUTH);
        PageRegionView eastRegion = this.getRegionView(Direction.EAST);
        PageRegionView westRegion = this.getRegionView(Direction.WEST);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createSouthLocator(northRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createNorthLocator(southRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createEastLocator(westRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createWestLocator(eastRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createNorthLocator(centerRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createSouthLocator(centerRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createWestLocator(centerRegion), camera);
        PageRegionViewSizingBorder.addPageRegionViewSizingBorderTo(PBoundsLocator.createEastLocator(centerRegion), camera);
    }

    public void removeRegionResizingBorders() {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        Iterator i = this.getRegionViews().iterator();
        while (i.hasNext()) {
            handles.clear();
            PageRegionView regionView = (PageRegionView)i.next();
            Iterator j = regionView.getChildrenIterator();
            while (j.hasNext()) {
                PNode child = (PNode)j.next();
                if (!(child instanceof PageRegionViewSizingBorder)) continue;
                handles.add(child);
            }
            regionView.removeChildren(handles);
        }
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        if (!this.isInRunMode()) {
            Graphics2D g2 = paintContext.getGraphics();
            DeviceType deviceType = ((Page)this.getPageView().getModel()).getDeviceType();
            int width = deviceType.getDefaultWidth();
            int height = deviceType.getDefaultHeight();
            Paint oldPaint = g2.getPaint();
            Stroke oldStroke = g2.getStroke();
            g2.setPaint(FOLD_COLOR);
            g2.setStroke(FOLD_STROKE);
            GeneralPath fold = new GeneralPath();
            fold.moveTo(width, 0.0f);
            fold.lineTo(width, height);
            fold.lineTo(0.0f, height);
            g2.draw(fold);
            g2.setPaint(oldPaint);
            g2.setStroke(oldStroke);
        }
    }

    protected void layoutChildren() {
        int newWestInset;
        int newEastInset;
        int newSouthInset;
        int newNorthInset;
        Set regionNames = this.getRegionNames();
        boolean emptyBounds = this.getBounds().isEmpty();
        if (regionNames.contains(Direction.NORTH)) {
            PageRegionView northRegion = this.getRegionView(Direction.NORTH);
            newNorthInset = northRegion.getInset();
            northRegion.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), newNorthInset));
        } else {
            newNorthInset = 0;
        }
        if (regionNames.contains(Direction.SOUTH)) {
            PageRegionView southRegion = this.getRegionView(Direction.SOUTH);
            newSouthInset = southRegion.getInset();
            southRegion.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), newSouthInset));
            southRegion.setOffset(0.0, this.getHeight() - (double)newSouthInset);
        } else {
            newSouthInset = 0;
        }
        if (regionNames.contains(Direction.EAST)) {
            PageRegionView eastRegion = this.getRegionView(Direction.EAST);
            newEastInset = eastRegion.getInset();
            eastRegion.setPathTo(new Rectangle2D.Double(0.0, 0.0, newEastInset, this.getHeight() - (double)newNorthInset - (double)newSouthInset));
            eastRegion.setOffset(this.getWidth() - (double)newEastInset, newNorthInset);
        } else {
            newEastInset = 0;
        }
        if (regionNames.contains(Direction.WEST)) {
            PageRegionView westRegion = this.getRegionView(Direction.WEST);
            newWestInset = westRegion.getInset();
            westRegion.setPathTo(new Rectangle2D.Double(0.0, 0.0, newWestInset, this.getHeight() - (double)newNorthInset - (double)newSouthInset));
            westRegion.setOffset(0.0, newNorthInset);
        } else {
            newWestInset = 0;
        }
        PageRegionView centerRegion = this.getRegionView(Direction.CENTER);
        centerRegion.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth() - (double)newWestInset - (double)newEastInset, this.getHeight() - (double)newNorthInset - (double)newSouthInset));
        centerRegion.setOffset(newWestInset, newNorthInset);
        this.northInset = newNorthInset;
        this.southInset = newSouthInset;
        this.westInset = newWestInset;
        this.eastInset = newEastInset;
    }
}

