/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.dialog;

import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.PageEvent;
import edu.berkeley.guir.damask.event.PageListener;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.nodes.DamaskWindow;
import edu.berkeley.guir.damask.view.visual.component.CheckBoxGroup;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.RadioButtonGroup;
import edu.berkeley.guir.damask.view.visual.dialog.DialogView;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;

public class PageView
extends DamaskWindow {
    private static final Color DEFAULT_TITLE_BAR_PAINT = new Color(240, 240, 255);
    private static final Paint PAGE_COLOR = Color.WHITE;
    private static final Paint DEVICE_PAGE_PAINT_IN_ALL_LAYER = new Color(233, 233, 233);
    private int designTimeCondition = 0;
    private PageHandler pageHandler = new PageHandler();

    public PageView(Page page) {
        this(page, true);
    }

    public PageView(Page page, boolean grayOutTemplateElements) {
        super(page, grayOutTemplateElements);
        page.addPageListener(this.pageHandler);
        this.setStrokePaint(null);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        PageViewContents contents = (PageViewContents)this.getContents();
        Iterator i = contents.getRegionViews().iterator();
        while (i.hasNext()) {
            PageRegionView regionView = (PageRegionView)i.next();
            Iterator j = regionView.getChildrenIterator();
            while (j.hasNext()) {
                ComponentView componentView = (ComponentView)j.next();
                if (!(componentView instanceof ControlView)) continue;
                ControlView controlView = (ControlView)componentView;
                Control control = (Control)controlView.getModel();
                controlView.setState(control.getStateForCondition(control.getDialog(), 0));
            }
        }
        if (this.getParent() instanceof DialogView) {
            this.setContentsSelectable(((DialogView)this.getParent()).isContentsSelectable());
        }
    }

    protected PPath createContents() {
        return new PageViewContents(this.isTemplateElementsGrayedOut());
    }

    protected Content getTitleContent() {
        return ((Page)this.getModel()).getTitle();
    }

    public void dispose() {
        super.dispose();
        Page page = (Page)this.getModel();
        page.removePageListener(this.pageHandler);
    }

    protected Paint getContentsPaint() {
        return PAGE_COLOR;
    }

    protected Paint getDeviceSpecificContentsPaintInAllLayer() {
        return DEVICE_PAGE_PAINT_IN_ALL_LAYER;
    }

    protected Color getTitleColor() {
        return DEFAULT_TITLE_BAR_PAINT;
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        PageViewContents contents = (PageViewContents)this.getContents();
        if (contents != null) {
            contents.setInRunMode(flag);
        }
    }

    protected void setContentsSelectable(boolean selectable) {
        DamaskLayer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        if (selectable) {
            layer.addSelectableParent(this.getTitleBar());
        } else {
            layer.removeSelectableParent(this.getTitleBar());
        }
        Iterator j = ((PageViewContents)this.getContents()).getRegionViews().iterator();
        while (j.hasNext()) {
            PageRegionView prView = (PageRegionView)j.next();
            if (selectable) {
                layer.addSelectableParent(prView);
            } else {
                layer.removeSelectableParent(prView);
            }
            Iterator k = prView.getChildrenIterator();
            while (k.hasNext()) {
                PNode node = (PNode)k.next();
                if (!(node instanceof CheckBoxGroup) && !(node instanceof RadioButtonGroup)) continue;
                if (selectable) {
                    layer.addSelectableParent(node);
                    continue;
                }
                layer.removeSelectableParent(node);
            }
        }
    }

    public int getDesignTimeCondition() {
        return this.designTimeCondition;
    }

    protected void setDesignTimeCondition(int condition) {
        Dialog dialog = ((Page)this.getModel()).getDialog();
        if (condition >= dialog.getNumConditions()) {
            throw new IllegalArgumentException();
        }
        this.designTimeCondition = condition;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof PageView)) continue;
            PageView pageView = (PageView)child;
            Iterator j = ((PageViewContents)pageView.getContents()).getRegionViews().iterator();
            while (j.hasNext()) {
                PageRegionView regionView = (PageRegionView)j.next();
                Iterator k = regionView.getChildrenIterator();
                while (k.hasNext()) {
                    Object rvChild = k.next();
                    if (!(rvChild instanceof ControlView)) continue;
                    ControlView controlView = (ControlView)rvChild;
                    Control control = (Control)controlView.getModel();
                    controlView.setState(control.getStateForCondition(dialog, condition));
                }
            }
        }
    }

    protected void deviceTypeLayerChanged() {
        super.deviceTypeLayerChanged();
        PageViewContents contents = (PageViewContents)this.getContents();
        Iterator j = contents.getChildrenIterator();
        while (j.hasNext()) {
            PNode pageChild = (PNode)j.next();
            if (!(pageChild instanceof PageRegionView)) continue;
            Iterator k = ((PageRegionView)pageChild).getChildrenIterator();
            while (k.hasNext()) {
                PNode regionChild = (PNode)k.next();
                if (!(regionChild instanceof ComponentView)) continue;
                ((ComponentView)regionChild).deviceTypeLayerChanged();
            }
        }
    }

    protected Dialog getDialogModel() {
        return ((Page)this.getModel()).getDialog();
    }

    private final class PageHandler
    implements PageListener {
        PageHandler() {
        }

        public void templateAdded(PageEvent e) {
            Page template = (Page)e.getValue();
            PageViewContents contents = (PageViewContents)PageView.this.getContents();
            Iterator i = contents.getRegionViews().iterator();
            while (i.hasNext()) {
                PageRegionView regionView = (PageRegionView)i.next();
                regionView.addTemplate(template);
            }
        }

        public void templateRemoved(PageEvent e) {
            Page template = (Page)e.getValue();
            PageViewContents contents = (PageViewContents)PageView.this.getContents();
            Iterator i = contents.getRegionViews().iterator();
            while (i.hasNext()) {
                PageRegionView regionView = (PageRegionView)i.next();
                regionView.removeTemplate(template);
            }
        }
    }
}

