/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.dialog;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.pattern.PatternInstanceView;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.VisualLayer;
import edu.berkeley.guir.damask.view.visual.component.Button;
import edu.berkeley.guir.damask.view.visual.component.CheckBoxGroup;
import edu.berkeley.guir.damask.view.visual.component.ComboBox;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Hyperlink;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.ListBox;
import edu.berkeley.guir.damask.view.visual.component.Panel;
import edu.berkeley.guir.damask.view.visual.component.RadioButtonGroup;
import edu.berkeley.guir.damask.view.visual.component.TextBox;
import edu.berkeley.guir.damask.view.visual.dialog.DialogView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewPart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PageRegionView
extends InteractionElementView
implements PageViewPart {
    public static final Paint BORDER_COLOR;
    public static final Paint SELECTED_BORDER_COLOR;
    public static final Color GRID_COLOR;
    private static final Stroke TEMPLATE_CONTROLS_STROKE;
    private int inset;
    private final boolean grayOutTemplateElements;
    private boolean inRunMode = false;
    private final ElementContainerListener handler = new PageRegionHandler();
    private final ElementContainerListener templateHandler = new TemplatePageRegionHandler();
    private final InteractionElementListener elementHandler = new ElementHandler();
    private final ElementContainerListener dialogHandler = new DialogHandler();
    private final Map views = new HashMap();
    private final Map viewsFromTemplate = new HashMap();
    private WeakReference mostRecentlyAddedLabel = null;
    private int firstNormalChildIndex = 0;
    private int firstGroupIndex = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageRegionView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BORDER_COLOR = new Color(215, 215, 215);
        SELECTED_BORDER_COLOR = new Color(0, 153, 0);
        GRID_COLOR = new Color(0, 255, 255, 30);
        TEMPLATE_CONTROLS_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 3.0f}, 0.0f);
    }

    public PageRegionView(PageRegion region, boolean grayOutTemplateElements) {
        super(region);
        this.setStrokePaint(BORDER_COLOR);
        this.setPaint(DamaskAppUtils.NO_COLOR);
        this.grayOutTemplateElements = grayOutTemplateElements;
        region.addElementContainerListener(this.handler);
        region.addInteractionElementListener(this.elementHandler);
        region.getPage().getDialog().addElementContainerListener(this.dialogHandler);
        this.inset = region.getInset();
        this.addInputEventListener(new BasicInputEventHandler());
    }

    protected void initAfterAddToParent() {
        this.setInRunMode(((PageViewContents)this.getParent()).isInRunMode());
        PageRegion region = (PageRegion)this.getModel();
        Iterator i = region.getControls().iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            this.addViewForNormalControl(control);
        }
        i = region.getPage().getDialog().getGroups().iterator();
        while (i.hasNext()) {
            ComponentGroup group = (ComponentGroup)i.next();
            if (group.getTransformInPageRegion(region) == null) continue;
            this.addViewForGroup(group);
        }
        i = region.getPage().getTemplates().iterator();
        while (i.hasNext()) {
            Page template = (Page)i.next();
            this.addTemplate(template);
        }
    }

    public void dispose() {
        super.dispose();
        PageRegion region = (PageRegion)this.getModel();
        region.removeElementContainerListener(this.handler);
        region.removeInteractionElementListener(this.elementHandler);
        region.getPage().getDialog().removeElementContainerListener(this.dialogHandler);
    }

    public PageViewContents getContents() {
        return (PageViewContents)this.getParent();
    }

    public PageView getPageView() {
        PageViewContents contents = this.getContents();
        if (contents == null) {
            return null;
        }
        return contents.getPageView();
    }

    public DialogView getDialogView() {
        PageView pageView = this.getPageView();
        if (pageView == null) {
            return null;
        }
        PNode parent = pageView.getParent();
        if (parent instanceof DialogView) {
            return (DialogView)parent;
        }
        return null;
    }

    public DeviceType getDeviceType() {
        return ((PageRegion)this.getModel()).getDeviceType();
    }

    public Label getMostRecentlyAddedLabel() {
        return (Label)this.mostRecentlyAddedLabel.get();
    }

    private ControlView addViewForNormalControl(Control control) {
        return (ControlView)this.addViewForComponent(this.getChildrenCount(), control);
    }

    private ControlView addViewForNormalControl(int index, Control control) {
        return (ControlView)this.addViewForComponent(index + this.firstNormalChildIndex, control);
    }

    private ControlView addViewForTemplateControl(Page template, Control control) {
        return this.addViewForTemplateControl(template, this.firstGroupIndex, control);
    }

    private ControlView addViewForTemplateControl(Page template, int index, Control control) {
        ControlView result = (ControlView)this.addViewForComponent(index, control);
        ++this.firstNormalChildIndex;
        ++this.firstGroupIndex;
        ((List)this.viewsFromTemplate.get(template)).add(result);
        if (this.grayOutTemplateElements) {
            DamaskAppUtils.setInternalStroke(result, TEMPLATE_CONTROLS_STROKE);
        }
        if (!result.isInRunMode()) {
            result.setSelectable(false);
            result.setPickable(false);
        }
        return result;
    }

    private Panel addViewForGroup(ComponentGroup group) {
        return this.addViewForGroup(this.firstNormalChildIndex - this.firstGroupIndex, group);
    }

    private Panel addViewForGroup(int index, ComponentGroup group) {
        Panel result = (Panel)this.addViewForComponent(index + this.firstGroupIndex, group);
        ++this.firstNormalChildIndex;
        return result;
    }

    private ComponentView addViewForComponent(int index, Component component) {
        VisualLayer layer;
        ComponentView componentView;
        if (component instanceof Content) {
            componentView = new Label((Content)component);
            this.mostRecentlyAddedLabel = new WeakReference<Label>((Label)componentView);
        } else if (component instanceof Trigger) {
            Trigger trigger = (Trigger)component;
            componentView = trigger.getStyle(this.getDeviceType()) == Trigger.BUTTON ? new Button((Trigger)component) : new Hyperlink((Trigger)component);
        } else if (component instanceof TextInput) {
            componentView = new TextBox((TextInput)component);
        } else if (component instanceof SelectMany) {
            componentView = new CheckBoxGroup((SelectMany)component);
        } else if (component instanceof SelectOne) {
            SelectOne selectOne = (SelectOne)component;
            if (selectOne.getStyle(this.getDeviceType()) == SelectOne.FULL) {
                componentView = new RadioButtonGroup((SelectOne)component);
            } else if (selectOne.getStyle(this.getDeviceType()) == SelectOne.COMPACT) {
                componentView = new ListBox((SelectOne)component);
            } else {
                if (!$assertionsDisabled && selectOne.getStyle(this.getDeviceType()) != SelectOne.MINIMAL) {
                    throw new AssertionError();
                }
                componentView = new ComboBox((SelectOne)component);
            }
        } else if (component instanceof ComponentGroup) {
            componentView = new Panel((ComponentGroup)component);
        } else {
            componentView = null;
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("element of type " + component.getClass() + " cannot be added to a page region"));
            }
        }
        this.addChild(index, componentView);
        componentView.setInRunMode(this.isInRunMode());
        if (componentView instanceof ControlView) {
            ControlView controlView = (ControlView)componentView;
            Control control = (Control)component;
            Dialog dialogOfControl = control.getDialog();
            int conditionForState = dialogOfControl != ((Page)this.getPageView().getModel()).getDialog() ? dialogOfControl.getInitialCondition() : (this.isInRunMode() ? 0 : this.getPageView().getDesignTimeCondition());
            controlView.setState(control.getStateForCondition(dialogOfControl, conditionForState));
        }
        this.views.put(component, componentView);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.visual.VisualLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((layer = (VisualLayer)DamaskAppUtils.getAncestor(this, clazz)) != null) {
            if (componentView instanceof CheckBoxGroup || componentView instanceof RadioButtonGroup) {
                layer.addSelectableParent(componentView);
            }
            componentView.deviceTypeLayerChanged();
            layer.trackAddition(componentView);
            if (component instanceof Control) {
                Iterator i = ((Control)component).getPatternInstanceMemberships().iterator();
                while (i.hasNext()) {
                    PatternInstance instance = (PatternInstance)i.next();
                    PatternInstanceView instanceView = (PatternInstanceView)layer.getView(instance);
                    if (instanceView == null) continue;
                    instanceView.addMemberView(componentView);
                }
            }
        }
        return componentView;
    }

    private void removeViewForTemplateControl(Page template, Control control) {
        ControlView removedView = (ControlView)this.removeViewForComponent(control);
        ((List)this.viewsFromTemplate.get(template)).remove(removedView);
        --this.firstNormalChildIndex;
        --this.firstGroupIndex;
    }

    private void removeViewForGroup(ComponentGroup group) {
        this.removeViewForComponent(group);
        --this.firstNormalChildIndex;
    }

    private ComponentView removeViewForComponent(Component component) {
        DamaskLayer layer;
        ComponentView componentView = (ComponentView)this.views.get(component);
        componentView.removeFromParent();
        this.views.remove(component);
        componentView.dispose();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.berkeley.guir.damask.view.DamaskLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((layer = (DamaskLayer)DamaskAppUtils.getAncestor(this, clazz)) != null) {
            if (componentView instanceof CheckBoxGroup || componentView instanceof RadioButtonGroup || componentView instanceof Button) {
                layer.removeSelectableParent(componentView);
            }
            if (component instanceof Control) {
                Iterator i = ((Control)component).getPatternInstanceMemberships().iterator();
                while (i.hasNext()) {
                    PatternInstance instance = (PatternInstance)i.next();
                    PatternInstanceView instanceView = (PatternInstanceView)layer.getView(instance);
                    if (instanceView == null) continue;
                    instanceView.removeMemberView(componentView);
                }
            }
        }
        return componentView;
    }

    protected void addTemplate(Page newTemplate) {
        if (newTemplate != null) {
            if (this.viewsFromTemplate.get(newTemplate) == null) {
                this.viewsFromTemplate.put(newTemplate, new ArrayList());
            }
            PageRegion region = (PageRegion)this.getModel();
            PageRegion templateRegion = newTemplate.getRegion(region.getName());
            Iterator i = templateRegion.getControls().iterator();
            while (i.hasNext()) {
                Control control = (Control)i.next();
                ControlView controlView = this.addViewForTemplateControl(newTemplate, control);
                controlView.setSelectable(false);
                if (!this.grayOutTemplateElements) continue;
                DamaskAppUtils.setInternalStroke(controlView, TEMPLATE_CONTROLS_STROKE);
            }
            templateRegion.addElementContainerListener(this.templateHandler);
        }
    }

    protected void removeTemplate(Page oldTemplate) {
        if (oldTemplate != null) {
            PageRegion region = (PageRegion)this.getModel();
            PageRegion templateRegion = oldTemplate.getRegion(region.getName());
            List templateControlViews = (List)this.viewsFromTemplate.get(oldTemplate);
            Iterator i = templateControlViews.iterator();
            while (i.hasNext()) {
                ControlView controlView = (ControlView)i.next();
                this.removeChild(controlView);
                --this.firstNormalChildIndex;
                --this.firstGroupIndex;
            }
            templateControlViews.clear();
            templateRegion.removeElementContainerListener(this.templateHandler);
        }
    }

    public boolean isInRunMode() {
        return this.inRunMode;
    }

    public void setInRunMode(boolean flag) {
        this.inRunMode = flag;
        Iterator j = this.getChildrenIterator();
        while (j.hasNext()) {
            Object child = j.next();
            if (!(child instanceof ComponentView)) continue;
            ((ComponentView)child).setInRunMode(flag);
        }
    }

    public int getInset() {
        return this.inset;
    }

    public void setInset(int inset) {
        this.inset = inset;
    }

    protected void paint(PPaintContext paintContext) {
        if (!this.isInRunMode() && paintContext.getScale() >= DamaskCanvas.scaleFactor(5) - 0.02) {
            Graphics2D g2 = paintContext.getGraphics();
            Paint oldPaint = g2.getPaint();
            DeviceType deviceType = this.getDeviceType();
            g2.setPaint(GRID_COLOR);
            if (deviceType.getGridWidth() > 0) {
                int x = 0;
                while ((double)x <= this.getWidth()) {
                    g2.drawLine(x, 0, x, (int)this.getHeight());
                    x += deviceType.getGridWidth();
                }
            }
            if (deviceType.getGridHeight() > 0) {
                int y = 0;
                while ((double)y <= this.getHeight()) {
                    g2.drawLine(0, y, (int)this.getWidth(), y);
                    y += deviceType.getGridHeight();
                }
            }
            g2.setPaint(oldPaint);
        }
        this.clipPaint(paintContext);
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
        this.clipPaintAfterChildren(paintContext);
    }

    public boolean fullPick(PPickPath pickPath) {
        return this.clipFullPick(pickPath);
    }

    private class PageRegionHandler
    implements ElementContainerListener {
        PageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            PageRegionView.this.addViewForNormalControl(e.getIndex(), (Control)e.getElement());
        }

        public void elementRemoved(ElementContainerEvent e) {
            PageRegionView.this.removeViewForComponent((Control)e.getElement());
        }
    }

    private class TemplatePageRegionHandler
    implements ElementContainerListener {
        TemplatePageRegionHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            PageRegionView.this.addViewForTemplateControl(((PageRegion)e.getSource()).getPage(), e.getIndex(), (Control)e.getElement());
        }

        public void elementRemoved(ElementContainerEvent e) {
            PageRegionView.this.removeViewForTemplateControl(((PageRegion)e.getSource()).getPage(), (Control)e.getElement());
        }
    }

    private class DialogHandler
    implements ElementContainerListener {
        DialogHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            ComponentGroup group;
            if (e.getElement() instanceof ComponentGroup && (group = (ComponentGroup)e.getElement()).getDeviceTypesVisibleTo().contains(PageRegionView.this.getDeviceType()) && group.getTransformInPageRegion((PageRegion)PageRegionView.this.getModel()) != null) {
                PageRegionView.this.addViewForGroup(group);
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            ComponentGroup group;
            if (e.getElement() instanceof ComponentGroup && (group = (ComponentGroup)e.getElement()).getDeviceTypesVisibleTo().contains(PageRegionView.this.getDeviceType()) && group.getTransformInPageRegion((PageRegion)PageRegionView.this.getModel()) != null) {
                PageRegionView.this.removeViewForGroup(group);
            }
        }
    }

    private class ElementHandler
    implements InteractionElementListener {
        ElementHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            PageRegionView.this.setInset(((PageRegion)PageRegionView.this.getModel()).getInset());
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            PageRegionView.this.setInset(((PageRegion)PageRegionView.this.getModel()).getInset());
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class BasicInputEventHandler
    extends PBasicInputEventHandler {
        BasicInputEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            VisualCanvas canvas;
            if (event.getComponent() instanceof VisualCanvas && !(canvas = (VisualCanvas)event.getComponent()).isWindowBoundsChanging()) {
                canvas.setSelectedPageRegionView(PageRegionView.this);
                this.updateHandles(event);
            }
        }

        private void updateHandles(PInputEvent event) {
            if (event.getComponent() instanceof VisualCanvas) {
                ((VisualCanvas)event.getComponent()).attachHandles(PageRegionView.this.getPageView(), event.getCamera());
            }
        }
    }
}

