/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.dialog;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.DialogEvent;
import edu.berkeley.guir.damask.event.DialogListener;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.Iterator;

public class DialogView
extends InteractionElementView {
    private final DialogHandler dialogListener = new DialogHandler();
    private int designTimeCondition = 0;
    private boolean pageContentsSelectable = false;

    public DialogView(Dialog dialog) {
        super(dialog);
        dialog.addElementContainerListener(this.dialogListener);
        dialog.addInteractionElementListener(this.dialogListener);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Iterator i = ((Dialog)this.getModel()).getPages(this.getDeviceType()).iterator();
        while (i.hasNext()) {
            Page p = (Page)i.next();
            this.addChild(new PageView(p));
        }
    }

    public void dispose() {
        super.dispose();
        Dialog dialog = (Dialog)this.getModel();
        dialog.removeElementContainerListener(this.dialogListener);
        dialog.removeInteractionElementListener(this.dialogListener);
    }

    public DeviceType getDeviceType() {
        DamaskLayer layer = this.getLayer();
        if (layer != null) {
            return layer.getDeviceType();
        }
        return null;
    }

    public boolean isContentsSelectable() {
        return this.pageContentsSelectable;
    }

    public void setContentsSelectable(boolean selectable) {
        this.pageContentsSelectable = selectable;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PageView pView = (PageView)i.next();
            pView.setContentsSelectable(selectable);
        }
    }

    public int getDesignTimeCondition() {
        return this.designTimeCondition;
    }

    private void setDesignTimeCondition(int condition) {
        Dialog dialog = (Dialog)this.getModel();
        if (condition >= dialog.getNumConditions()) {
            throw new IllegalArgumentException();
        }
        this.designTimeCondition = condition;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof PageView)) continue;
            PageView pageView = (PageView)child;
            pageView.setDesignTimeCondition(condition);
        }
    }

    public void deviceTypeLayerChanged() {
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode dialogChild = (PNode)i.next();
            if (!(dialogChild instanceof PageView)) continue;
            ((PageView)dialogChild).deviceTypeLayerChanged();
        }
    }

    private final class DialogHandler
    implements ElementContainerListener,
    DialogListener,
    InteractionElementListener {
        DialogHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Page p;
            if (e.getElement() instanceof Page && (p = (Page)e.getElement()).getDeviceType() == DialogView.this.getDeviceType()) {
                DialogView.this.addChild(new PageView(p));
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            Page p;
            if (e.getElement() instanceof Page && (p = (Page)e.getElement()).getDeviceType() == DialogView.this.getDeviceType()) {
                Iterator i = new ArrayList(DialogView.this.getChildrenReference()).iterator();
                while (i.hasNext()) {
                    PageView pageView;
                    PNode n = (PNode)i.next();
                    if (!(n instanceof PageView) || (pageView = (PageView)n).getModel() != p) continue;
                    DialogView.this.removeChild(pageView);
                    pageView.dispose();
                }
            }
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void initialConditionChanged(DialogEvent e) {
            DialogView.this.setDesignTimeCondition((Integer)e.getValue());
        }
    }
}

