/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TextBox
extends ControlView {
    private static final int DEFAULT_WIDTH = 120;
    private static final int DEFAULT_HEIGHT = 25;
    private PText text = new PText();

    public TextBox(TextInput textInput) {
        super((Control)textInput, new RunModeEventHandler());
        this.setStrokePaint(Color.BLACK);
        this.setPaint(DamaskAppUtils.NO_COLOR);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DeviceType deviceType = this.getDeviceType();
        TextInput textInput = (TextInput)this.getModel();
        this.setPathTo(textInput.getBorder(deviceType));
        Rectangle2D bounds = this.getModel().getBounds(deviceType);
        if (bounds != null) {
            this.setBounds(bounds);
        }
        this.addChild(this.text);
        this.text.setPickable(false);
        this.text.setBounds(this.getBounds());
    }

    public Object getState() {
        return this.text.getText();
    }

    public void setState(Object state) {
        this.text.setText((String)state);
    }

    public static PNode createTempView() {
        PPath border = new PPath(new Rectangle2D.Double(0.0, 0.0, 120.0, 25.0));
        return border;
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return null;
    }

    protected void paint(PPaintContext paintContext) {
        this.clipPaint(paintContext);
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
        this.clipPaintAfterChildren(paintContext);
    }

    public boolean fullPick(PPickPath pickPath) {
        return this.clipFullPick(pickPath);
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            if (event.getPickedNode() instanceof TextBox) {
                TextBox textBox = (TextBox)event.getPickedNode();
                JTextField textField = new JTextField();
                textField.setText((String)textBox.getState());
                PBounds textBoxScreenBds = textBox.getBounds();
                textBox.localToGlobal(textBoxScreenBds);
                event.getTopCamera().viewToLocal(textBoxScreenBds);
                textField.setLocation((int)((RectangularShape)textBoxScreenBds).getX(), (int)((RectangularShape)textBoxScreenBds).getY());
                textField.setSize((int)((RectangularShape)textBoxScreenBds).getWidth(), (int)((RectangularShape)textBoxScreenBds).getHeight());
                textField.setText((String)textBox.getState());
                ((JComponent)((Object)event.getComponent())).add(textField);
                textField.addFocusListener(new TextFieldFocusHandler(textBox));
            }
        }
    }

    private static class TextFieldFocusHandler
    implements FocusListener {
        private final TextBox textBox;

        public TextFieldFocusHandler(TextBox textBox) {
            this.textBox = textBox;
        }

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            JTextField textField = (JTextField)event.getComponent();
            VisualCanvas canvas = (VisualCanvas)textField.getParent();
            canvas.setControlState((Control)this.textBox.getModel(), textField.getText());
            canvas.remove(textField);
            canvas.repaint();
        }
    }
}

