/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.visual.component.ListBox;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

class ScrollBar
extends PPath {
    public static int WIDTH;
    protected static int BUTTON_SIZE;
    protected static int SHAFT_JUMP;
    private final UpButton upButton = new UpButton();
    private final DownButton downButton = new DownButton();
    private final Elevator elevator = new Elevator();
    private final ListBox listBox;
    private boolean inRunMode = false;
    private final PInputEventListener runModeEventHandler = new RunModeEventHandler();
    private boolean shaftHasFocus = false;

    static {
        BUTTON_SIZE = WIDTH = 20;
        SHAFT_JUMP = 5;
    }

    public ScrollBar(ListBox listBox) {
        this.setStrokePaint(Color.BLACK);
        this.setPaint(Color.LIGHT_GRAY);
        this.listBox = listBox;
        this.addChild(this.upButton);
        this.addChild(this.downButton);
        this.addChild(this.elevator);
    }

    public ListBox getListBox() {
        return this.listBox;
    }

    public void setInRunMode(boolean flag) {
        this.inRunMode = flag;
        this.upButton.setInRunMode(flag);
        this.downButton.setInRunMode(flag);
        this.elevator.setInRunMode(flag);
        if (this.inRunMode) {
            this.addInputEventListener(this.runModeEventHandler);
        } else {
            this.removeInputEventListener(this.runModeEventHandler);
        }
    }

    protected UpButton getUpButton() {
        return this.upButton;
    }

    protected DownButton getDownButton() {
        return this.downButton;
    }

    protected Elevator getElevator() {
        return this.elevator;
    }

    protected double getShaftHeight() {
        return this.getHeight() - (double)(2 * BUTTON_SIZE);
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        private int numScrollLines;

        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            if (event.getPickedNode() instanceof ScrollBar) {
                ScrollBar scrollBar = (ScrollBar)event.getPickedNode();
                Point2D position = event.getPositionRelativeTo(scrollBar);
                PBounds elevatorBounds = scrollBar.elevator.getBounds();
                scrollBar.elevator.localToGlobal(elevatorBounds);
                scrollBar.globalToLocal(elevatorBounds);
                this.numScrollLines = position.getY() < ((RectangularShape)elevatorBounds).getY() ? SHAFT_JUMP : -SHAFT_JUMP;
                scrollBar.getListBox().doScrollActivity(this.numScrollLines);
                scrollBar.shaftHasFocus = true;
            }
        }

        public void mouseReleased(PInputEvent event) {
            if (event.getPickedNode() instanceof ScrollBar) {
                ScrollBar scrollBar = (ScrollBar)event.getPickedNode();
                scrollBar.getListBox().doScrollActivity(0);
                scrollBar.shaftHasFocus = false;
            }
        }

        public void mouseEntered(PInputEvent event) {
            ScrollBar scrollBar;
            if (event.getPickedNode() instanceof ScrollBar && (scrollBar = (ScrollBar)event.getPickedNode()).shaftHasFocus) {
                scrollBar.getListBox().doScrollActivity(this.numScrollLines);
            }
        }

        public void mouseExited(PInputEvent event) {
            ScrollBar scrollBar;
            if (event.getPickedNode() instanceof ScrollBar && (scrollBar = (ScrollBar)event.getPickedNode()).shaftHasFocus) {
                scrollBar.getListBox().doScrollActivity(0);
            }
        }
    }

    protected static class UpButton
    extends PPath {
        private final PPath upArrow;
        private final PInputEventListener runModeEventHandler = new RunModeEventHandler();
        private boolean hasFocus = false;

        public UpButton() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, BUTTON_SIZE, BUTTON_SIZE));
            this.setPaint(Color.WHITE);
            GeneralPath upArrowPath = new GeneralPath();
            upArrowPath.moveTo(BUTTON_SIZE / 2, 0.0f);
            upArrowPath.lineTo(BUTTON_SIZE - 5, BUTTON_SIZE / 3);
            upArrowPath.lineTo(5.0f, BUTTON_SIZE / 3);
            upArrowPath.closePath();
            this.upArrow = new PPath(upArrowPath);
            this.upArrow.setPaint(Color.BLACK);
            this.upArrow.setPickable(false);
            this.addChild(this.upArrow);
            this.upArrow.setOffset(0.0, BUTTON_SIZE / 3);
        }

        public ScrollBar getScrollBar() {
            return (ScrollBar)this.getParent();
        }

        public void setInRunMode(boolean inRunMode) {
            if (inRunMode) {
                this.addInputEventListener(this.runModeEventHandler);
            } else {
                this.removeInputEventListener(this.runModeEventHandler);
            }
        }

        public void setActive(boolean flag) {
            if (flag) {
                this.setPaint(Color.BLACK);
                this.upArrow.setStrokePaint(Color.WHITE);
                this.upArrow.setPaint(Color.WHITE);
                this.getScrollBar().getListBox().doScrollActivity(1);
            } else {
                this.setPaint(Color.WHITE);
                this.upArrow.setStrokePaint(Color.BLACK);
                this.upArrow.setPaint(Color.BLACK);
                this.getScrollBar().getListBox().doScrollActivity(0);
            }
        }

        private static class RunModeEventHandler
        extends PBasicInputEventHandler {
            RunModeEventHandler() {
            }

            public void mousePressed(PInputEvent event) {
                UpButton upButton = (UpButton)event.getPickedNode();
                upButton.setActive(true);
                upButton.hasFocus = true;
            }

            public void mouseReleased(PInputEvent event) {
                UpButton upButton = (UpButton)event.getPickedNode();
                upButton.setActive(false);
                upButton.hasFocus = false;
                if (event.getComponent() instanceof DamaskCanvas) {
                    ListBox listBox = upButton.getScrollBar().getListBox();
                    listBox.setItemModelsTransforms();
                }
            }

            public void mouseEntered(PInputEvent event) {
                UpButton upButton = (UpButton)event.getPickedNode();
                if (upButton.hasFocus) {
                    upButton.setActive(true);
                }
            }

            public void mouseExited(PInputEvent event) {
                UpButton upButton = (UpButton)event.getPickedNode();
                if (upButton.hasFocus) {
                    upButton.setActive(false);
                }
            }
        }
    }

    protected static class DownButton
    extends PPath {
        private final PPath downArrow;
        private final PInputEventListener runModeEventHandler = new RunModeEventHandler();
        private boolean hasFocus = false;

        public DownButton() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, BUTTON_SIZE, BUTTON_SIZE));
            this.setPaint(Color.WHITE);
            GeneralPath downArrowPath = new GeneralPath();
            downArrowPath.moveTo(BUTTON_SIZE / 2, BUTTON_SIZE / 3);
            downArrowPath.lineTo(BUTTON_SIZE - 5, 0.0f);
            downArrowPath.lineTo(5.0f, 0.0f);
            downArrowPath.closePath();
            this.downArrow = new PPath(downArrowPath);
            this.downArrow.setPaint(Color.BLACK);
            this.downArrow.setPickable(false);
            this.addChild(this.downArrow);
            this.downArrow.setOffset(0.0, BUTTON_SIZE / 3);
        }

        public ScrollBar getScrollBar() {
            return (ScrollBar)this.getParent();
        }

        public void setInRunMode(boolean inRunMode) {
            if (inRunMode) {
                this.addInputEventListener(this.runModeEventHandler);
            } else {
                this.removeInputEventListener(this.runModeEventHandler);
            }
        }

        public void setActive(boolean flag) {
            if (flag) {
                this.setPaint(Color.BLACK);
                this.downArrow.setStrokePaint(Color.WHITE);
                this.downArrow.setPaint(Color.WHITE);
                this.getScrollBar().getListBox().doScrollActivity(-1);
            } else {
                this.setPaint(Color.WHITE);
                this.downArrow.setStrokePaint(Color.BLACK);
                this.downArrow.setPaint(Color.BLACK);
                this.getScrollBar().getListBox().doScrollActivity(0);
            }
        }

        private static class RunModeEventHandler
        extends PBasicInputEventHandler {
            RunModeEventHandler() {
            }

            public void mousePressed(PInputEvent event) {
                DownButton downButton = (DownButton)event.getPickedNode();
                downButton.setActive(true);
                downButton.hasFocus = true;
            }

            public void mouseReleased(PInputEvent event) {
                DownButton downButton = (DownButton)event.getPickedNode();
                downButton.setActive(false);
                downButton.hasFocus = false;
                if (event.getComponent() instanceof DamaskCanvas) {
                    ListBox listBox = downButton.getScrollBar().getListBox();
                    listBox.setItemModelsTransforms();
                }
            }

            public void mouseEntered(PInputEvent event) {
                DownButton downButton = (DownButton)event.getPickedNode();
                if (downButton.hasFocus) {
                    downButton.setActive(true);
                }
            }

            public void mouseExited(PInputEvent event) {
                DownButton downButton = (DownButton)event.getPickedNode();
                if (downButton.hasFocus) {
                    downButton.setActive(false);
                }
            }
        }
    }

    protected static class Elevator
    extends PPath {
        private final PInputEventListener runModeEventHandler = new RunModeEventHandler();
        public static final int MIN_HEIGHT = 4;
        private static final int MIN_HEIGHT_WITH_GRIP_LINES = 13;
        private static final int GRIP_LINES_GAP = 3;
        private boolean focus = false;

        public Elevator() {
            this.setStrokePaint(Color.BLACK);
            this.setPaint(Color.WHITE);
            int i = -1;
            while (i <= 1) {
                PPath gripLine = new PPath();
                gripLine.setPickable(false);
                this.addChild(gripLine);
                ++i;
            }
        }

        public ScrollBar getScrollBar() {
            return (ScrollBar)this.getParent();
        }

        protected void layoutChildren() {
            Iterator it = this.getChildrenIterator();
            int i = -1;
            while (i <= 1) {
                PPath grip = (PPath)it.next();
                grip.setPathTo(new Line2D.Double(WIDTH / 3, this.getHeight() / 2.0 + (double)(i * 3), WIDTH * 2 / 3, this.getHeight() / 2.0 + (double)(i * 3)));
                grip.setVisible(this.getHeight() >= 13.0);
                ++i;
            }
        }

        public void setInRunMode(boolean inRunMode) {
            if (inRunMode) {
                this.addInputEventListener(this.runModeEventHandler);
            } else {
                this.removeInputEventListener(this.runModeEventHandler);
            }
        }

        public boolean hasFocus() {
            return this.focus;
        }

        private static class RunModeEventHandler
        extends PBasicInputEventHandler {
            private Point2D lastPosition;
            private Point2D lastScrollPosition;
            private double dyToScroll1Line;

            RunModeEventHandler() {
            }

            public void mousePressed(PInputEvent event) {
                Elevator elevator = (Elevator)event.getPickedNode();
                ScrollBar scrollBar = elevator.getScrollBar();
                elevator.focus = true;
                double childrenHeight = scrollBar.getListBox().getLastItemMaxY() - scrollBar.getListBox().getFirstItemMinY();
                this.dyToScroll1Line = scrollBar.getShaftHeight() * (double)ListBox.DEFAULT_LINE_HEIGHT / childrenHeight;
                this.lastPosition = event.getPosition();
                this.lastScrollPosition = event.getPosition();
            }

            public void mouseDragged(PInputEvent event) {
                Elevator elevator = (Elevator)event.getPickedNode();
                Point2D currentPosition = event.getPosition();
                double dySinceLastScroll = this.lastScrollPosition.getY() - currentPosition.getY();
                if (Math.abs(dySinceLastScroll) >= this.dyToScroll1Line) {
                    int dLines = (int)(dySinceLastScroll / this.dyToScroll1Line);
                    elevator.getScrollBar().getListBox().scrollItems(dLines);
                    this.lastScrollPosition = currentPosition;
                }
                this.lastPosition = event.getPosition();
            }

            public void mouseReleased(PInputEvent event) {
                Elevator elevator = (Elevator)event.getPickedNode();
                elevator.focus = false;
            }
        }
    }
}

