/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.umd.cs.piccolo.PNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RadioButtonGroup
extends ControlView {
    private final RadioButtonHandler radioButtonHandler = new RadioButtonHandler();
    private final Map views = new HashMap();
    private SelectOne.Item selectedItem;
    private boolean childrenSelectable = true;

    public RadioButtonGroup(SelectOne selectOne) {
        super(selectOne);
        selectOne.addElementContainerListener(this.radioButtonHandler);
        super.setSelectable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Iterator i = ((SelectOne)this.getModel()).getItems().iterator();
        while (i.hasNext()) {
            SelectOne.Item selectOneItem = (SelectOne.Item)i.next();
            RadioButton radioButton = new RadioButton(selectOneItem);
            this.addChild(radioButton);
            radioButton.setInRunMode(this.isInRunMode());
            this.views.put(selectOneItem, radioButton);
        }
    }

    public void dispose() {
        super.dispose();
        ((SelectOne)this.getModel()).removeElementContainerListener(this.radioButtonHandler);
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            RadioButton radioButton = (RadioButton)i.next();
            radioButton.setInRunMode(flag);
        }
    }

    public void setSelectable(boolean flag) {
        this.childrenSelectable = flag;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof RadioButton)) continue;
            ((RadioButton)child).setSelectable(flag);
        }
    }

    public void setPickable(boolean flag) {
        super.setPickable(flag);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            child.setPickable(flag);
        }
    }

    public Object getState() {
        return this.selectedItem;
    }

    public void setState(Object state) {
        this.selectedItem = (SelectOne.Item)state;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            RadioButton radioButton = (RadioButton)i.next();
            if (state == radioButton.getModel()) {
                radioButton.setChecked(true);
                continue;
            }
            radioButton.setChecked(false);
        }
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return null;
    }

    public class RadioButtonHandler
    implements ElementContainerListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.component.RadioButtonGroup$RadioButtonHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public void elementAdded(ElementContainerEvent e) {
            SelectOne.Item selectOneItem = (SelectOne.Item)e.getElement();
            RadioButton radioButton = new RadioButton(selectOneItem);
            RadioButtonGroup.this.addChild(radioButton);
            radioButton.setInRunMode(RadioButtonGroup.this.isInRunMode());
            radioButton.setSelectable(RadioButtonGroup.this.childrenSelectable);
            radioButton.setPickable(RadioButtonGroup.this.getPickable());
            RadioButtonGroup.this.views.put(selectOneItem, radioButton);
        }

        public void elementRemoved(ElementContainerEvent e) {
            InteractionElement element = e.getElement();
            PNode elementView = (PNode)RadioButtonGroup.this.views.get(element);
            if (!$assertionsDisabled && !(elementView instanceof RadioButton)) {
                throw new AssertionError((Object)("elementView must be a radio button, not " + elementView));
            }
            elementView.removeFromParent();
            RadioButtonGroup.this.views.remove(element);
        }
    }
}

