/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.RadioButtonGroup;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;

public class RadioButton
extends ControlView {
    private static final int CIRCLE_DIAMETER = 15;
    private static final int SOLID_CIRCLE_DIAMETER = 7;
    private static final int GAP = 8;
    private Label caption;
    private final PPath circleOutline = new PPath();
    private final PPath solidCircle = new PPath();
    private boolean checked = false;

    public RadioButton(SelectOne.Item selectOneItem) {
        super((Control)selectOneItem, new RunModeEventHandler());
        this.setResizable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        SelectOne.Item selectOneItem = (SelectOne.Item)this.getModel();
        this.circleOutline.setPathTo(new Ellipse2D.Double(0.0, 0.0, 15.0, 15.0));
        this.circleOutline.setPickable(false);
        this.addChild(this.circleOutline);
        this.caption = new Label(selectOneItem.getContent());
        this.caption.setPickable(false);
        this.addChild(this.caption);
        this.solidCircle.setPathTo(new Ellipse2D.Double(4.0, 4.0, 7.0, 7.0));
        this.solidCircle.setPickable(false);
        this.solidCircle.setPaint(Color.BLACK);
        PageView pageView = this.getPageView();
        if (pageView != null) {
            Dialog controlDialog;
            SelectOne selectOne = (SelectOne)selectOneItem.getParent();
            Dialog pageDialog = ((Page)pageView.getModel()).getDialog();
            int condition = pageDialog == (controlDialog = selectOneItem.getDialog()) ? pageView.getDesignTimeCondition() : controlDialog.getInitialCondition();
            Object state = selectOne.getStateForCondition(controlDialog, condition);
            this.setChecked(state == selectOneItem);
        }
    }

    public Object getState() {
        return this.checked;
    }

    public void setState(Object state) {
        boolean flag = (Boolean)state;
        RadioButtonGroup group = (RadioButtonGroup)this.getParent();
        if (flag) {
            group.setState(this);
        } else {
            group.setState(null);
        }
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return this.caption;
    }

    protected void setChecked(boolean state) {
        if (this.checked != state) {
            this.checked = state;
            if (this.checked) {
                this.addChild(this.solidCircle);
            } else {
                this.removeChild(this.solidCircle);
            }
        }
    }

    public static PNode createTempView() {
        PNode parentNode = new PNode();
        PPath radioButton = new PPath(new Ellipse2D.Double(0.0, 0.0, 15.0, 15.0));
        PPath squiggle = DamaskAppUtils.createSquiggle();
        squiggle.setOffset(23.0, 0.0);
        parentNode.addChild(radioButton);
        parentNode.addChild(squiggle);
        parentNode.setBounds(0.0, 0.0, 23.0 + squiggle.getWidth(), 15.0);
        return parentNode;
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            RadioButton radioButton = (RadioButton)event.getPickedNode();
            radioButton.circleOutline.setPaint(Color.LIGHT_GRAY);
            container.setFocus(radioButton);
        }

        public void mouseReleased(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            RadioButton radioButton = (RadioButton)event.getPickedNode();
            if (container.getFocus() == radioButton) {
                radioButton.circleOutline.setPaint(DamaskAppUtils.NO_COLOR);
                SelectOne.Item selectOneItem = (SelectOne.Item)radioButton.getModel();
                RadioButtonGroup group = (RadioButtonGroup)radioButton.getParent();
                container.setControlState((Control)group.getModel(), radioButton.getModel());
                DeviceType deviceType = radioButton.getDeviceType();
                NavConnection connection = selectOneItem.getOutConnection(radioButton.getDeviceType(), new InvokeEvent(selectOneItem), container.getSelectedPageCondition());
                if (connection != null) {
                    container.goToPage(connection.getDest(deviceType).getPage(deviceType));
                }
            }
        }

        public void mouseEntered(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            RadioButton radioButton = (RadioButton)event.getPickedNode();
            if (container.getFocus() == radioButton) {
                radioButton.circleOutline.setPaint(Color.LIGHT_GRAY);
            }
        }

        public void mouseExited(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            RadioButton radioButton = (RadioButton)event.getPickedNode();
            if (container.getFocus() == radioButton) {
                radioButton.circleOutline.setPaint(DamaskAppUtils.NO_COLOR);
            }
        }
    }
}

