/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.ScrollBar;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ListBox
extends ControlView {
    private static final int DEFAULT_WIDTH = 100;
    protected static final int DEFAULT_LINE_HEIGHT = (int)DamaskAppUtils.getRenderedTextBounds("AAA", DamaskAppUtils.getDefaultFont().getSize()).getHeight();
    private static final int DEFAULT_NUM_LINES = 3;
    private static final int DEFAULT_HEIGHT = DEFAULT_LINE_HEIGHT * 3;
    private SelectOne.Item selectedItem;
    private Label highlightedLabel;
    private final Map itemToLabel = new HashMap();
    private final Map labelToItem = new HashMap();
    private final PNode items = new PNode();
    private final PPath highlightBar = new PPath();
    private final ScrollBar scrollBar = new ScrollBar(this);
    private final ScrollActivity scrollActivity = new ScrollActivity(-1L);
    private final ItemHandler itemHandler = new ItemHandler();

    public ListBox(SelectOne selectOne) {
        this(selectOne, true);
    }

    public ListBox(SelectOne selectOne, boolean useDefaultElementListener) {
        super(selectOne, new RunModeEventHandler(), useDefaultElementListener);
        this.setStretchedWhenResized(false);
        selectOne.addElementContainerListener(this.itemHandler);
        this.setStrokePaint(Color.BLACK);
        this.setPaint(Color.WHITE);
        this.highlightBar.setPaint(Color.BLACK);
        this.highlightBar.setVisible(false);
        this.highlightBar.setPickable(false);
        this.addChild(this.highlightBar);
        this.addChild(this.items);
        this.addChild(this.scrollBar);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DeviceType deviceType = this.getDeviceType();
        SelectOne selectOne = (SelectOne)this.getModel();
        this.setPathTo(selectOne.getBounds(deviceType));
        Iterator i = selectOne.getItems().iterator();
        while (i.hasNext()) {
            SelectOne.Item item = (SelectOne.Item)i.next();
            this.addItem(item);
        }
        PageView pageView = this.getPageView();
        if (pageView != null) {
            Dialog controlDialog;
            Dialog pageDialog = ((Page)pageView.getModel()).getDialog();
            int condition = pageDialog == (controlDialog = selectOne.getDialog()) ? pageView.getDesignTimeCondition() : controlDialog.getInitialCondition();
            this.setState(selectOne.getStateForCondition(controlDialog, condition));
        }
    }

    public Object getEditableContents() {
        return this.items.getChildrenReference();
    }

    public Object getState() {
        return this.selectedItem;
    }

    public void setState(Object state) {
        this.selectedItem = (SelectOne.Item)state;
        this.highlightLabel((Label)this.itemToLabel.get(this.selectedItem));
    }

    protected Label getSelectedLabel() {
        return this.highlightedLabel;
    }

    protected void highlightLabel(Label label) {
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setLabelColor(Color.BLACK);
        }
        this.highlightedLabel = label;
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setLabelColor(Color.WHITE);
            PBounds labelBounds = this.highlightedLabel.getFullBounds();
            this.highlightBar.setVisible(true);
            this.highlightBar.setPathTo(new Rectangle2D.Double(((RectangularShape)labelBounds).getX(), ((RectangularShape)labelBounds).getY(), this.getWidth(), ((RectangularShape)labelBounds).getHeight()));
        }
    }

    public Label getLabelAt(Point2D pt) {
        Iterator i = this.items.getChildrenIterator();
        while (i.hasNext()) {
            Label label;
            PBounds labelBounds;
            PNode node = (PNode)i.next();
            if (!(node instanceof Label) || !(((RectangularShape)(labelBounds = (label = (Label)node).getFullBounds())).getY() <= pt.getY()) || !(pt.getY() <= ((RectangularShape)labelBounds).getY() + ((RectangularShape)labelBounds).getHeight())) continue;
            return label;
        }
        return null;
    }

    public SelectOne.Item getItemAt(Point2D pt) {
        Label label = this.getLabelAt(pt);
        if (label == null) {
            return null;
        }
        return (SelectOne.Item)this.labelToItem.get(label);
    }

    protected PNode getItems() {
        return this.items;
    }

    protected int getItemCount() {
        return this.items.getChildrenCount();
    }

    protected void addItem(SelectOne.Item item) {
        this.addItem(this.getItemCount(), item);
    }

    protected void addItem(int index, SelectOne.Item item) {
        Label label = new Label(item.getContent());
        this.items.addChild(index, label);
        label.setBounds(item.getBounds(this.getDeviceType()));
        label.setTransform(item.getTransform(this.getDeviceType()));
        label.setPickable(false);
        item.addInteractionElementListener(label.getElementHandler());
        this.itemToLabel.put(item, label);
        this.labelToItem.put(label, item);
    }

    protected void removeItem(SelectOne.Item item) {
        Label label = (Label)this.itemToLabel.get(item);
        item.removeInteractionElementListener(label.getElementHandler());
        label.removeFromParent();
        this.itemToLabel.remove(item);
        this.labelToItem.remove(label);
    }

    public static PNode createTempView() {
        PPath border = new PPath(new Rectangle2D.Double(0.0, 0.0, 100.0, DEFAULT_HEIGHT));
        int[][] itemSquiggleLengths = new int[][]{{4, 3, 5}, {6, 7}, {3, 6, 5}};
        int i = 0;
        int n = itemSquiggleLengths.length;
        while (i < n) {
            PNode squiggles = DamaskAppUtils.createSquiggles(itemSquiggleLengths[i]);
            border.addChild(squiggles);
            double oldHeight = squiggles.getHeight();
            squiggles.setBounds(0.0, 0.0, squiggles.getWidth(), DEFAULT_LINE_HEIGHT);
            squiggles.setOffset(0.0, i * DEFAULT_LINE_HEIGHT);
            if (oldHeight < (double)DEFAULT_LINE_HEIGHT) {
                AffineTransform centeringTransform = AffineTransform.getTranslateInstance(0.0, ((double)DEFAULT_LINE_HEIGHT - oldHeight) / 2.0);
                Iterator j = squiggles.getChildrenIterator();
                while (j.hasNext()) {
                    PPath child = (PPath)j.next();
                    child.getPathReference().transform(centeringTransform);
                }
            }
            ++i;
        }
        return border;
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        this.scrollBar.setInRunMode(flag);
    }

    protected int getFirstItemMinY() {
        if (this.items.getChildrenCount() == 0) {
            return (int)this.getBounds().getMinY();
        }
        Label firstItem = (Label)this.items.getChild(0);
        PBounds firstItemBounds = firstItem.getBounds();
        firstItem.localToGlobal(firstItemBounds);
        this.globalToLocal(firstItemBounds);
        int firstItemMinY = (int)((RectangularShape)firstItemBounds).getY();
        return firstItemMinY;
    }

    protected int getLastItemMaxY() {
        if (this.items.getChildrenCount() == 0) {
            return (int)this.getBounds().getMinY();
        }
        Label lastItem = (Label)this.items.getChild(this.items.getChildrenCount() - 1);
        PBounds lastItemBounds = lastItem.getBounds();
        lastItem.localToGlobal(lastItemBounds);
        this.globalToLocal(lastItemBounds);
        int lastItemMaxY = (int)lastItemBounds.getMaxY();
        return lastItemMaxY;
    }

    protected void translateItems(int dy) {
        Iterator i = this.items.getChildrenIterator();
        while (i.hasNext()) {
            Label label = (Label)i.next();
            label.translate(0.0, dy);
        }
        this.highlightLabel(this.highlightedLabel);
    }

    protected void setItemModelsTransforms() {
        Iterator i = this.items.getChildrenIterator();
        while (i.hasNext()) {
            Label label = (Label)i.next();
            ((SelectOne.Item)this.labelToItem.get(label)).setTransform(label.getDeviceType(), label.getTransform());
        }
    }

    protected void layoutChildren() {
        if (this.getBounds().getMaxY() > (double)this.getLastItemMaxY() && this.getBounds().getY() > (double)this.getFirstItemMinY()) {
            this.translateItems((int)this.getBounds().getMaxY() - this.getLastItemMaxY());
        }
        this.scrollBar.setPathTo(new Rectangle2D.Double(0.0, 0.0, ScrollBar.WIDTH, this.getHeight()));
        this.scrollBar.setOffset(this.getWidth() - (double)ScrollBar.WIDTH, 0.0);
        double childrenHeight = this.getLastItemMaxY() - this.getFirstItemMinY();
        double firstItemMinY = this.getFirstItemMinY();
        double height = this.getHeight();
        this.scrollBar.setVisible(childrenHeight > height);
        this.scrollBar.getDownButton().setOffset(0.0, height - (double)ScrollBar.BUTTON_SIZE);
        double scrollBarShaftHeight = this.scrollBar.getShaftHeight();
        this.scrollBar.getElevator().setPathTo(new Rectangle2D.Double(0.0, 0.0, ScrollBar.WIDTH, Math.max(4.0, scrollBarShaftHeight * height / childrenHeight)));
        this.scrollBar.getElevator().setOffset(0.0, scrollBarShaftHeight * (-firstItemMinY / childrenHeight) + (double)ScrollBar.BUTTON_SIZE);
    }

    public void scrollItems(int numLines) {
        int proposedDy;
        int dy = proposedDy = numLines * DEFAULT_LINE_HEIGHT;
        if (proposedDy > 0) {
            int firstItemMinY = this.getFirstItemMinY();
            if (firstItemMinY >= 0) {
                return;
            }
            if (firstItemMinY + proposedDy > 0) {
                dy = -firstItemMinY;
            }
        } else {
            double listBoxMaxY;
            int lastItemMaxY = this.getLastItemMaxY();
            if ((double)lastItemMaxY <= (listBoxMaxY = this.getBounds().getMaxY())) {
                return;
            }
            if ((double)(lastItemMaxY + proposedDy) < listBoxMaxY) {
                dy = (int)listBoxMaxY - lastItemMaxY;
            }
        }
        this.translateItems(dy);
    }

    protected void doScrollActivity(int numLines) {
        if (numLines != 0) {
            this.scrollItems(numLines);
            this.scrollActivity.setNumLines(numLines);
            this.scrollActivity.setStartTime(this.getRoot().getGlobalTime() + 400L);
            this.getRoot().addActivity(this.scrollActivity);
        } else {
            this.scrollActivity.terminate();
        }
    }

    protected void paint(PPaintContext paintContext) {
        this.clipPaint(paintContext);
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
        this.clipPaintAfterChildren(paintContext);
    }

    public boolean fullPick(PPickPath pickPath) {
        return this.clipFullPick(pickPath);
    }

    private class ScrollActivity
    extends PActivity {
        private int numLines;

        ScrollActivity(long aDuration) {
            super(aDuration);
        }

        ScrollActivity(long aDuration, long aStepRate) {
            super(aDuration, aStepRate);
        }

        ScrollActivity(long aDuration, long aStepRate, long aStartTime) {
            super(aDuration, aStepRate, aStartTime);
        }

        protected void activityStep(long elapsedTime) {
            super.activityStep(elapsedTime);
            ListBox.this.scrollItems(this.numLines);
        }

        public void setNumLines(int numLines) {
            this.numLines = numLines;
        }
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        static /* synthetic */ Class class$0;

        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            ListBox listBox;
            Label labelToHighlight;
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            if (event.getPickedNode() instanceof ListBox && (labelToHighlight = (listBox = (ListBox)event.getPickedNode()).getLabelAt(event.getPositionRelativeTo(listBox))) != null) {
                listBox.highlightLabel(labelToHighlight);
            }
            PNode pNode = event.getPickedNode();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.component.ListBox");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            container.setFocus((ListBox)DamaskAppUtils.getAncestor(pNode, clazz));
        }

        public void mouseDragged(PInputEvent event) {
            ListBox listBox;
            Label labelToHighlight;
            if (event.getPickedNode() instanceof ListBox && (labelToHighlight = (listBox = (ListBox)event.getPickedNode()).getLabelAt(event.getPositionRelativeTo(listBox))) != null) {
                listBox.highlightLabel(labelToHighlight);
            }
        }

        public void mouseReleased(PInputEvent event) {
            if (event.getPickedNode() instanceof ListBox) {
                NavConnection connection;
                PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
                ListBox listBox = (ListBox)event.getPickedNode();
                Label labelToHighlight = listBox.getLabelAt(event.getPositionRelativeTo(listBox));
                if (labelToHighlight != null) {
                    listBox.highlightLabel(labelToHighlight);
                }
                SelectOne.Item selectOneItem = (SelectOne.Item)listBox.labelToItem.get(listBox.highlightedLabel);
                container.setControlState((SelectOne)listBox.getModel(), selectOneItem);
                DeviceType deviceType = listBox.getDeviceType();
                if (selectOneItem != null && (connection = selectOneItem.getOutConnection(listBox.getDeviceType(), new InvokeEvent(selectOneItem), container.getSelectedPageCondition())) != null) {
                    container.goToPage(connection.getDest(deviceType).getPage(deviceType));
                }
            }
        }
    }

    public class ItemHandler
    implements ElementContainerListener {
        public void elementAdded(ElementContainerEvent e) {
            SelectOne.Item item = (SelectOne.Item)e.getElement();
            ListBox.this.addItem(e.getIndex(), item);
        }

        public void elementRemoved(ElementContainerEvent e) {
            SelectOne.Item item = (SelectOne.Item)e.getElement();
            ListBox.this.removeItem(item);
        }
    }
}

