/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.EditContentCommand;
import edu.berkeley.guir.damask.command.SetContentDisplayModeCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.event.ContentEvent;
import edu.berkeley.guir.damask.event.ContentListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.appdialogs.FileDialogUtils;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.lib.satin.command.MacroCommand;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.handles.PHandle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Label
extends ControlView {
    public static final int TEXT_PADDING = 2;
    private static final int EMPTY_LABEL_WIDTH = 100;
    private static final int EMPTY_LABEL_HEIGHT = 100;
    private static final Color EMPTY_LABEL_COLOR = Color.LIGHT_GRAY;
    private static final Color STROKES_BACKGROUND = new Color(0, 255, 0, 15);
    private static final Stroke EMPTY_LABEL_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final Map EMPTY_LABEL_TEXT = new HashMap();
    private boolean empty = false;
    private final ContentHandler labelHandler = new ContentHandler();
    private final PText text = new PText();
    private final PImage image = new PImage();
    private final PNode strokes = new PNode();
    private final Map pathStrokes = new HashMap();
    private final PPath placeholder = new PPath(new Rectangle(0, 0, 100, 100));
    private final PText placeholderText = new PText();
    private static final int PLACEHOLDER_TEXT_SIZE = 18;
    private Color labelColor = Color.BLACK;
    private Content.DisplayMode displayMode;

    static {
        EMPTY_LABEL_TEXT.put(Content.INK, "Sketch\nhere");
        EMPTY_LABEL_TEXT.put(Content.TEXT, "Type\nhere");
        EMPTY_LABEL_TEXT.put(Content.IMAGE, "Click here to\ninsert image");
    }

    public Label(Content content) {
        this(content, true);
    }

    public Label(Content content, boolean autoUpdateBoundsTransform) {
        super((Control)content, autoUpdateBoundsTransform);
        content.addInteractionElementListener(this.labelHandler);
        content.addContentEventListener(this.labelHandler);
        this.text.setPickable(false);
        this.setTextString(content.getText());
        if (content.getImage() != null) {
            this.image.setImage(content.getImage());
        }
        this.image.setPickable(false);
        this.strokes.setPickable(false);
        this.placeholder.setPickable(false);
        this.placeholder.setStroke(EMPTY_LABEL_STROKE);
        this.placeholder.setStrokePaint(EMPTY_LABEL_COLOR);
        this.placeholderText.setPickable(false);
        this.placeholderText.setConstrainWidthToTextWidth(true);
        this.placeholderText.setConstrainHeightToTextHeight(true);
        DamaskAppUtils.setFontSize(this.placeholderText, 18);
        this.placeholder.addChild(this.placeholderText);
        this.addInputEventListener(new InputEventHandler());
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Content content = (Content)this.getModel();
        Rectangle2D newBounds = content.getBounds(this.getDeviceType());
        this.text.setBounds(newBounds);
        this.text.offset(2.0, 2.0);
        this.setTextSize(content.getTextSize(this.getDeviceType()));
        this.image.setBounds(newBounds);
        this.setStrokes(content.getStrokes());
        this.setDisplayMode(content.getPreferredDisplayMode(this.getDeviceType()));
    }

    public void dispose() {
        super.dispose();
        Content content = (Content)this.getModel();
        content.removeInteractionElementListener(this.labelHandler);
        content.removeContentEventListener(this.labelHandler);
    }

    public PageRegionView getPageRegionView() {
        PNode node = this.getParent();
        while (!(node instanceof PageRegionView) && node != null) {
            node = node.getParent();
        }
        return (PageRegionView)node;
    }

    public Content.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public Object getState() {
        return null;
    }

    public void setState(Object state) {
    }

    public static PNode createTempView() {
        PNode node = new PNode();
        node.addChild(new PText("Label"));
        return node;
    }

    private void showPlaceholder() {
        this.placeholderText.setText((String)EMPTY_LABEL_TEXT.get(this.displayMode));
        this.placeholderText.setTransform(AffineTransform.getTranslateInstance((this.placeholder.getWidth() - this.placeholderText.getWidth()) / 2.0, (this.placeholder.getHeight() - this.placeholderText.getHeight()) / 2.0));
        this.addChild(this.placeholder);
        this.setBounds(this.placeholder.getPathReference().getBounds2D());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void refreshContents() {
        this.empty = false;
        Iterator i = new ArrayList(this.getChildrenReference()).iterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (child instanceof PHandle) continue;
            this.removeChild(child);
        }
        this.setPaint(DamaskAppUtils.NO_COLOR);
        if (this.displayMode == Content.IMAGE) {
            if (this.image.getImage() == null) {
                this.empty = true;
            } else if (this.image.getParent() == null) {
                this.addChild(this.image);
            }
        } else if (this.displayMode == Content.TEXT) {
            if (((Content)this.getModel()).getText().length() == 0) {
                this.empty = true;
            } else if (this.text.getParent() == null) {
                this.addChild(this.text);
            }
        } else if (this.strokes.getChildrenCount() == 0) {
            this.empty = true;
        } else if (this.strokes.getParent() == null) {
            this.addChild(this.strokes);
            if (!this.isInRunMode()) {
                this.setPaint(STROKES_BACKGROUND);
            }
        }
        if (this.empty) {
            this.showPlaceholder();
        } else {
            this.setBounds(this.getModel().getBounds(this.getDeviceType()));
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        boolean inTriggerView = this.getParent() instanceof ControlView && ((ControlView)this.getParent()).getModel() instanceof Trigger;
        DeviceType deviceType = this.getDeviceType();
        boolean dontShow = false;
        if (inTriggerView) {
            Trigger trigger = (Trigger)((ControlView)this.getParent()).getModel();
            Iterator i = trigger.getOutConnections().iterator();
            while (i.hasNext()) {
                NavConnection connection = (NavConnection)i.next();
                if (!connection.isVisibleToDeviceType(deviceType) || connection.getSource(deviceType).getPage(deviceType) != connection.getDest(deviceType).getPage(deviceType)) continue;
                dontShow = true;
                break;
            }
        }
        if (!(dontShow |= this.empty && this.displayMode == Content.TEXT && inTriggerView)) {
            super.fullPaint(paintContext);
        }
    }

    public void setDisplayMode(Content.DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.refreshContents();
    }

    public PNode getStrokesContainer() {
        return this.strokes;
    }

    protected void addStroke(GeneralPath genPath) {
        Content content = (Content)this.getModel();
        Rectangle2D bounds = content.getBounds(this.getDeviceType());
        Rectangle2D fullBounds = content.getFullSizeBounds(Content.INK);
        double stretchX = fullBounds.getWidth() == 0.0 ? 1.0 : bounds.getWidth() / fullBounds.getWidth();
        double stretchY = fullBounds.getHeight() == 0.0 ? 1.0 : bounds.getHeight() / fullBounds.getHeight();
        Rectangle2D genPathBounds = genPath.getBounds2D();
        Rectangle2D.Double scaledGenPathBounds = new Rectangle2D.Double((genPathBounds.getX() - fullBounds.getX()) * stretchX + bounds.getX(), (genPathBounds.getY() - fullBounds.getY()) * stretchY + bounds.getY(), stretchX * genPathBounds.getWidth(), stretchY * genPathBounds.getHeight());
        GeneralPath scaledGenPath = (GeneralPath)genPath.clone();
        DamaskAppUtils.resizeGeneralPath(scaledGenPath, scaledGenPathBounds);
        DamaskPPath path = new DamaskPPath(scaledGenPath);
        path.setPickable(false);
        this.strokes.addChild(path);
        this.pathStrokes.put(genPath, path);
    }

    protected void removeStroke(GeneralPath genPath) {
        PNode path = (PNode)this.pathStrokes.remove(genPath);
        int index = this.strokes.indexOfChild(path);
        if (index >= 0) {
            this.strokes.removeChild(index);
        }
    }

    protected void setStrokes(Collection strokesCollection) {
        this.strokes.removeAllChildren();
        this.strokes.setTransform(new AffineTransform());
        if (!strokesCollection.isEmpty()) {
            Iterator i = strokesCollection.iterator();
            while (i.hasNext()) {
                GeneralPath genPath = (GeneralPath)i.next();
                this.addStroke(genPath);
            }
        }
    }

    public PText getText() {
        return this.text;
    }

    protected void setTextString(String newString) {
        this.text.setText(newString);
    }

    protected void setTextSize(int size) {
        DamaskAppUtils.setFontSize(this.getText(), size);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.text.setPaint(color);
        Iterator i = this.strokes.getChildrenIterator();
        while (i.hasNext()) {
            DamaskPPath stroke = (DamaskPPath)i.next();
            stroke.setStrokePaint(color);
        }
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        if (this.displayMode == Content.INK) {
            if (!flag) {
                this.setPaint(STROKES_BACKGROUND);
            } else {
                this.setPaint(DamaskAppUtils.NO_COLOR);
            }
        }
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return this;
    }

    public Dimension2D getEmptySize() {
        return new PDimension(this.placeholder.getWidth(), this.placeholder.getHeight());
    }

    public void setEmptySize(Dimension2D size) {
        this.placeholder.setPathTo(new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight()));
    }

    public void tryToChangeImage(DamaskCanvas canvas) {
        File imageFile = FileDialogUtils.showImageOpenDialog(canvas);
        if (imageFile != null) {
            try {
                BufferedImage newImage = ImageIO.read(imageFile);
                MacroCommand cmd = new MacroCommand();
                Content content = (Content)this.getModel();
                cmd.addCommand(new EditContentCommand(content, newImage));
                cmd.addCommand(new SetContentDisplayModeCommand(content, content.getDeviceType(), Content.IMAGE));
                canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(canvas, "There is a problem reading " + imageFile + ".\n\n" + e.getMessage(), "Damask", 0);
                DamaskAppExceptionHandler.log(e);
            }
        }
    }

    private class ContentHandler
    implements InteractionElementListener,
    ContentListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.component.Label$ContentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ContentHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Label.this.getDeviceType()) {
                if (Label.this.getDisplayMode() == Content.INK) {
                    Content content = (Content)e.getElement();
                    Label.this.setStrokes(content.getStrokes());
                }
                Label.this.refreshContents();
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void strokeAdded(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Label.this.addStroke((GeneralPath)e.getNewValue());
        }

        public void strokeRemoved(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Label.this.removeStroke((GeneralPath)e.getNewValue());
        }

        public void strokesChanged(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Content content = e.getContent();
            Label.this.setStrokes(content.getStrokes());
        }

        public void textChanged(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Content content = e.getContent();
            Label.this.setTextString(content.getText());
            Label.this.setTextSize(content.getTextSize(Label.this.getDeviceType()));
            Label.this.refreshContents();
        }

        public void imageChanged(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Content content = e.getContent();
            if (content.getImage() != null) {
                Label.this.image.setImage(content.getImage());
            }
        }

        public void preferredDisplayModeChanged(ContentEvent e) {
            if (!$assertionsDisabled && e.getContent() != Label.this.getModel()) {
                throw new AssertionError((Object)("should be listening to events from " + Label.this.getModel() + " not " + e.getContent()));
            }
            Content content = e.getContent();
            Label.this.setDisplayMode(content.getPreferredDisplayMode(Label.this.getDeviceType()));
        }

        public void promptTextIsSyncedWithText(ContentEvent e) {
        }

        public void promptTextIsUnsyncedWithText(ContentEvent e) {
        }
    }

    private class InputEventHandler
    extends PBasicInputEventHandler {
        public InputEventHandler() {
            this.getEventFilter().setAndMask(16);
        }

        public void mouseClicked(PInputEvent event) {
            if (Label.this.displayMode == Content.IMAGE && Label.this.image.getImage() == null) {
                DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
                Label.this.tryToChangeImage(canvas);
            }
        }
    }
}

