/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class Hyperlink
extends ControlView {
    private Label caption;
    private TriggerHandler triggerHandler = new TriggerHandler();

    public Hyperlink(Trigger trigger) {
        super((Control)trigger, new RunModeEventHandler());
        trigger.addInteractionElementListener(this.triggerHandler);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DeviceType deviceType = this.getDeviceType();
        Trigger trigger = (Trigger)this.getModel();
        Content content = trigger.getContent();
        this.caption = new Label(content);
        this.caption.setPickable(false);
        this.addChild(this.caption);
        this.caption.setTransform(content.getTransform(deviceType));
        this.caption.setBounds(content.getBounds(deviceType));
        this.getContent().setLabelColor(Color.BLUE);
    }

    public static PNode createTempView() {
        return Label.createTempView();
    }

    public void dispose() {
        super.dispose();
        Trigger trigger = (Trigger)this.getModel();
        trigger.removeInteractionElementListener(this.triggerHandler);
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return (Label)this.getChild(0);
    }

    public Object getState() {
        return null;
    }

    public void setState(Object state) {
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        this.caption.setInRunMode(flag);
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Hyperlink hyperlink = (Hyperlink)event.getPickedNode();
            hyperlink.setStrokePaint(Color.LIGHT_GRAY);
            container.setFocus(hyperlink);
        }

        public void mouseReleased(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Hyperlink hyperlink = (Hyperlink)event.getPickedNode();
            if (container.getFocus() == hyperlink) {
                hyperlink.setStrokePaint(DamaskAppUtils.NO_COLOR);
                DeviceType deviceType = hyperlink.getDeviceType();
                Trigger trigger = (Trigger)hyperlink.getModel();
                NavConnection connection = trigger.getOutConnection(hyperlink.getDeviceType(), new InvokeEvent(trigger), container.getSelectedPageCondition());
                if (connection != null) {
                    container.goToPage(connection.getDest(deviceType).getPage(deviceType));
                }
            }
            container.setFocus(null);
        }
    }

    private class TriggerHandler
    implements InteractionElementListener {
        TriggerHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Hyperlink.this.getDeviceType()) {
                Rectangle2D newBounds = e.getElement().getBounds(e.getDeviceType());
                if (newBounds.getWidth() == 0.0 && newBounds.getHeight() == 0.0) {
                    Hyperlink.this.setBounds(new Rectangle2D.Double(newBounds.getX(), newBounds.getY(), Hyperlink.this.caption.getEmptySize().getWidth(), Hyperlink.this.caption.getEmptySize().getHeight()));
                } else {
                    Hyperlink.this.setBounds(e.getElement().getBounds(e.getDeviceType()));
                }
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }
}

