/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.ControlEvent;
import edu.berkeley.guir.damask.event.ControlListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

public abstract class ControlView
extends ComponentView {
    private static final Color ROLLOVER_COLOR = new Color(0, 102, 0);
    private static final Color ROLLOVER_COLOR_OTHER_LAYER = new Color(0, 102, 0, 80);
    private boolean inRunMode;
    private PInputEventListener runModeEventHandler;
    private final PInputEventListener designModeEventHandler = new DesignModeEventHandler(this);
    private final ControlListener controlHandler = new ControlHandler();

    public ControlView(Control control) {
        this(control, null, true);
    }

    public ControlView(Control control, boolean useDefaultElementListener) {
        this(control, null, useDefaultElementListener);
    }

    public ControlView(Control control, PInputEventListener runModeEventHandler) {
        this(control, runModeEventHandler, true);
    }

    public ControlView(Control control, PInputEventListener runModeEventHandler, boolean useDefaultElementListener) {
        super(control, useDefaultElementListener);
        this.runModeEventHandler = runModeEventHandler;
        control.addControlListener(this.controlHandler);
        this.setPaint(new Color(0, 0, 0, 0));
        this.setStrokePaint(new Color(0, 0, 0, 0));
        this.inRunMode = false;
        this.addInputEventListener(this.designModeEventHandler);
    }

    public void dispose() {
        super.dispose();
        this.removeInputEventListener(this.runModeEventHandler);
        ((Control)this.getModel()).removeControlListener(this.controlHandler);
    }

    public abstract Object getState();

    public abstract void setState(Object var1);

    public boolean isInRunMode() {
        return this.inRunMode;
    }

    public void setInRunMode(boolean flag) {
        if (this.inRunMode == flag) {
            return;
        }
        this.inRunMode = flag;
        if (this.inRunMode) {
            this.removeInputEventListener(this.designModeEventHandler);
            if (this.runModeEventHandler != null) {
                this.addInputEventListener(this.runModeEventHandler);
            }
        } else {
            if (this.runModeEventHandler != null) {
                this.removeInputEventListener(this.runModeEventHandler);
            }
            this.addInputEventListener(this.designModeEventHandler);
        }
    }

    private class ControlHandler
    implements ControlListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.component.ControlView$ControlHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ControlHandler() {
        }

        public void controlStateChanged(ControlEvent e) {
            Dialog controlDialog;
            if (!$assertionsDisabled && e.getControl() != ControlView.this.getModel()) {
                throw new AssertionError((Object)("should not be listening to events from " + e.getControl()));
            }
            PageView pageView = ControlView.this.getPageView();
            Dialog pageDialog = ((Page)pageView.getModel()).getDialog();
            int condition = pageDialog == (controlDialog = e.getControl().getDialog()) ? pageView.getDesignTimeCondition() : controlDialog.getInitialCondition();
            ControlView.this.setState(e.getControl().getStateForCondition(controlDialog, condition));
        }

        public void controlSignificanceChanged(ControlEvent e) {
            if (!$assertionsDisabled && e.getControl() != ControlView.this.getModel()) {
                throw new AssertionError((Object)("should not be listening to events from " + e.getControl()));
            }
        }

        public void pageRegionChanged(ControlEvent e) {
        }
    }

    private static class DesignModeEventHandler
    extends PBasicInputEventHandler {
        private ControlView controlView;

        public DesignModeEventHandler(ControlView controlView) {
            this.controlView = controlView;
        }

        private void changeNodeColor(PInputEvent event, boolean isPush) {
            if (!(event.getComponent() instanceof DamaskCanvas)) {
                return;
            }
            PNode node = event.getPickedNode();
            if (!(node instanceof InteractionElementView)) {
                return;
            }
            InteractionElementView elementView = (InteractionElementView)node;
            DamaskDocument doc = ((DamaskCanvas)event.getComponent()).getDocument();
            Iterator i = doc.getCanvasGroups().iterator();
            while (i.hasNext()) {
                DamaskDocument.DamaskCanvasGroup group = (DamaskDocument.DamaskCanvasGroup)i.next();
                Iterator j = group.getCanvases().iterator();
                while (j.hasNext()) {
                    DamaskCanvas canvas = (DamaskCanvas)j.next();
                    DamaskLayer layer = (DamaskLayer)canvas.getLayer();
                    List views = layer.getViews(elementView.getModel());
                    Iterator k = views.iterator();
                    while (k.hasNext()) {
                        InteractionElementView aView = (InteractionElementView)k.next();
                        if (isPush) {
                            if (aView.isSelectable()) {
                                DamaskAppUtils.pushInternalColor(aView, ROLLOVER_COLOR);
                                continue;
                            }
                            DamaskAppUtils.pushInternalColor(aView, ROLLOVER_COLOR_OTHER_LAYER);
                            continue;
                        }
                        DamaskAppUtils.popInternalColor(aView);
                        if (this.controlView.getLayer() == null) continue;
                        this.controlView.deviceTypeLayerChanged();
                    }
                }
            }
        }

        public void mouseEntered(PInputEvent event) {
            if (event.getPickedNode() == this.controlView) {
                this.changeNodeColor(event, true);
            }
        }

        public void mouseExited(PInputEvent event) {
            if (event.getPickedNode() == this.controlView) {
                this.changeNodeColor(event, false);
            }
        }
    }
}

