/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.ListBox;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ComboBox
extends ControlView {
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 7;
    private static final int DEFAULT_WIDTH = 100;
    protected static final int DEFAULT_HEIGHT = (int)DamaskAppUtils.getRenderedTextBounds("AAA", DamaskAppUtils.getDefaultFont().getSize()).getHeight();
    private static final int DROP_DOWN_LIST_SIZE = 5;
    private final PPath downArrow;
    private final ListBox dropDownList;
    private Label selectedLabel = null;
    private SelectOne.Item selectedItem;

    public ComboBox(SelectOne selectOne) {
        super((Control)selectOne, new RunModeEventHandler());
        this.setStretchedWhenResized(false);
        this.setStrokePaint(Color.BLACK);
        this.setPaint(Color.WHITE);
        this.dropDownList = new ListBox(selectOne, false);
        this.downArrow = ComboBox.createDownArrow();
        this.addChild(this.downArrow);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DeviceType deviceType = this.getDeviceType();
        SelectOne selectOne = (SelectOne)this.getModel();
        Rectangle2D bounds = selectOne.getBounds(deviceType);
        this.setPathTo(bounds);
        this.dropDownList.setVisible(false);
        this.dropDownList.setSelectable(false);
        this.dropDownList.setPickable(false);
        this.getParent().addChild(this.dropDownList);
        this.dropDownList.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), 5 * ListBox.DEFAULT_LINE_HEIGHT));
        this.dropDownList.setOffset(this.getFullBounds().getX(), this.getFullBounds().getMaxY());
        PageView pageView = this.getPageView();
        if (pageView != null) {
            Dialog controlDialog;
            Dialog pageDialog = ((Page)pageView.getModel()).getDialog();
            int condition = pageDialog == (controlDialog = selectOne.getDialog()) ? pageView.getDesignTimeCondition() : controlDialog.getInitialCondition();
            this.setState(selectOne.getStateForCondition(controlDialog, condition));
        }
    }

    private static PPath createDownArrow() {
        GeneralPath downArrowPath = new GeneralPath();
        downArrowPath.moveTo(5.0f, 7.0f);
        downArrowPath.lineTo(10.0f, 0.0f);
        downArrowPath.lineTo(0.0f, 0.0f);
        downArrowPath.closePath();
        PPath downArrow = new PPath(downArrowPath);
        downArrow.setPaint(Color.BLACK);
        downArrow.setPickable(false);
        return downArrow;
    }

    public Object getEditableContents() {
        return this.dropDownList.getEditableContents();
    }

    public Object getState() {
        return this.selectedItem;
    }

    public void setState(Object state) {
        this.selectedItem = (SelectOne.Item)state;
        this.dropDownList.setState(state);
        if (this.selectedLabel != null) {
            this.selectedLabel.dispose();
            this.selectedLabel.removeFromParent();
        }
        if (this.selectedItem != null) {
            this.selectedLabel = new Label(this.selectedItem.getContent(), false);
            this.selectedLabel.setPickable(false);
            this.addChild(this.selectedLabel);
        }
        this.dropDownList.setVisible(false);
        this.dropDownList.setPickable(false);
    }

    protected int getItemCount() {
        return this.dropDownList.getItemCount();
    }

    public static PNode createTempView() {
        PPath border = new PPath(new Rectangle2D.Double(0.0, 0.0, 100.0, DEFAULT_HEIGHT));
        int[] itemSquiggleLengths = new int[]{4, 3, 5};
        PNode squiggles = DamaskAppUtils.createSquiggles(itemSquiggleLengths);
        border.addChild(squiggles);
        double oldHeight = squiggles.getHeight();
        squiggles.setBounds(0.0, 0.0, 100.0, DEFAULT_HEIGHT);
        squiggles.setOffset(0.0, 0.0);
        if (oldHeight < (double)DEFAULT_HEIGHT) {
            AffineTransform centeringTransform = AffineTransform.getTranslateInstance(0.0, ((double)DEFAULT_HEIGHT - oldHeight) / 2.0);
            Iterator j = squiggles.getChildrenIterator();
            while (j.hasNext()) {
                PPath child = (PPath)j.next();
                child.getPathReference().transform(centeringTransform);
            }
        }
        PPath downArrow = ComboBox.createDownArrow();
        downArrow.setOffset(95.0 - downArrow.getWidth(), ((double)DEFAULT_HEIGHT - downArrow.getHeight()) / 2.0);
        border.addChild(downArrow);
        return border;
    }

    protected ListBox getDropDownList() {
        return this.dropDownList;
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        this.dropDownList.setInRunMode(flag);
    }

    protected void layoutChildren() {
        if (this.selectedLabel != null) {
            AffineTransform centeringTransform = AffineTransform.getTranslateInstance(0.0, (this.getHeight() - this.selectedLabel.getHeight()) / 2.0);
            this.selectedLabel.setTransform(centeringTransform);
        }
        this.downArrow.setOffset(this.getWidth() - 5.0 - this.downArrow.getWidth(), (this.getHeight() - this.downArrow.getHeight()) / 2.0);
    }

    protected void paint(PPaintContext paintContext) {
        this.clipPaint(paintContext);
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
        this.clipPaintAfterChildren(paintContext);
    }

    public boolean fullPick(PPickPath pickPath) {
        return this.clipFullPick(pickPath);
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        static /* synthetic */ Class class$0;

        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            if (event.getPickedNode() instanceof ComboBox) {
                ComboBox comboBox = (ComboBox)event.getPickedNode();
                ListBox dropDownList = comboBox.getDropDownList();
                if (dropDownList.getVisible()) {
                    dropDownList.setVisible(false);
                    dropDownList.setPickable(false);
                } else {
                    dropDownList.setPathTo(new Rectangle2D.Double(0.0, 0.0, comboBox.getWidth(), 5 * ListBox.DEFAULT_LINE_HEIGHT));
                    dropDownList.setOffset(comboBox.getFullBounds().getX(), comboBox.getFullBounds().getMaxY());
                    dropDownList.setState(comboBox.getState());
                    dropDownList.setVisible(true);
                    dropDownList.setPickable(true);
                }
            }
            PNode pNode = event.getPickedNode();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.component.ComboBox");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            container.setFocus((ComboBox)DamaskAppUtils.getAncestor(pNode, clazz));
        }
    }
}

