/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.view.visual.component.CheckBox;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.umd.cs.piccolo.PNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CheckBoxGroup
extends ControlView {
    private final CheckBoxHandler checkBoxHandler = new CheckBoxHandler();
    private final Map views = new HashMap();
    private Set selectedItems = new HashSet();
    private boolean childrenSelectable = true;

    public CheckBoxGroup(SelectMany selectMany) {
        super(selectMany);
        selectMany.addElementContainerListener(this.checkBoxHandler);
        super.setSelectable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        Iterator i = ((SelectMany)this.getModel()).getItems().iterator();
        while (i.hasNext()) {
            SelectMany.Item selectManyItem = (SelectMany.Item)i.next();
            CheckBox checkBox = new CheckBox(selectManyItem);
            this.addChild(checkBox);
            checkBox.setInRunMode(this.isInRunMode());
            this.views.put(selectManyItem, checkBox);
        }
    }

    public void dispose() {
        super.dispose();
        ((SelectMany)this.getModel()).removeElementContainerListener(this.checkBoxHandler);
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            CheckBox checkBox = (CheckBox)i.next();
            checkBox.setInRunMode(flag);
        }
    }

    public void setSelectable(boolean flag) {
        this.childrenSelectable = flag;
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof CheckBox)) continue;
            ((CheckBox)child).setSelectable(flag);
        }
    }

    public void setPickable(boolean flag) {
        super.setPickable(flag);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            child.setPickable(flag);
        }
    }

    public Object getState() {
        return Collections.unmodifiableSet(this.selectedItems);
    }

    public void setState(Object state) {
        this.selectedItems = new HashSet((Collection)state);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            CheckBox checkBox = (CheckBox)i.next();
            checkBox.setChecked(this.selectedItems.contains(checkBox.getModel()));
        }
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return null;
    }

    protected void addSelectedCheckBox(CheckBox checkBox) {
        this.selectedItems.add(checkBox.getModel());
        checkBox.setChecked(true);
    }

    protected void removeSelectedCheckBox(CheckBox checkBox) {
        this.selectedItems.remove(checkBox.getModel());
        checkBox.setChecked(false);
    }

    public class CheckBoxHandler
    implements ElementContainerListener {
        public void elementAdded(ElementContainerEvent e) {
            SelectMany.Item selectManyItem = (SelectMany.Item)e.getElement();
            CheckBox checkBox = new CheckBox(selectManyItem);
            CheckBoxGroup.this.addChild(checkBox);
            checkBox.setInRunMode(CheckBoxGroup.this.isInRunMode());
            checkBox.setSelectable(CheckBoxGroup.this.childrenSelectable);
            checkBox.setPickable(CheckBoxGroup.this.getPickable());
            CheckBoxGroup.this.views.put(selectManyItem, checkBox);
        }

        public void elementRemoved(ElementContainerEvent e) {
            InteractionElement element = e.getElement();
            PNode elementView = (PNode)CheckBoxGroup.this.views.get(element);
            elementView.removeFromParent();
            CheckBoxGroup.this.views.remove(element);
        }
    }
}

