/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.CheckBoxGroup;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

public class CheckBox
extends ControlView {
    private static final int BOX_SIDE_LENGTH = 15;
    private static final int GAP = 8;
    private Label caption;
    private final PPath boxOutline = new PPath();
    private final PPath checkMark = new PPath();
    private boolean checked = false;

    public CheckBox(SelectMany.Item selectManyItem) {
        super((Control)selectManyItem, new RunModeEventHandler());
        this.setResizable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        SelectMany.Item selectManyItem = (SelectMany.Item)this.getModel();
        this.boxOutline.setPathTo(new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
        this.boxOutline.setPickable(false);
        this.addChild(this.boxOutline);
        this.caption = new Label(selectManyItem.getContent());
        this.caption.setPickable(false);
        this.addChild(this.caption);
        this.checkMark.moveTo(3.0f, 7.5f);
        this.checkMark.lineTo(6.0f, 12.0f);
        this.checkMark.lineTo(12.0f, 3.0f);
        this.checkMark.setPickable(false);
    }

    public static PNode createTempView() {
        PNode parentNode = new PNode();
        PPath checkBox = new PPath(new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
        PPath squiggle = DamaskAppUtils.createSquiggle();
        squiggle.setOffset(23.0, 0.0);
        parentNode.addChild(checkBox);
        parentNode.addChild(squiggle);
        parentNode.setBounds(0.0, 0.0, 23.0 + squiggle.getWidth(), 15.0);
        return parentNode;
    }

    public Object getState() {
        return this.checked;
    }

    public void setState(Object state) {
        boolean flag = (Boolean)state;
        if (flag) {
            ((CheckBoxGroup)this.getParent()).addSelectedCheckBox(this);
        } else {
            ((CheckBoxGroup)this.getParent()).removeSelectedCheckBox(this);
        }
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return this.caption;
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected void setChecked(boolean state) {
        if (this.checked != state) {
            this.checked = state;
            if (this.checked) {
                this.addChild(this.checkMark);
            } else {
                this.removeChild(this.checkMark);
            }
        }
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            checkBox.boxOutline.setPaint(Color.LIGHT_GRAY);
            container.setFocus(checkBox);
        }

        public void mouseReleased(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            if (container.getFocus() == checkBox) {
                checkBox.boxOutline.setPaint(DamaskAppUtils.NO_COLOR);
                SelectMany.Item selectManyItem = (SelectMany.Item)checkBox.getModel();
                CheckBoxGroup group = (CheckBoxGroup)checkBox.getParent();
                HashSet<InteractionElement> selectedItems = new HashSet<InteractionElement>((Set)group.getState());
                if (checkBox.isChecked()) {
                    selectedItems.remove(checkBox.getModel());
                } else {
                    selectedItems.add(checkBox.getModel());
                }
                container.setControlState((Control)group.getModel(), selectedItems);
                DeviceType deviceType = checkBox.getDeviceType();
                NavConnection connection = selectManyItem.getOutConnection(checkBox.getDeviceType(), new InvokeEvent(selectManyItem), container.getSelectedPageCondition());
                if (connection != null) {
                    container.goToPage(connection.getDest(deviceType).getPage(deviceType));
                }
            }
            container.setFocus(null);
        }

        public void mouseEntered(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            if (container.getFocus() == checkBox) {
                checkBox.boxOutline.setPaint(Color.LIGHT_GRAY);
            }
        }

        public void mouseExited(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            if (container.getFocus() == checkBox) {
                checkBox.boxOutline.setPaint(DamaskAppUtils.NO_COLOR);
            }
        }
    }
}

