/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual.component;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.userevent.InvokeEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class Button
extends ControlView {
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_CORNER_RADIUS = 7;
    private Label caption = null;

    public Button(Trigger trigger) {
        super((Control)trigger, new RunModeEventHandler());
        this.setStrokePaint(Color.BLACK);
        this.setStretchedWhenResized(false);
        this.addClientProperty("Resize children anchor", Direction.CENTER);
        this.setPaint(DamaskAppUtils.NO_COLOR);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DeviceType deviceType = this.getDeviceType();
        Trigger trigger = (Trigger)this.getModel();
        this.setPathTo(trigger.getBorder(deviceType));
        this.caption = new Label(trigger.getContent());
        this.caption.setPickable(false);
        this.caption.setMovable(false);
        this.caption.addClientProperty("Resize anchor", Direction.CENTER);
        this.addChild(this.caption);
        this.getModel().addInteractionElementListener(new TriggerHandler());
    }

    public Object getEditableContents() {
        return this.getContent();
    }

    public Label getContent() {
        return this.caption;
    }

    public Object getState() {
        return null;
    }

    public void setState(Object state) {
    }

    public static PNode createTempView() {
        PPath border = new PPath(new RoundRectangle2D.Double(0.0, 0.0, 80.0, 20.0, 7.0, 7.0));
        PPath squiggle = DamaskAppUtils.createSquiggle();
        squiggle.setOffset((border.getWidth() - squiggle.getWidth()) / 2.0, (border.getHeight() - squiggle.getHeight()) / 2.0);
        border.addChild(squiggle);
        return border;
    }

    public void setInRunMode(boolean flag) {
        super.setInRunMode(flag);
    }

    private static class RunModeEventHandler
    extends PBasicInputEventHandler {
        RunModeEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Button button = (Button)event.getPickedNode();
            button.getContent().setLabelColor(Color.WHITE);
            button.setPaint(Color.BLACK);
            container.setFocus(button);
        }

        public void mouseReleased(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Button button = (Button)event.getPickedNode();
            if (container.getFocus() == button) {
                button.getContent().setLabelColor(Color.BLACK);
                button.setPaint(Color.WHITE);
                DeviceType deviceType = button.getDeviceType();
                Trigger trigger = (Trigger)button.getModel();
                NavConnection connection = trigger.getOutConnection(button.getDeviceType(), new InvokeEvent(trigger), container.getSelectedPageCondition());
                if (connection != null) {
                    container.goToPage(connection.getDest(deviceType).getPage(deviceType));
                }
            }
        }

        public void mouseEntered(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Button button = (Button)event.getPickedNode();
            if (container.getFocus() == button) {
                button.getContent().setLabelColor(Color.WHITE);
                button.setPaint(Color.BLACK);
            }
        }

        public void mouseExited(PInputEvent event) {
            PageViewContainer container = (PageViewContainer)((Object)event.getComponent());
            Button button = (Button)event.getPickedNode();
            if (container.getFocus() == button) {
                button.getContent().setLabelColor(Color.BLACK);
                button.setPaint(Color.WHITE);
            }
        }
    }

    private class TriggerHandler
    implements InteractionElementListener {
        TriggerHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Button.this.getDeviceType()) {
                Rectangle2D newBounds = e.getElement().getBounds(e.getDeviceType());
                if (newBounds.getWidth() == 0.0 && newBounds.getHeight() == 0.0) {
                    Button.this.setBounds(new Rectangle2D.Double(newBounds.getX(), newBounds.getY(), Button.this.caption.getEmptySize().getWidth(), Button.this.caption.getEmptySize().getHeight()));
                } else {
                    Button.this.setBounds(e.getElement().getBounds(e.getDeviceType()));
                }
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Button.this.getDeviceType()) {
                Button.this.setPathTo(((Trigger)Button.this.getModel()).getBorder(Button.this.getDeviceType()));
            }
        }
    }
}

