/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.pattern.PatternInstanceView;
import edu.berkeley.guir.damask.view.visual.Arrow;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.dialog.DialogView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class VisualLayer
extends DamaskLayer {
    private List dialogs;
    private PageView homePageView;
    private List homePageViews;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.VisualLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VisualLayer(DamaskDocument doc, DeviceType deviceType) {
        this(doc, deviceType, 1.0);
    }

    public VisualLayer(DamaskDocument doc, DeviceType deviceType, double pageTitleScale) {
        super(doc, deviceType, pageTitleScale);
        this.addPropertyChangeListener("cameras", new CamerasHandler());
    }

    protected void initBeforeAddingViews() {
        this.dialogs = new ArrayList();
        this.homePageView = null;
        this.homePageViews = new ArrayList();
    }

    protected void internalSetDeviceTypeLayer(DamaskLayer.DeviceTypeLayer deviceTypeLayer) {
        PNode node;
        super.internalSetDeviceTypeLayer(deviceTypeLayer);
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            node = (PNode)i.next();
            if (node instanceof Arrow) {
                ((Arrow)node).deviceTypeLayerChanged();
                continue;
            }
            if (!(node instanceof DialogView)) continue;
            ((DialogView)node).deviceTypeLayerChanged();
        }
        i = this.getTemplatePane().getViewsOfTemplateDialogs().iterator();
        while (i.hasNext()) {
            node = (InteractionElementView)i.next();
            if (!(node instanceof DialogView)) continue;
            ((DialogView)node).deviceTypeLayerChanged();
        }
    }

    public List getDialogViews() {
        return Collections.unmodifiableList(this.dialogs);
    }

    public List getDialogViewsIncludingTemplates() {
        ArrayList allDialogs = new ArrayList();
        allDialogs.addAll(this.dialogs);
        allDialogs.addAll(this.getTemplatePane().getViewsOfTemplateDialogs());
        return Collections.unmodifiableList(allDialogs);
    }

    public PageView getHomePageView() {
        return this.homePageView;
    }

    public List getHomePageViews() {
        return Collections.unmodifiableList(this.homePageViews);
    }

    protected void addViewForElement(InteractionElement element) {
        DeviceType deviceType = this.getDeviceType();
        TemplatePane templatePane = this.getTemplatePane();
        if (element instanceof Dialog) {
            Dialog d = (Dialog)element;
            if (!(d instanceof TemplateDialog) && d.isEnabled(deviceType)) {
                DialogView dView = new DialogView(d);
                this.views.put(d, dView);
                this.addChild(this.indexOfChild(templatePane), dView);
                this.dialogs.add(dView);
                dView.setContentsSelectable(true);
                this.trackAddition(dView);
            }
        } else if (element instanceof Connection) {
            Connection c = (Connection)element;
            if (c.isVisibleToDeviceType(deviceType)) {
                Arrow arrow = new Arrow(c);
                Page sourcePage = c.getConnectionSource(deviceType).getPage(deviceType);
                if (sourcePage.isTemplate()) {
                    this.addChild(arrow);
                } else {
                    this.addChild(this.indexOfChild(templatePane), arrow);
                }
                if (c.getConnectionSource(deviceType).getDialog() instanceof TemplateDialog) {
                    int i = 0;
                    int n = this.getCameraCount();
                    while (i < n) {
                        PCamera aCamera = this.getCamera(i);
                        arrow.setVisibleToCamera(aCamera, templatePane.isVisibleToCamera(aCamera));
                        ++i;
                    }
                }
                this.views.put(c, arrow);
                this.trackAddition(arrow);
                Iterator i = c.getPatternInstanceMemberships().iterator();
                while (i.hasNext()) {
                    PatternInstance instance = (PatternInstance)i.next();
                    PatternInstanceView instanceView = (PatternInstanceView)this.views.get(instance);
                    if (instanceView == null) continue;
                    instanceView.addMemberView(arrow);
                }
            }
        } else if (element instanceof PatternInstance) {
            PatternInstance pi = (PatternInstance)element;
            if (pi.isVisibleToDeviceType(deviceType)) {
                PatternInstanceView piView = new PatternInstanceView(pi);
                this.addChild(this.indexOfChild(templatePane), piView);
                this.views.put(pi, piView);
                this.trackAddition(piView);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
        }
    }

    protected void removeViewForElement(InteractionElement element) {
        DeviceType deviceType = this.getDeviceType();
        if (element instanceof Dialog) {
            Dialog d = (Dialog)element;
            if (!(d instanceof TemplateDialog) && d.isEnabled(deviceType)) {
                DialogView dView = (DialogView)this.views.get(d);
                dView.setContentsSelectable(false);
                this.removeChild(dView);
                this.dialogs.remove(dView);
                Iterator i = this.getCamerasReference().iterator();
                while (i.hasNext()) {
                    VisualCanvas canvas;
                    PageView oldSelectedPageView;
                    PCamera camera = (PCamera)i.next();
                    PComponent component = camera.getComponent();
                    if (!(component instanceof VisualCanvas) || (oldSelectedPageView = (canvas = (VisualCanvas)component).getSelectedPageView()) == null || oldSelectedPageView.getParent() != dView) continue;
                    canvas.attachHandles(null, camera);
                }
                dView.dispose();
            }
        } else if (element instanceof Connection) {
            Connection c = (Connection)element;
            if (c.isVisibleToDeviceType(deviceType)) {
                Arrow arrow = (Arrow)this.views.get(c);
                Iterator i = c.getPatternInstanceMemberships().iterator();
                while (i.hasNext()) {
                    PatternInstance instance = (PatternInstance)i.next();
                    PatternInstanceView instanceView = (PatternInstanceView)this.views.get(instance);
                    if (instanceView == null) continue;
                    instanceView.removeMemberView(arrow);
                }
                arrow.dispose();
                this.removeChild(arrow);
            }
        } else if (element instanceof PatternInstance) {
            PatternInstance pi = (PatternInstance)element;
            if (pi.isVisibleToDeviceType(deviceType)) {
                PatternInstanceView piView = (PatternInstanceView)this.views.get(pi);
                piView.dispose();
                this.removeChild(piView);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
        }
    }

    public void updateHomePage() {
        PNode homePageView;
        InteractionGraph graph = this.getDocument().getGraph();
        DeviceType deviceType = this.getDeviceType();
        Iterator i = this.homePageViews.iterator();
        while (i.hasNext()) {
            homePageView = (PNode)i.next();
            if (!(homePageView instanceof PageView)) continue;
            ((PageView)homePageView).setHome(false);
        }
        this.homePageView = (PageView)this.getView(graph.getHomePage(deviceType));
        this.homePageViews.clear();
        this.homePageViews = this.getViews(graph.getHomePage(deviceType));
        i = this.homePageViews.iterator();
        while (i.hasNext()) {
            homePageView = (PNode)i.next();
            if (!(homePageView instanceof PageView)) continue;
            ((PageView)homePageView).setHome(true);
        }
    }

    public void updateArrows(DialogView diagview) {
        TemplatePane templatePane = this.getTemplatePane();
        LinkedList<Arrow> arrwList = new LinkedList<Arrow>();
        LinkedList<Arrow> tparrwList = new LinkedList<Arrow>();
        LinkedList tpdvList = new LinkedList();
        Iterator tpiter = templatePane.getChildrenIterator();
        while (tpiter.hasNext()) {
            tpdvList.add(tpiter.next());
        }
        Iterator iter = this.getChildrenIterator();
        while (iter.hasNext()) {
            Iterator tpdviter;
            Object obj = iter.next();
            if (!(obj instanceof Arrow)) continue;
            Arrow arrw = (Arrow)obj;
            InteractionElementView srcObj = arrw.getSourceView();
            InteractionElementView destObj = arrw.getDestView();
            if (srcObj instanceof PageView) {
                if (((PageView)srcObj).getParent() == diagview) {
                    arrwList.add(arrw);
                }
                tpdviter = tpdvList.iterator();
                while (tpdviter.hasNext()) {
                    if (((PageView)srcObj).getParent() != (DialogView)tpdviter.next()) continue;
                    tparrwList.add(arrw);
                }
            }
            if (destObj instanceof PageView) {
                if (((PageView)destObj).getParent() == diagview) {
                    arrwList.add(arrw);
                }
                tpdviter = tpdvList.iterator();
                while (tpdviter.hasNext()) {
                    if (((PageView)destObj).getParent() != (DialogView)tpdviter.next()) continue;
                    tparrwList.add(arrw);
                }
            }
            if (!(srcObj instanceof ControlView)) continue;
            ControlView cntrlview = (ControlView)srcObj;
            if (cntrlview.getParent().getParent().getParent().getParent() == diagview) {
                arrwList.add(arrw);
            }
            Iterator tpdviter2 = tpdvList.iterator();
            while (tpdviter2.hasNext()) {
                if (cntrlview.getParent().getParent().getParent().getParent() != (DialogView)tpdviter2.next()) continue;
                tparrwList.add(arrw);
            }
        }
        Iterator arrwiter = arrwList.iterator();
        while (arrwiter.hasNext()) {
            ((Arrow)arrwiter.next()).moveToFront();
        }
        templatePane.moveToFront();
        Iterator tparrwiter = tparrwList.iterator();
        while (tparrwiter.hasNext()) {
            ((Arrow)tparrwiter.next()).moveToFront();
        }
    }

    private class CamerasHandler
    implements PropertyChangeListener {
        CamerasHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Iterator i = VisualLayer.this.getDialogViewsIncludingTemplates().iterator();
            while (i.hasNext()) {
                DialogView dialogView = (DialogView)i.next();
                dialogView.setContentsSelectable(true);
            }
        }
    }
}

