/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.GroupStrokesCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveDialogCommand;
import edu.berkeley.guir.damask.command.SetContentDisplayModeCommand;
import edu.berkeley.guir.damask.command.SetHomePageCommand;
import edu.berkeley.guir.damask.command.UngroupStrokesCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppMode;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.DamaskRunFrame;
import edu.berkeley.guir.damask.view.DamaskToolbar;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import edu.berkeley.guir.damask.view.event.EraserEventHandler;
import edu.berkeley.guir.damask.view.nodes.DamaskWindow;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.nodes.NonResizableHandle;
import edu.berkeley.guir.damask.view.visual.DamaskPhoneRunFrame;
import edu.berkeley.guir.damask.view.visual.VisualLayer;
import edu.berkeley.guir.damask.view.visual.VisualMode;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.TextBox;
import edu.berkeley.guir.damask.view.visual.dialog.DialogView;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewPart;
import edu.berkeley.guir.damask.view.visual.event.InsertButtonHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertCheckBoxHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertComboBoxHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertListBoxHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertPanelHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertRadioButtonHandler;
import edu.berkeley.guir.damask.view.visual.event.InsertTextBoxHandler;
import edu.berkeley.guir.damask.view.visual.event.MergeEventHandler;
import edu.berkeley.guir.damask.view.visual.event.PageEventHandler;
import edu.berkeley.guir.damask.view.visual.event.PencilEventHandler;
import edu.berkeley.guir.damask.view.visual.event.SplitEventHandler;
import edu.berkeley.guir.damask.view.visual.event.TextHandler;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;

public class VisualCanvas
extends DamaskCanvas
implements PageViewContainer {
    private static final Point POINT00 = new Point(0, 0);
    private static final Logger logger;
    public static final String PENCIL_MODE = "Page/Pencil";
    public static final String ERASER_MODE = "Eraser";
    public static final String TEXT_MODE = "Text";
    public static final String BUTTON_MODE = "Button";
    public static final String CHECK_BOX_MODE = "Check Box";
    public static final String RADIO_BUTTON_MODE = "Radio Button";
    public static final String LIST_BOX_MODE = "List Box";
    public static final String COMBO_BOX_MODE = "Drop-Down Box";
    public static final String TEXT_BOX_MODE = "Text Box";
    public static final String PANEL_MODE = "Group";
    public static final String SPLIT_MODE = "Split Page";
    public static final String MERGE_MODE = "Merge Pages";
    public static final String CHANGE_CONTROL_STATE_MODE = "Change Control State";
    private final TextHandler textHandler = new TextHandler();
    private PInputEventListener appModeHandler = null;
    private PageView selectedPageView = null;
    private PageRegionView selectedPageRegionView = null;
    private ControlView focus = null;
    private final Action cutPageAction = new CutPageAction();
    private final Action copyPageAction = new CopyPageAction();
    private final Action pastePageAction = new PastePageAction();
    private final Action deletePageAction = new DeletePageAction();
    private final Action setHomePageAction = new SetHomePageAction();
    private final Map changeContentDisplayModeActions = new HashMap();
    private final Action changeContentPictureAction = new ChangeContentPictureAction();
    private final Action groupStrokesAction = new GroupStrokesAction();
    private final Action ungroupStrokesAction = new UngroupStrokesAction();
    private final Action runFromHomeAction = new RunFromHomeAction();
    private final Action runFromSelectedPageAction = new RunFromSelectedPageAction();
    private final Set selectedLabels = new HashSet();
    private final JPopupMenu pagePopupMenu = new JPopupMenu();
    private final JPopupMenu contentPopupMenu = new JPopupMenu();
    private final JRadioButtonMenuItem contentInkItem;
    private final JRadioButtonMenuItem contentTextItem;
    private final JRadioButtonMenuItem contentPictureItem;
    private final JRadioButtonMenuItem contentMixedItem;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public VisualCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType) {
        this(group, deviceType, 1.0);
    }

    public VisualCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType, double pageTitleScale) {
        super(group, deviceType, pageTitleScale);
        this.addCanvasListener(new SelectionChangeHandler());
        this.textHandler.setEventFilter(new PInputEventFilter(16));
        this.addMode(new VisualMode(ERASER_MODE, new EraserEventHandler(), null, DamaskAppUtils.createCursor("eraser.gif", new Point(0, 0), ERASER_MODE), null));
        this.addMode(new VisualMode(PENCIL_MODE, new PageEventHandler(), new PencilEventHandler(), DamaskAppUtils.createCursor("page.gif", new Point(0, 0), "Page"), DamaskAppUtils.createCursor("dot.gif", new Point(0, 0), PENCIL_MODE), null));
        this.addMode(new VisualMode(TEXT_MODE, this.textHandler, null, Cursor.getPredefinedCursor(2), Cursor.getPredefinedCursor(2)));
        this.addMode(new VisualMode(BUTTON_MODE, new InsertButtonHandler(), null, DamaskAppUtils.createCursor("button.gif", new Point(0, 0), BUTTON_MODE), null));
        this.addMode(new VisualMode(CHECK_BOX_MODE, new InsertCheckBoxHandler(), null, DamaskAppUtils.createCursor("check_box.gif", new Point(0, 0), CHECK_BOX_MODE), null));
        this.addMode(new VisualMode(RADIO_BUTTON_MODE, new InsertRadioButtonHandler(), null, DamaskAppUtils.createCursor("radio_button.gif", new Point(0, 0), RADIO_BUTTON_MODE), null));
        this.addMode(new VisualMode(LIST_BOX_MODE, new InsertListBoxHandler(), null, DamaskAppUtils.createCursor("list_box.gif", new Point(0, 0), LIST_BOX_MODE), null));
        this.addMode(new VisualMode(COMBO_BOX_MODE, new InsertComboBoxHandler(), null, DamaskAppUtils.createCursor("combo_box.gif", new Point(0, 0), COMBO_BOX_MODE), null));
        this.addMode(new VisualMode(TEXT_BOX_MODE, new InsertTextBoxHandler(), null, DamaskAppUtils.createCursor("text_box.gif", new Point(0, 0), TEXT_BOX_MODE), null));
        this.addMode(new VisualMode(PANEL_MODE, new InsertPanelHandler(), null, DamaskAppUtils.createCursor("panel.gif", new Point(0, 0), PANEL_MODE), null));
        this.addMode(new VisualMode(SPLIT_MODE, new SplitEventHandler(), null, DamaskAppUtils.createCursor("split.gif", new Point(7, 8), SPLIT_MODE), null));
        this.addMode(new VisualMode(MERGE_MODE, new MergeEventHandler(), null, DamaskAppUtils.createCursor("merge.gif", new Point(7, 8), MERGE_MODE), null));
        this.addMode(new VisualMode(CHANGE_CONTROL_STATE_MODE, null, null, null, DamaskAppUtils.createCursor("change_state.gif", new Point(0, 0), CHANGE_CONTROL_STATE_MODE)));
        this.cutPageAction.setEnabled(false);
        this.copyPageAction.setEnabled(false);
        this.deletePageAction.setEnabled(false);
        this.setHomePageAction.setEnabled(false);
        this.groupStrokesAction.setEnabled(false);
        this.ungroupStrokesAction.setEnabled(false);
        this.runFromHomeAction.setEnabled(!this.getDocument().getGraph().getDialogs(this.getDeviceType()).isEmpty());
        this.runFromSelectedPageAction.setEnabled(false);
        Collection labelDisplayModes = Content.getSupportedDisplayModes();
        Iterator i = labelDisplayModes.iterator();
        while (i.hasNext()) {
            Content.DisplayMode displayMode = (Content.DisplayMode)i.next();
            ChangeContentDisplayModeAction action = new ChangeContentDisplayModeAction(displayMode);
            action.setEnabled(false);
            this.changeContentDisplayModeActions.put(displayMode, action);
        }
        this.changeContentPictureAction.setEnabled(false);
        this.pagePopupMenu.add(new JMenuItem(this.cutPageAction));
        this.pagePopupMenu.add(new JMenuItem(this.copyPageAction));
        this.pagePopupMenu.add(new JMenuItem(this.getPasteAction()));
        this.pagePopupMenu.add(new JMenuItem(this.deletePageAction));
        this.pagePopupMenu.add(new JSeparator());
        this.pagePopupMenu.add(new JMenuItem(this.setHomePageAction));
        this.pagePopupMenu.add(new JSeparator());
        JMenuItem runFromThisPageItem = new JMenuItem(this.getRunFromSelectedPageAction());
        runFromThisPageItem.setText("Run From This Page");
        runFromThisPageItem.setMnemonic(82);
        this.pagePopupMenu.add(runFromThisPageItem);
        this.contentPopupMenu.add(new JMenuItem(this.getCutAction()));
        this.contentPopupMenu.add(new JMenuItem(this.getCopyAction()));
        this.contentPopupMenu.add(new JMenuItem(this.getPasteAction()));
        this.contentPopupMenu.add(new JMenuItem(this.getDeleteAction()));
        this.contentPopupMenu.add(new JSeparator());
        ButtonGroup displayModeGroup = new ButtonGroup();
        this.contentInkItem = new JRadioButtonMenuItem(this.getChangeContentDisplayModeAction(Content.INK));
        this.contentPopupMenu.add(this.contentInkItem);
        displayModeGroup.add(this.contentInkItem);
        this.contentTextItem = new JRadioButtonMenuItem(this.getChangeContentDisplayModeAction(Content.TEXT));
        this.contentPopupMenu.add(this.contentTextItem);
        displayModeGroup.add(this.contentTextItem);
        this.contentPictureItem = new JRadioButtonMenuItem(this.getChangeContentDisplayModeAction(Content.IMAGE));
        this.contentPopupMenu.add(this.contentPictureItem);
        displayModeGroup.add(this.contentPictureItem);
        this.contentMixedItem = new JRadioButtonMenuItem();
        displayModeGroup.add(this.contentInkItem);
        this.contentPopupMenu.add(new JSeparator());
        this.contentPopupMenu.add(new JMenuItem(this.changeContentPictureAction));
        PCamera camera = this.getCamera();
        CameraTransformListener cameraTransformListener = new CameraTransformListener();
        camera.addPropertyChangeListener("viewTransform", cameraTransformListener);
    }

    protected void beforeSetModeByName() {
        DamaskAppMode appMode = this.getMode();
        if (appMode.getName().equals(CHANGE_CONTROL_STATE_MODE)) {
            Iterator i = ((VisualLayer)this.getLayer()).getDialogViewsIncludingTemplates().iterator();
            while (i.hasNext()) {
                DialogView dialogView = (DialogView)i.next();
                Iterator j = dialogView.getChildrenIterator();
                while (j.hasNext()) {
                    PageView pageView = (PageView)j.next();
                    pageView.setInRunMode(false);
                }
            }
            this.addInputEventListener(this.getPopupMenuEventHandler());
        } else if (appMode.getName().equals(TEXT_MODE)) {
            ((TextHandler)((VisualMode)appMode).getPageHandler()).stopEditing();
            Iterator i = ((VisualLayer)this.getLayer()).getDialogViewsIncludingTemplates().iterator();
            while (i.hasNext()) {
                DialogView dialogView = (DialogView)i.next();
                Iterator j = dialogView.getChildrenIterator();
                while (j.hasNext()) {
                    PageView pageView = (PageView)j.next();
                    Iterator k = pageView.getContents().getChildrenIterator();
                    while (k.hasNext()) {
                        PageRegionView pageRegionView = (PageRegionView)k.next();
                        Iterator m = pageRegionView.getChildrenIterator();
                        while (m.hasNext()) {
                            PNode child = (PNode)m.next();
                            if (!(child instanceof TextBox)) continue;
                            ((TextBox)child).setInRunMode(false);
                        }
                    }
                }
            }
        } else if (appMode.getName().equals(SPLIT_MODE)) {
            ((SplitEventHandler)((VisualMode)appMode).getPageHandler()).cleanUp();
        }
    }

    protected void afterSetModeByName() {
        DamaskAppMode appMode = this.getMode();
        if (appMode.getName().equals(CHANGE_CONTROL_STATE_MODE)) {
            Iterator i = ((VisualLayer)this.getLayer()).getDialogViewsIncludingTemplates().iterator();
            while (i.hasNext()) {
                DialogView dialogView = (DialogView)i.next();
                Iterator j = dialogView.getChildrenIterator();
                while (j.hasNext()) {
                    PageView pageView = (PageView)j.next();
                    pageView.setInRunMode(true);
                }
            }
            this.removeInputEventListener(this.getPopupMenuEventHandler());
        } else if (appMode.getName().equals("Pan")) {
            this.attachHandles(null, this.getCamera());
        } else if (appMode.getName().equals(TEXT_MODE)) {
            Iterator i = ((VisualLayer)this.getLayer()).getDialogViewsIncludingTemplates().iterator();
            while (i.hasNext()) {
                DialogView dialogView = (DialogView)i.next();
                Iterator j = dialogView.getChildrenIterator();
                while (j.hasNext()) {
                    PageView pageView = (PageView)j.next();
                    Iterator k = pageView.getContents().getChildrenIterator();
                    while (k.hasNext()) {
                        PageRegionView pageRegionView = (PageRegionView)k.next();
                        Iterator m = pageRegionView.getChildrenIterator();
                        while (m.hasNext()) {
                            PNode child = (PNode)m.next();
                            if (!(child instanceof TextBox)) continue;
                            ((TextBox)child).setInRunMode(true);
                        }
                    }
                }
            }
        }
    }

    protected void setModeEventHandlerEnabled(boolean flag) {
        PNode insideNode = this.getInsideNode();
        DamaskAppMode appMode = this.getMode();
        if (!(appMode instanceof VisualMode)) {
            super.setModeEventHandlerEnabled(flag);
            return;
        }
        VisualMode visualMode = (VisualMode)appMode;
        if (flag) {
            Cursor cursorToUse;
            if (insideNode instanceof PageRegionView || insideNode instanceof DamaskWindowTitle) {
                this.appModeHandler = visualMode.getPageHandler();
                cursorToUse = visualMode.getPageCursor();
            } else if (insideNode instanceof ComponentView) {
                Object contents;
                ComponentView componentView = (ComponentView)insideNode;
                this.appModeHandler = visualMode.getPageHandler();
                cursorToUse = visualMode.getControlCursor();
                if (appMode.getName() == PENCIL_MODE && componentView.getParent() instanceof DamaskWindowTitle && ((Label)(contents = componentView.getEditableContents())).getDisplayMode() == Content.TEXT) {
                    this.appModeHandler = this.textHandler;
                    cursorToUse = Cursor.getPredefinedCursor(2);
                }
            } else {
                this.appModeHandler = visualMode.getDefaultHandler();
                if (insideNode instanceof PBoundsHandle && !(insideNode instanceof NonResizableHandle)) {
                    PBoundsHandle handle = (PBoundsHandle)insideNode;
                    cursorToUse = handle.getCursorFor(((PBoundsLocator)handle.getLocator()).getSide());
                } else {
                    cursorToUse = appMode.getDefaultCursor();
                }
            }
            this.addInputEventListener(this.appModeHandler);
            this.setCursor(cursorToUse);
        } else {
            this.removeInputEventListener(this.appModeHandler);
            this.setCursor(null);
        }
    }

    public void stopTextEditing() {
        this.textHandler.stopEditing();
    }

    public void setProperCursor() {
        DamaskAppMode appMode = this.getMode();
        if (appMode instanceof VisualMode) {
            VisualMode visualMode = (VisualMode)appMode;
            PNode insideNode = this.getInsideNode();
            if (insideNode instanceof PageRegionView || insideNode instanceof DamaskWindowTitle) {
                this.setCursor(visualMode.getPageCursor());
            } else if (insideNode instanceof ComponentView) {
                this.setCursor(visualMode.getControlCursor());
            } else {
                this.setCursor(visualMode.getDefaultCursor());
            }
        } else {
            super.setProperCursor();
        }
    }

    protected void sliderModelStateChanged(ChangeEvent e) {
        Point2D zoomCenter;
        PCamera camera = this.getCamera();
        if (this.isZoomCenteredAtUpperLeft()) {
            zoomCenter = POINT00;
        } else if (this.getZoomCenterMousePosition() == null) {
            if (this.selectedPageView == null) {
                zoomCenter = camera.getViewBounds().getCenter2D();
            } else {
                PBounds bounds = this.selectedPageView.getBounds();
                this.selectedPageView.localToGlobal(bounds);
                zoomCenter = bounds.getCenter2D();
            }
        } else {
            zoomCenter = this.getZoomCenterMousePosition();
        }
        camera.scaleViewAboutPoint(DamaskCanvas.scaleFactor(this.getSliderModel().getValue()) / camera.getViewScale(), zoomCenter.getX(), zoomCenter.getY());
        logger.info(this + ": Zoom level changed to " + this.getSliderModel().getValue());
    }

    protected Page getDropTarget(Point2D layerDropPt) {
        List dialogViews = ((VisualLayer)this.getLayer()).getDialogViews();
        Page dropPage = null;
        Iterator i = dialogViews.iterator();
        while (i.hasNext()) {
            DialogView dialogView = (DialogView)i.next();
            Iterator j = dialogView.getChildrenIterator();
            while (j.hasNext()) {
                PNode child = (PNode)j.next();
                PBounds childGlobalBounds = child.getBounds();
                child.localToGlobal(childGlobalBounds);
                if (!childGlobalBounds.contains(layerDropPt) || !(child instanceof PageView)) continue;
                dropPage = (Page)((PageView)child).getModel();
            }
        }
        return dropPage;
    }

    public void attachHandles(DamaskWindow pageView, PCamera camera) {
        if (this.getMode() != null && "Pan".equals(this.getMode().getName()) && pageView != null) {
            return;
        }
        if (pageView == this.selectedPageView) {
            return;
        }
        super.attachHandles(pageView, camera);
        if (this.selectedPageView != null) {
            ((PageViewContents)this.selectedPageView.getContents()).removeRegionResizingBorders();
        }
        this.selectedPageView = (PageView)pageView;
        this.fireSelectedPageChanged();
        if (this.selectedPageView != null) {
            ((PageViewContents)this.selectedPageView.getContents()).addRegionResizingBorders(camera);
            if (this.selectedPageRegionView == null || this.selectedPageRegionView.getPageView() != this.selectedPageView) {
                this.setSelectedPageRegionView(((PageViewContents)pageView.getContents()).getRegionView(Direction.CENTER));
            }
        }
    }

    public void setControlState(Control control, Object state) {
        Dialog controlDialog;
        Dialog pageDialog = ((Page)this.selectedPageView.getModel()).getDialog();
        int condition = pageDialog == (controlDialog = control.getDialog()) ? this.selectedPageView.getDesignTimeCondition() : controlDialog.getInitialCondition();
        control.setStateForCondition(controlDialog, condition, state);
    }

    public int getSelectedPageCondition() {
        return this.selectedPageView.getDesignTimeCondition();
    }

    public void goToPage(Page page) {
        PCamera camera = this.getCamera();
        PBounds viewBounds = camera.getViewBounds();
        PageView pageView = (PageView)((DamaskLayer)this.getLayer()).getView(page);
        PBounds pageViewBdsInCameraCoords = pageView.getBounds();
        pageView.localToGlobal(pageViewBdsInCameraCoords);
        camera.globalToLocal(pageViewBdsInCameraCoords);
        double deltaX = viewBounds.getCenterX() - pageViewBdsInCameraCoords.getCenterX();
        double deltaY = viewBounds.getCenterY() - pageViewBdsInCameraCoords.getCenterY();
        PAffineTransform at = camera.getViewTransform();
        at.translate(deltaX, deltaY);
        camera.animateViewToTransform(at, 500L);
    }

    public ControlView getFocus() {
        return this.focus;
    }

    public void setFocus(ControlView controlView) {
        this.focus = controlView;
    }

    public PageView getSelectedPageView() {
        return this.selectedPageView;
    }

    public Page getSelectedPage() {
        if (this.selectedPageView == null) {
            return null;
        }
        return (Page)this.selectedPageView.getModel();
    }

    public PageRegionView getSelectedPageRegionView() {
        return this.selectedPageRegionView;
    }

    public void setSelectedPageRegionView(PageRegionView regionView) {
        if (this.selectedPageRegionView != null) {
            this.selectedPageRegionView.setStrokePaint(PageRegionView.BORDER_COLOR);
        }
        this.selectedPageRegionView = regionView;
        if (this.selectedPageRegionView != null) {
            this.selectedPageRegionView.setStrokePaint(PageRegionView.SELECTED_BORDER_COLOR);
        }
    }

    public PageRegion getPasteTargetPageRegion() {
        PageRegion targetRegion;
        PageRegionView targetRegionView = this.getSelectedPageRegionView();
        if (targetRegionView == null) {
            Page homePage = this.getDocument().getGraph().getHomePage(this.getDeviceType());
            if (homePage == null) {
                return null;
            }
            targetRegion = homePage.getRegion(Direction.CENTER);
        } else {
            targetRegion = (PageRegion)targetRegionView.getModel();
        }
        return targetRegion;
    }

    public Collection getSelectedLabels() {
        return Collections.unmodifiableCollection(this.selectedLabels);
    }

    public Content.DisplayMode getSelectedLabelsMode() {
        Content.DisplayMode selectedDisplayMode = null;
        boolean moreThanOneMode = false;
        Iterator i = this.selectedLabels.iterator();
        while (i.hasNext()) {
            Label label = (Label)i.next();
            if (selectedDisplayMode == null) {
                selectedDisplayMode = label.getDisplayMode();
                continue;
            }
            if (selectedDisplayMode == label.getDisplayMode()) continue;
            moreThanOneMode = true;
        }
        if (moreThanOneMode) {
            return null;
        }
        return selectedDisplayMode;
    }

    public JPopupMenu getPopupMenu(PNode pickedNode, boolean isPickedNodeSelectable) {
        if (!isPickedNodeSelectable) {
            if (pickedNode instanceof PageViewPart || pickedNode instanceof DamaskWindowTitle) {
                return this.pagePopupMenu;
            }
        } else {
            if (this.selectedLabels.isEmpty()) {
                this.contentMixedItem.setSelected(true);
            } else {
                Content.DisplayMode selectedDisplayMode = this.getSelectedLabelsMode();
                if (selectedDisplayMode == Content.INK) {
                    this.contentInkItem.setSelected(true);
                } else if (selectedDisplayMode == Content.TEXT) {
                    this.contentTextItem.setSelected(true);
                } else if (selectedDisplayMode == Content.IMAGE) {
                    this.contentPictureItem.setSelected(true);
                } else {
                    this.contentMixedItem.setSelected(true);
                }
            }
            if (pickedNode instanceof ComponentView) {
                ComponentView componentView = (ComponentView)pickedNode;
                Object contents = componentView.getEditableContents();
                if (contents instanceof Label) {
                    return this.contentPopupMenu;
                }
                return super.getPopupMenu(pickedNode, isPickedNodeSelectable);
            }
        }
        return null;
    }

    public Action getChangeContentDisplayModeAction(Content.DisplayMode mode) {
        return (Action)this.changeContentDisplayModeActions.get(mode);
    }

    public Action getChangeContentPictureAction() {
        return this.changeContentPictureAction;
    }

    public Action getCopyPageAction() {
        return this.copyPageAction;
    }

    public Action getCutPageAction() {
        return this.cutPageAction;
    }

    public Action getDeletePageAction() {
        return this.deletePageAction;
    }

    public Action getPastePageAction() {
        return this.pastePageAction;
    }

    public Action getSetHomePageAction() {
        return this.setHomePageAction;
    }

    public Action getRunFromHomeAction() {
        return this.runFromHomeAction;
    }

    public Action getRunFromSelectedPageAction() {
        return this.runFromSelectedPageAction;
    }

    public Action getGroupStrokesAction() {
        return this.groupStrokesAction;
    }

    public Action getUngroupStrokesAction() {
        return this.ungroupStrokesAction;
    }

    private class SelectionChangeHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.VisualCanvas$SelectionChangeHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        SelectionChangeHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != VisualCanvas.this) {
                throw new AssertionError((Object)("should be receiving events from " + VisualCanvas.this + ", not " + e.getCanvas()));
            }
            VisualCanvas.this.selectedLabels.clear();
            Iterator i = VisualCanvas.this.getSelectedObjects().iterator();
            while (i.hasNext()) {
                ComponentView componentView;
                Object editableContents;
                PNode node = (PNode)i.next();
                if (!(node instanceof ComponentView) || !((editableContents = (componentView = (ComponentView)node).getEditableContents()) instanceof Label)) continue;
                VisualCanvas.this.selectedLabels.add(editableContents);
            }
            boolean areLabelsSelected = !VisualCanvas.this.selectedLabels.isEmpty();
            Iterator i2 = VisualCanvas.this.changeContentDisplayModeActions.keySet().iterator();
            while (i2.hasNext()) {
                Content.DisplayMode mode = (Content.DisplayMode)i2.next();
                Action action = (Action)VisualCanvas.this.changeContentDisplayModeActions.get(mode);
                action.setEnabled(areLabelsSelected);
            }
            VisualCanvas.this.changeContentPictureAction.setEnabled(VisualCanvas.this.selectedLabels.size() == 1);
            int numInkLabels = 0;
            Iterator i3 = VisualCanvas.this.getSelectedObjects().iterator();
            while (i3.hasNext()) {
                PNode node = (PNode)i3.next();
                if (!(node instanceof Label) || ((Label)node).getDisplayMode() != Content.INK) continue;
                ++numInkLabels;
            }
            VisualCanvas.this.ungroupStrokesAction.setEnabled(numInkLabels >= 1);
            VisualCanvas.this.groupStrokesAction.setEnabled(numInkLabels >= 2);
        }

        public void selectedPageChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != VisualCanvas.this) {
                throw new AssertionError((Object)("should be receiving events from " + VisualCanvas.this + ", not " + e.getCanvas()));
            }
            boolean hasSelectedPage = VisualCanvas.this.selectedPageView != null;
            VisualCanvas.this.cutPageAction.setEnabled(hasSelectedPage);
            VisualCanvas.this.copyPageAction.setEnabled(hasSelectedPage);
            VisualCanvas.this.deletePageAction.setEnabled(hasSelectedPage);
            if (hasSelectedPage) {
                boolean isSelectedPageHome = VisualCanvas.this.getDocument().getGraph().getHomePage(VisualCanvas.this.getDeviceType()) == VisualCanvas.this.selectedPageView.getModel();
                VisualCanvas.this.setHomePageAction.setEnabled(!isSelectedPageHome);
            } else {
                VisualCanvas.this.setHomePageAction.setEnabled(false);
            }
            VisualCanvas.this.getRunFromSelectedPageAction().setEnabled(hasSelectedPage);
        }
    }

    private class CameraTransformListener
    implements PropertyChangeListener {
        CameraTransformListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            VisualCanvas.this.textHandler.stopEditing();
        }
    }

    private class CutPageAction
    extends AbstractAction {
        public CutPageAction() {
            super("Cut Page");
            this.putValue("ShortDescription", "Cuts the selected page into the clipboard");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent e) {
            VisualCanvas.this.getCopyPageAction().actionPerformed(e);
            VisualCanvas.this.getDeletePageAction().actionPerformed(e);
        }
    }

    private class CopyPageAction
    extends AbstractAction {
        public CopyPageAction() {
            super("Copy Page");
            this.putValue("ShortDescription", "Copies the selected page into the clipboard");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("Begin copy page");
            ArrayList<PageView> selectedPageList = new ArrayList<PageView>();
            selectedPageList.add(VisualCanvas.this.getSelectedPageView());
            VisualCanvas.this.setObjectsToCopy(selectedPageList);
            TransferHandler handler = VisualCanvas.this.getTransferHandler();
            handler.exportToClipboard(VisualCanvas.this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            VisualCanvas.this.getPasteAction().setEnabled(true);
            logger.info("End copy page");
        }
    }

    private class PastePageAction
    extends AbstractAction {
        public PastePageAction() {
            super("Paste Page");
            this.putValue("ShortDescription", "Pastes the contents of the clipboard");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            TransferHandler handler;
            logger.info("Begin paste page");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(this);
            if (clipData != null && (handler = VisualCanvas.this.getTransferHandler()).canImport(VisualCanvas.this, clipData.getTransferDataFlavors())) {
                handler.importData(VisualCanvas.this, clipData);
            }
            logger.info("End paste page");
        }
    }

    private class DeletePageAction
    extends AbstractAction {
        public DeletePageAction() {
            super("Delete Page");
            this.putValue("ShortDescription", "Deletes the selected page");
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            VisualCanvas.this.getDocument().getCommandQueue().doCommand(VisualCanvas.this, new RemoveDialogCommand(((Page)VisualCanvas.this.getSelectedPageView().getModel()).getDialog()));
        }
    }

    private class SetHomePageAction
    extends AbstractAction {
        public SetHomePageAction() {
            super("Set as Home Page");
            this.putValue("ShortDescription", "Sets the selected page as the home page");
            this.putValue("MnemonicKey", new Integer(72));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VisualCanvas.this.getLayer();
            VisualCanvas.this.getDocument().getCommandQueue().doCommand(VisualCanvas.this, new SetHomePageCommand(layer.getDocument().getGraph(), layer.getDeviceType(), (Page)VisualCanvas.this.getSelectedPageView().getModel()));
            this.setEnabled(false);
        }
    }

    private class RunFromHomeAction
    extends AbstractAction {
        public RunFromHomeAction() {
            super("Run from Home Page");
            this.putValue("ShortDescription", "Runs this document");
            this.putValue("MnemonicKey", new Integer(72));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("run_from_home.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("run_from_home.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VisualCanvas.this.getLayer();
            DamaskDocument document = layer.getDocument();
            DeviceType deviceType = layer.getDeviceType();
            Page homePage = document.getGraph().getHomePage(deviceType);
            JFrame runFrame = deviceType == DeviceType.SMARTPHONE ? new DamaskPhoneRunFrame(document.getDisplayedFileName(), homePage) : new DamaskRunFrame(document.getDisplayedFileName(), homePage);
            runFrame.setVisible(true);
        }
    }

    private class RunFromSelectedPageAction
    extends AbstractAction {
        public RunFromSelectedPageAction() {
            super("Run from Selected Page");
            this.putValue("ShortDescription", "Runs this document from the selected page");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("run.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("run.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)VisualCanvas.this.getLayer();
            DamaskDocument document = layer.getDocument();
            Page selectedPage = VisualCanvas.this.getSelectedPage();
            JFrame runFrame = layer.getDeviceType() == DeviceType.SMARTPHONE ? new DamaskPhoneRunFrame(document.getDisplayedFileName(), selectedPage) : new DamaskRunFrame(document.getDisplayedFileName(), selectedPage);
            runFrame.setVisible(true);
        }
    }

    private class ChangeContentDisplayModeAction
    extends AbstractAction {
        private final Content.DisplayMode mode;

        public ChangeContentDisplayModeAction(Content.DisplayMode mode) {
            super(mode.toString());
            this.putValue("ShortDescription", "Changes the representation of the selected label to " + mode.toString().toLowerCase());
            char mnemonic = mode.toString().toLowerCase().charAt(0);
            this.putValue("MnemonicKey", new Integer(mnemonic));
            this.mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Iterator i = VisualCanvas.this.selectedLabels.iterator();
            while (i.hasNext()) {
                Label label = (Label)i.next();
                if (label.getDisplayMode() == this.mode) continue;
                Content content = (Content)label.getModel();
                cmd.addCommand(new SetContentDisplayModeCommand(content, content.getDeviceType(), this.mode));
            }
            if (!cmd.isEmpty()) {
                VisualCanvas.this.getDocument().getCommandQueue().doCommand(VisualCanvas.this, cmd);
            }
        }
    }

    private class ChangeContentPictureAction
    extends AbstractAction {
        public ChangeContentPictureAction() {
            super("Change Picture...");
            this.putValue("ShortDescription", "Changes the picture representation of the selected label to another picture");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            Label label = (Label)VisualCanvas.this.selectedLabels.iterator().next();
            label.tryToChangeImage(VisualCanvas.this);
        }
    }

    private class GroupStrokesAction
    extends AbstractAction {
        public GroupStrokesAction() {
            super("Group ink strokes");
            this.putValue("ShortDescription", "Groups the selected ink strokes");
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("group.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("group.png"));
        }

        public void actionPerformed(ActionEvent e) {
            HashMap<PageRegion, TreeSet<Content>> contentToGroup = new HashMap<PageRegion, TreeSet<Content>>();
            Iterator i = VisualCanvas.this.getSelectedObjects().iterator();
            while (i.hasNext()) {
                PNode node = (PNode)i.next();
                if (!(node instanceof Label) || ((Label)node).getDisplayMode() != Content.INK) continue;
                Content content = (Content)((InteractionElementView)node).getModel();
                PageRegion region = content.getPageRegion(VisualCanvas.this.getDeviceType());
                TreeSet<Content> contentToGroupInRegion = (TreeSet<Content>)contentToGroup.get(region);
                if (contentToGroupInRegion == null) {
                    contentToGroupInRegion = new TreeSet<Content>(new Comparator(this){
                        final /* synthetic */ GroupStrokesAction this$1;
                        {
                            this.this$1 = groupStrokesAction;
                        }

                        public int compare(Object o1, Object o2) {
                            int i2;
                            PageRegion r1 = ((Content)o1).getPageRegion(GroupStrokesAction.access$0(this.this$1).getDeviceType());
                            PageRegion r2 = ((Content)o2).getPageRegion(GroupStrokesAction.access$0(this.this$1).getDeviceType());
                            int i1 = r1.getControls().indexOf(o1);
                            if (i1 < (i2 = r2.getControls().indexOf(o2))) {
                                return -1;
                            }
                            if (i1 == i2) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    contentToGroup.put(region, contentToGroupInRegion);
                }
                contentToGroupInRegion.add(content);
            }
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Iterator i2 = contentToGroup.keySet().iterator();
            while (i2.hasNext()) {
                PageRegion region = (PageRegion)i2.next();
                Collection contents = (Collection)contentToGroup.get(region);
                cmd.addCommand(new GroupStrokesCommand(contents, VisualCanvas.this.getDeviceType()));
            }
            if (!cmd.isEmpty()) {
                VisualCanvas.this.getDocument().getCommandQueue().doCommand(VisualCanvas.this, cmd);
            }
        }

        static /* synthetic */ VisualCanvas access$0(GroupStrokesAction groupStrokesAction) {
            return groupStrokesAction.VisualCanvas.this;
        }
    }

    private class UngroupStrokesAction
    extends AbstractAction {
        public UngroupStrokesAction() {
            super("Ungroup ink strokes");
            this.putValue("ShortDescription", "Ungroups the selected ink strokes");
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("ungroup.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("ungroup.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Content content;
            ArrayList<Content> contentToUngroup = new ArrayList<Content>();
            Iterator i = VisualCanvas.this.getSelectedObjects().iterator();
            while (i.hasNext()) {
                PNode node = (PNode)i.next();
                if (!(node instanceof Label) || ((Label)node).getDisplayMode() != Content.INK) continue;
                content = (Content)((InteractionElementView)node).getModel();
                contentToUngroup.add(content);
            }
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Iterator i2 = contentToUngroup.iterator();
            while (i2.hasNext()) {
                content = (Content)i2.next();
                cmd.addCommand(new UngroupStrokesCommand(content));
            }
            if (!cmd.isEmpty()) {
                VisualCanvas.this.getDocument().getCommandQueue().doCommand(VisualCanvas.this, cmd);
            }
        }
    }
}

