/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual;

import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.appevent.RunCanvasEventSource;
import edu.berkeley.guir.damask.view.appevent.RunCanvasListener;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.TextBox;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContainer;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DamaskRunCanvas
extends PCanvas
implements PageViewContainer {
    private Page currentPage = null;
    private PageView currentPageView = null;
    private final Stack backStack = new Stack();
    private final Stack forwardStack = new Stack();
    private ControlView focus = null;
    private RunCanvasEventSource eventSource = new RunCanvasEventSource();
    private final Map textFieldToTextInput = new HashMap();
    private final Map textInputToText = new HashMap();
    private JScrollBar horizontalScrollBar = null;
    private JScrollBar verticalScrollBar = null;
    private AdjustmentListener horizontalScrollBarHandler = new HorizontalScrollBarHandler();
    private AdjustmentListener verticalScrollBarHandler = new VerticalScrollBarHandler();
    private int horizontalValue = 0;
    private int verticalValue = 0;

    public DamaskRunCanvas() {
        this.setLayout(null);
        this.removeInputEventListener(this.getPanEventHandler());
    }

    public synchronized void addRunCanvasListener(RunCanvasListener listener) {
        this.eventSource.addRunCanvasListener(listener);
    }

    public synchronized void removeRunCanvasListener(RunCanvasListener listener) {
        this.eventSource.removeRunCanvasListener(listener);
    }

    protected void fireLoadCompleted() {
        this.eventSource.fireLoadCompleted(this);
    }

    public ControlView getFocus() {
        return this.focus;
    }

    public void setFocus(ControlView controlView) {
        this.focus = controlView;
    }

    public void goToPage(Page page) {
        if (this.currentPage != null) {
            this.backStack.push(this.currentPage);
        }
        this.forwardStack.clear();
        this.currentPage = page;
        this.displayCurrentPage();
    }

    public void goBack() {
        this.forwardStack.push(this.currentPage);
        this.currentPage = (Page)this.backStack.pop();
        this.displayCurrentPage();
    }

    public boolean canGoBack() {
        return !this.backStack.isEmpty();
    }

    public void goForward() {
        this.backStack.push(this.currentPage);
        this.currentPage = (Page)this.forwardStack.pop();
        this.displayCurrentPage();
    }

    public boolean canGoForward() {
        return !this.forwardStack.isEmpty();
    }

    public PageView getCurrentPageView() {
        return this.currentPageView;
    }

    public void setContainingScrollPane(JScrollPane scrollPane) {
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.removeAdjustmentListener(this.horizontalScrollBarHandler);
        }
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.verticalScrollBarHandler);
        }
        this.horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        this.verticalScrollBar = scrollPane.getVerticalScrollBar();
        this.horizontalScrollBar.addAdjustmentListener(this.horizontalScrollBarHandler);
        this.verticalScrollBar.addAdjustmentListener(this.verticalScrollBarHandler);
    }

    protected void displayCurrentPage() {
        this.getLayer().removeAllChildren();
        int i = this.getComponentCount() - 1;
        while (i >= 0) {
            Component component = this.getComponent(i);
            if (component instanceof JTextField) {
                JTextField textField = (JTextField)component;
                TextInput textInput = (TextInput)this.textFieldToTextInput.get(textField);
                this.textInputToText.put(textInput, textField.getText());
                this.textFieldToTextInput.remove(textField);
                this.remove(i);
            }
            --i;
        }
        this.currentPageView = new PageView(this.currentPage, false);
        this.currentPageView.setInRunMode(true);
        this.currentPageView.setListenToTransformChanges(false);
        this.getLayer().removeAllChildren();
        this.getLayer().addChild(this.currentPageView);
        this.currentPageView.getFullBounds();
        Rectangle2D titleBarFullBounds = this.currentPageView.getTitleBar().getPathReference().getBounds2D();
        this.currentPageView.getTitleBar().localToGlobal(titleBarFullBounds);
        this.currentPageView.getParent().globalToLocal(titleBarFullBounds);
        this.currentPageView.setOffset(0.0, titleBarFullBounds.getHeight());
        this.currentPageView.getTitleBar().setStrokePaint(null);
        this.currentPageView.getContents().setStrokePaint(null);
        Iterator i2 = this.currentPageView.getContents().getChildrenIterator();
        while (i2.hasNext()) {
            PageRegionView pageRegionView = (PageRegionView)i2.next();
            pageRegionView.setStrokePaint(null);
            Iterator j = pageRegionView.getChildrenIterator();
            while (j.hasNext()) {
                PNode child = (PNode)j.next();
                if (!(child instanceof TextBox)) continue;
                TextBox textBox = (TextBox)child;
                JTextField textField = new JTextField();
                PBounds textBoxGlobalBds = textBox.getBounds();
                child.localToGlobal(textBoxGlobalBds);
                textField.setLocation((int)((RectangularShape)textBoxGlobalBds).getX() - this.horizontalValue, (int)((RectangularShape)textBoxGlobalBds).getY() - this.verticalValue);
                textField.setSize((int)((RectangularShape)textBoxGlobalBds).getWidth(), (int)((RectangularShape)textBoxGlobalBds).getHeight());
                TextInput textInput = (TextInput)textBox.getModel();
                String textBoxString = (String)this.textInputToText.get(textInput);
                if (textBoxString == null) {
                    Dialog controlDialog = textInput.getDialog();
                    textBoxString = (String)textInput.getStateForCondition(controlDialog, controlDialog.getInitialCondition());
                }
                textField.setText(textBoxString);
                this.textFieldToTextInput.put(textField, textInput);
                this.add(textField);
            }
        }
        this.fireLoadCompleted();
    }

    public void setControlState(Control control, Object state) {
        ((ControlView)DamaskAppUtils.getView(this.getLayer(), control)).setState(state);
    }

    public int getSelectedPageCondition() {
        HashMap<InteractionElement, Object> controlStates = new HashMap<InteractionElement, Object>();
        Iterator i = ((PageViewContents)this.currentPageView.getContents()).getRegionViews().iterator();
        while (i.hasNext()) {
            PageRegionView regionView = (PageRegionView)i.next();
            Iterator j = regionView.getChildrenIterator();
            while (j.hasNext()) {
                ComponentView componentView = (ComponentView)j.next();
                if (!(componentView instanceof ControlView)) continue;
                ControlView controlView = (ControlView)componentView;
                controlStates.put(controlView.getModel(), controlView.getState());
            }
        }
        return this.currentPage.getDialog().getCondition(controlStates);
    }

    private class HorizontalScrollBarHandler
    implements AdjustmentListener {
        HorizontalScrollBarHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int dx = e.getValue() - DamaskRunCanvas.this.horizontalValue;
            int i = 0;
            int n = DamaskRunCanvas.this.getComponentCount();
            while (i < n) {
                Component component = DamaskRunCanvas.this.getComponent(i);
                Point oldLocation = component.getLocation();
                component.setLocation(oldLocation.x - dx, oldLocation.y);
                ++i;
            }
            DamaskRunCanvas.this.horizontalValue = e.getValue();
        }
    }

    private class VerticalScrollBarHandler
    implements AdjustmentListener {
        VerticalScrollBarHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int dy = e.getValue() - DamaskRunCanvas.this.verticalValue;
            int i = 0;
            int n = DamaskRunCanvas.this.getComponentCount();
            while (i < n) {
                Component component = DamaskRunCanvas.this.getComponent(i);
                Point oldLocation = component.getLocation();
                component.setLocation(oldLocation.x, oldLocation.y - dy);
                ++i;
            }
            DamaskRunCanvas.this.verticalValue = e.getValue();
        }
    }
}

