/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.view.appevent.RunCanvasEvent;
import edu.berkeley.guir.damask.view.appevent.RunCanvasListener;
import edu.berkeley.guir.damask.view.visual.DamaskRunCanvas;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DamaskPhoneRunFrame
extends JFrame {
    private static final Logger logger;
    private final DamaskRunCanvas canvas;
    private final PScrollPane scrollPane;
    private final JPanel mainKeypad;
    private final JPanel southKeypad;
    private final JPanel northKeypad;
    private JPanel southKeypadSouth;
    private JPanel southKeypadNorth;
    private JPanel northKeypadWest;
    private JPanel northKeypadEast;
    private JPanel northKeypadCenter;
    private JButton send;
    private JButton end;
    private JButton one;
    private JButton two;
    private JButton three;
    private JButton four;
    private JButton five;
    private JButton six;
    private JButton seven;
    private JButton eight;
    private JButton nine;
    private JButton zero;
    private JButton asterisk;
    private JButton pound;
    private JButton leftdot;
    private JButton rightdot;
    private JButton home;
    private JButton back;
    private JButton left;
    private JButton right;
    private JButton top;
    private JButton bottom;
    private JButton ok;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.DamaskPhoneRunFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DamaskPhoneRunFrame(String documentName, Page page) {
        DeviceType deviceType = page.getDeviceType();
        this.setTitle(String.valueOf(documentName) + " [Run - " + deviceType + "] - Damask");
        this.canvas = new DamaskRunCanvas();
        this.canvas.addRunCanvasListener(new RunCanvasHandler());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.scrollPane = new PScrollPane(this.canvas);
        this.canvas.setContainingScrollPane(this.scrollPane);
        contentPane.add((Component)this.scrollPane, "Center");
        this.mainKeypad = new JPanel(new BorderLayout());
        this.southKeypad = new JPanel(new BorderLayout());
        this.northKeypad = new JPanel(new BorderLayout());
        this.mainKeypad.add((Component)this.southKeypad, "South");
        this.mainKeypad.add((Component)this.northKeypad, "North");
        contentPane.add((Component)this.mainKeypad, "South");
        this.initKeypad();
        this.canvas.goToPage(page);
        this.setVisible(true);
        Insets insets = this.getInsets();
        this.canvas.setPreferredSize(new Dimension(deviceType.getDefaultWidth() + insets.left + insets.right, deviceType.getDefaultHeight() + (int)this.canvas.getCurrentPageView().getOffset().getY() + insets.top + insets.bottom));
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.pack();
        WindowHandler winHandler = new WindowHandler();
        this.addWindowListener(winHandler);
        this.addWindowFocusListener(winHandler);
        logger.info(this + " opened with view of " + this.canvas.getCurrentPageView().getModel());
    }

    private void initKeypad() {
        this.send = new JButton("Send");
        this.end = new JButton("End");
        this.one = new JButton("1");
        this.two = new JButton("2");
        this.three = new JButton("3");
        this.four = new JButton("4");
        this.five = new JButton("5");
        this.six = new JButton("6");
        this.seven = new JButton("7");
        this.eight = new JButton("8");
        this.nine = new JButton("9");
        this.asterisk = new JButton("*");
        this.zero = new JButton("0");
        this.pound = new JButton("#");
        this.leftdot = new JButton("...");
        this.rightdot = new JButton("...");
        this.home = new JButton("Home");
        this.back = new JButton(new BackAction());
        this.top = new JButton(this.getRadarIcon("top.gif"));
        this.bottom = new JButton(this.getRadarIcon("bottom.gif"));
        this.left = new JButton(this.getRadarIcon("left.gif"));
        this.right = new JButton(this.getRadarIcon("right.gif"));
        this.ok = new JButton("ok");
        this.southKeypadNorth = new JPanel(new BorderLayout());
        this.southKeypadSouth = new JPanel();
        this.northKeypadWest = new JPanel();
        this.northKeypadEast = new JPanel();
        this.northKeypadCenter = new JPanel(new BorderLayout());
        this.southKeypadNorth.add((Component)this.send, "West");
        this.southKeypadNorth.add((Component)this.end, "East");
        this.southKeypadSouth.setLayout(new GridLayout(0, 3));
        this.southKeypadSouth.add(this.one);
        this.southKeypadSouth.add(this.two);
        this.southKeypadSouth.add(this.three);
        this.southKeypadSouth.add(this.four);
        this.southKeypadSouth.add(this.five);
        this.southKeypadSouth.add(this.six);
        this.southKeypadSouth.add(this.seven);
        this.southKeypadSouth.add(this.eight);
        this.southKeypadSouth.add(this.nine);
        this.southKeypadSouth.add(this.asterisk);
        this.southKeypadSouth.add(this.zero);
        this.southKeypadSouth.add(this.pound);
        this.northKeypadWest.setLayout(new GridLayout(2, 0));
        this.northKeypadEast.setLayout(new GridLayout(2, 0));
        this.northKeypadWest.add(this.leftdot);
        this.northKeypadWest.add(this.home);
        this.northKeypadEast.add(this.rightdot);
        this.northKeypadEast.add(this.back);
        this.northKeypadCenter.add((Component)this.ok, "Center");
        this.northKeypadCenter.add((Component)this.top, "North");
        this.northKeypadCenter.add((Component)this.bottom, "South");
        this.northKeypadCenter.add((Component)this.left, "West");
        this.northKeypadCenter.add((Component)this.right, "East");
        this.southKeypad.add((Component)this.southKeypadSouth, "South");
        this.southKeypad.add((Component)this.southKeypadNorth, "North");
        this.northKeypad.add((Component)this.northKeypadWest, "West");
        this.northKeypad.add((Component)this.northKeypadEast, "East");
        this.northKeypad.add((Component)this.northKeypadCenter, "Center");
    }

    protected ImageIcon getRadarIcon(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image image = toolkit.createImage(clazz.getResource("images/radar/" + fileName));
        return new ImageIcon(image);
    }

    protected void updateButtonsEnabled() {
        this.back.setEnabled(this.canvas.canGoBack());
    }

    public String toString() {
        return DamaskUtils.toShortString(this);
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back");
            this.putValue("ShortDescription", "Go back to the previous page");
            this.putValue("MnemonicKey", new Integer(37));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskPhoneRunFrame.this.canvas.goBack();
            logger.info(DamaskPhoneRunFrame.this + ": back -> " + DamaskPhoneRunFrame.this.canvas.getCurrentPageView().getModel());
        }
    }

    private class RunCanvasHandler
    implements RunCanvasListener {
        RunCanvasHandler() {
        }

        public void loadCompleted(RunCanvasEvent e) {
            logger.info(DamaskPhoneRunFrame.this + " loaded with view of " + DamaskPhoneRunFrame.this.canvas.getCurrentPageView().getModel());
            DamaskPhoneRunFrame.this.updateButtonsEnabled();
            DamaskPhoneRunFrame.this.scrollPane.getVerticalScrollBar().setValue(DamaskPhoneRunFrame.this.scrollPane.getVerticalScrollBar().getMinimum());
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            logger.info(DamaskPhoneRunFrame.this + " closed");
        }

        public void windowGainedFocus(WindowEvent e) {
            logger.info(DamaskPhoneRunFrame.this + " gained focus");
        }

        public void windowLostFocus(WindowEvent e) {
            logger.info(DamaskPhoneRunFrame.this + " lost focus");
        }
    }
}

